/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.isqlviewer.core.IPCListener;

public class IPCService
implements Runnable {
    private Vector msgQueue = new Vector(1);
    private HashMap topics = new HashMap(2, 0.8f);

    IPCService() {
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.processNextMessage();
                }
            }
            catch (Throwable t) {
                if (!Thread.interrupted()) continue;
                return;
            }
            break;
        }
    }

    public void publish(Object src, String topic, Object msg) {
        if (topic == null) {
            return;
        }
        if (!this.topics.containsKey(topic)) {
            return;
        }
        SimpleMessage sm = new SimpleMessage();
        sm.topic = topic;
        sm.msg = msg;
        sm.src = src;
        this.addMessage(sm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(IPCListener mh, String topic) {
        if (this.topics.containsKey(topic)) {
            HashMap hashMap = this.topics;
            synchronized (hashMap) {
                ArrayList listeners = (ArrayList)this.topics.get(topic);
                if (!listeners.contains(mh)) {
                    ArrayList arrayList = listeners;
                    synchronized (arrayList) {
                        listeners.add(mh);
                    }
                }
            }
        }
        ArrayList<IPCListener> listeners = new ArrayList<IPCListener>(1);
        listeners.add(0, mh);
        HashMap hashMap = this.topics;
        synchronized (hashMap) {
            this.topics.put(topic, listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe(IPCListener mh, String topic) {
        if (this.topics.containsKey(topic)) {
            HashMap hashMap = this.topics;
            synchronized (hashMap) {
                ArrayList listeners = (ArrayList)this.topics.get(topic);
                if (!listeners.contains(mh)) {
                    ArrayList arrayList = listeners;
                    synchronized (arrayList) {
                        listeners.remove(mh);
                    }
                }
                if (listeners.isEmpty()) {
                    this.topics.remove(topic);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribeAll(IPCListener mh) {
        HashMap hashMap = this.topics;
        synchronized (hashMap) {
            Iterator itr = this.topics.keySet().iterator();
            while (itr.hasNext()) {
                String publication = (String)itr.next();
                ArrayList listeners = (ArrayList)this.topics.get(publication);
                if (listeners.contains(mh)) {
                    ArrayList arrayList = listeners;
                    synchronized (arrayList) {
                        listeners.remove(mh);
                    }
                }
                if (!listeners.isEmpty()) continue;
                this.topics.remove(publication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void clearSubscriptions() {
        HashMap hashMap = this.topics;
        synchronized (hashMap) {
            Iterator itr = this.topics.keySet().iterator();
            while (itr.hasNext()) {
                ArrayList listeners;
                String publication = (String)itr.next();
                ArrayList arrayList = listeners = (ArrayList)this.topics.get(publication);
                synchronized (arrayList) {
                    listeners.clear();
                    this.topics.remove(publication);
                }
            }
        }
    }

    private synchronized void addMessage(SimpleMessage msg) {
        this.msgQueue.add(msg);
        try {
            this.notify();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized SimpleMessage getNextMessage() {
        if (this.msgQueue.size() == 0) {
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.msgQueue.isEmpty()) {
            return null;
        }
        SimpleMessage msg = (SimpleMessage)this.msgQueue.firstElement();
        this.msgQueue.removeElementAt(0);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextMessage() {
        SimpleMessage msg = this.getNextMessage();
        if (msg == null) {
            return;
        }
        HashMap hashMap = this.topics;
        synchronized (hashMap) {
            ArrayList listeners;
            ArrayList arrayList = listeners = (ArrayList)this.topics.get(msg.topic);
            synchronized (arrayList) {
                for (int i = 0; i < listeners.size(); ++i) {
                    IPCListener mh = (IPCListener)listeners.get(i);
                    if (mh == null) continue;
                    try {
                        mh.receiveMessage(msg.src, msg.topic, msg.msg);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
        System.runFinalization();
    }

    private class SimpleMessage {
        private Object src;
        private Object msg;
        private String topic;

        private SimpleMessage() {
        }
    }
}

