/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.isqlviewer.core.HistoryItem;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class HistoryManager {
    public static final String IPC_SERVICE_CHANGE = "isql-service-change";
    public static final int STYLE_GLOBAL = 0;
    public static final int STYLE_DRIVER = 1;
    public static final int STYLE_SERVICE = 2;
    private final ChangeEvent changeEvent = new ChangeEvent(this);
    private final Calendar cal = new GregorianCalendar();
    private final File parentDir = SystemConfig.getiSQLSubDir(BasicUtilities.getString("History_Folder"));
    private ArrayList dataStore = new ArrayList();
    private ArrayList changeListeners = null;
    private int browseIdx = 0;
    private Thread loadThread = null;
    private String dbcID = null;
    private long sessionEpoch = 0L;
    private UserPreferences prefs = null;
    private HistorySupport support = new HistorySupport();

    static HistoryManager createInstance(SystemConfig config) {
        return new HistoryManager(config);
    }

    private HistoryManager(SystemConfig cfg) {
        this.prefs = cfg.getPreferences();
        cfg.getPreferences().addPreferenceChangeListener(this.support);
        cfg.getIPCService().subscribe(this.support, IPC_SERVICE_CHANGE);
        if (this.prefs.getInt("history.style") == 0) {
            File f = new File(this.parentDir, BasicUtilities.getString("History_Autoload_File"));
            this.loadThread = new Thread(new HistoryLoader(this, f));
            this.loadThread.start();
        }
    }

    public void addHistoryItem(String txt, DatabaseConnection cnx) {
        HistoryItem item = new HistoryItem(cnx.getConnectionName(), txt);
        this.addHistoryItem(item);
        this.browseIdx = 0;
    }

    public boolean isEmpty() {
        return this.dataStore.isEmpty();
    }

    public boolean allowsDuplicates() {
        return this.prefs.getBoolean("history.duplicates-enabled");
    }

    public boolean isCircular() {
        return this.prefs.getBoolean("history.circular-enabled");
    }

    public HistoryItem get(int index) {
        try {
            return (HistoryItem)this.dataStore.get(index);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public HistoryItem newer() {
        --this.browseIdx;
        boolean cycle = this.isCircular();
        this.browseIdx = this.browseIdx < 0 ? (cycle ? this.size() - 1 : 0) : this.browseIdx;
        return this.get(this.browseIdx);
    }

    public HistoryItem older() {
        ++this.browseIdx;
        boolean cycle = this.isCircular();
        this.browseIdx = this.browseIdx >= this.size() ? (cycle ? 0 : this.size() - 1) : this.browseIdx;
        return this.get(this.browseIdx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File f) {
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            FileOutputStream fos = null;
            try {
                f = new File(f.getParentFile(), BasicUtilities.getString("History_File_Template", f.getName()));
                fos = new FileOutputStream(f);
                PrintWriter w = new PrintWriter(fos, true);
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    Iterator itr = this.dataStore.iterator();
                    while (itr.hasNext()) {
                        HistoryItem i = (HistoryItem)itr.next();
                        w.print(i.getSQLData());
                        w.println(";");
                    }
                }
                System.out.println(BasicUtilities.getString("File_Saved", f.getAbsolutePath()));
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "HistoryManager::store(" + f + ")");
            }
            finally {
                f = null;
                try {
                    fos.close();
                }
                catch (Throwable t2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryItem(HistoryItem item) {
        if (item == null) {
            return;
        }
        try {
            boolean timeOK;
            boolean chkSize = this.getMaximumSize() >= 1;
            boolean chkTime = this.getMaximumDays() >= 1;
            boolean sizeOK = !chkSize;
            boolean bl = timeOK = !chkTime;
            if (chkTime) {
                int days = this.getMaximumDays();
                Date now = item.getTimeStamp();
                if (now == null) {
                    now = new Date();
                }
                this.cal.setTime(new Date());
                this.rollActuallDays(days);
                Date then = this.cal.getTime();
                timeOK = now.after(then);
                if (!timeOK) {
                    return;
                }
            }
            if (chkSize) {
                int sz = this.size();
                sizeOK = sz + 1 < this.getMaximumSize();
            }
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                if (!sizeOK) {
                    this.dataStore.remove(this.dataStore.size() - 1);
                }
                if (this.allowsDuplicates()) {
                    HistoryItem.setComparableMode(1, this.prefs.getBoolean("history.crc32-enabled"));
                    int old = this.dataStore.indexOf(item);
                    String sql = item.getSQLData();
                    if (old >= 0) {
                        item = (HistoryItem)this.dataStore.remove(old);
                        if (this.useCRC32()) {
                            item.updateSQL(sql);
                        }
                        item.updateTimestamp();
                    }
                }
                this.dataStore.add(0, item);
                this.browseIdx = 0;
            }
            this.fireStateChanged();
        }
        catch (Throwable t) {
            BasicUtilities.HandleException(t, "HistoryManager::addHistoryItem(HistoryItem)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection sublist(Date start, Date end) {
        ArrayList<HistoryItem> lst = new ArrayList<HistoryItem>();
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            Iterator itr = this.dataStore.iterator();
            while (itr.hasNext()) {
                HistoryItem i = (HistoryItem)itr.next();
                Date ts = i.getTimeStamp();
                if (!ts.before(end) || !ts.after(start)) continue;
                lst.add(i);
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getHistory() {
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            return (Collection)this.dataStore.clone();
        }
    }

    public int getCursorIndex() {
        return this.browseIdx;
    }

    public void setCursorIndex(int newIndex) {
        this.browseIdx = Math.max(0, Math.min(this.size(), newIndex));
    }

    public Date getSessionTime() {
        return new Date(this.sessionEpoch);
    }

    public boolean isSessionPerserved() {
        return this.prefs.getBoolean("history.sessionclear-enabled");
    }

    public int getSessionStyle() {
        return this.prefs.getInt("history.style");
    }

    public int size() {
        return this.dataStore.size();
    }

    public int getMaximumSize() {
        return this.prefs.getInt("history.max-count");
    }

    public int getMaximumDays() {
        return this.prefs.getInt("history.max-days");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        ArrayList<ChangeListener> l;
        ArrayList<ChangeListener> arrayList = l = this.changeListeners == null ? new ArrayList<ChangeListener>() : this.changeListeners;
        if (!l.contains(cl)) {
            ArrayList<ChangeListener> arrayList2 = l;
            synchronized (arrayList2) {
                l.add(cl);
            }
        }
        this.changeListeners = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        if (this.changeListeners == null) {
            return;
        }
        if (this.changeListeners.contains(cl)) {
            ArrayList arrayList = this.changeListeners;
            synchronized (arrayList) {
                this.changeListeners.remove(cl);
            }
        }
    }

    void shutdown(SystemConfig cfg) {
        boolean sessionOnly;
        cfg.getPreferences().removePreferenceChangeListener(this.support);
        cfg.getIPCService().unSubscribeAll(this.support);
        if (this.changeListeners != null) {
            this.changeListeners.clear();
            this.changeListeners = null;
        }
        if (!(sessionOnly = this.prefs.getBoolean("history.persistent-enabled"))) {
            if (this.prefs.getInt("history.style") == 0) {
                File f = new File(this.parentDir, BasicUtilities.getString("History_Autoload_File"));
                this.saveCurrent(f);
            } else if (this.dbcID != null) {
                this.saveCurrent(this.dbcID);
            }
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        if (!this.isSessionPerserved()) {
            ArrayList arrayList = this.dataStore;
            synchronized (arrayList) {
                this.dataStore.clear();
            }
        }
        Date epoch = new Date(this.sessionEpoch);
        ArrayList arrayList = this.dataStore;
        synchronized (arrayList) {
            Iterator itr = this.dataStore.iterator();
            while (itr.hasNext()) {
                HistoryItem i = (HistoryItem)itr.next();
                if (!i.getTimeStamp().before(epoch)) continue;
                try {
                    itr.remove();
                }
                catch (Throwable t) {}
            }
        }
        this.fireStateChanged();
    }

    protected synchronized void saveCurrent(String fd) {
        File f = new File(this.parentDir, BasicUtilities.getString("History_File_Template", fd));
        this.saveCurrent(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveCurrent(File f) {
        HistoryManager historyManager = this;
        synchronized (historyManager) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                PrintWriter w = new PrintWriter(fos, true);
                ArrayList arrayList = this.dataStore;
                synchronized (arrayList) {
                    Iterator itr = this.dataStore.iterator();
                    while (itr.hasNext()) {
                        HistoryItem i = (HistoryItem)itr.next();
                        w.println(HistoryItem.encode(i));
                        w.println();
                    }
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "HistoryManager::saveCurrent(" + f + ")");
            }
            finally {
                f = null;
                try {
                    fos.close();
                }
                catch (Throwable t2) {}
            }
        }
    }

    protected void updateHistoryKey(String newKey) {
        if (this.dbcID == newKey || newKey == null) {
            return;
        }
        if (this.dbcID == null) {
            this.dbcID = newKey;
        } else if (!this.dbcID.equals(newKey)) {
            if (this.prefs.getBoolean("history.persistent-enabled")) {
                this.clear();
            } else {
                this.saveCurrent(this.dbcID);
                this.dbcID = newKey;
            }
        }
    }

    protected boolean useCRC32() {
        return this.prefs.getBoolean("history.crc32-enabled");
    }

    protected void updateHistorySet(DatabaseConnection cnx) {
        String key = null;
        switch (this.getSessionStyle()) {
            case 1: {
                key = cnx == null ? null : cnx.getDriver().getClass().getName();
                break;
            }
            case 2: {
                key = cnx == null ? null : cnx.getConnectionName();
                break;
            }
        }
        this.updateHistoryKey(key);
        if (key != null) {
            File f = new File(this.parentDir, BasicUtilities.getString("History_File_Template", key));
            this.loadThread = new Thread(new HistoryLoader(this, f));
            this.loadThread.start();
        }
    }

    protected void rollActuallDays(int days) {
        int doy = this.cal.get(6);
        int diy = this.cal.getActualMaximum(6);
        if (days >= diy) {
            int ytr;
            for (ytr = days / diy; ytr > 0; --ytr) {
                this.cal.roll(1, -1 * ytr);
                diy = this.cal.getActualMaximum(6);
            }
            this.cal.roll(6, -1 * (days - ytr * diy));
            return;
        }
        if (doy <= days) {
            this.cal.roll(1, false);
        }
        this.cal.roll(6, -1 * days);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStateChanged() {
        if (this.changeListeners == null) {
            return;
        }
        ArrayList arrayList = this.changeListeners;
        synchronized (arrayList) {
            Iterator itr = this.changeListeners.iterator();
            while (itr.hasNext()) {
                ChangeListener cl = (ChangeListener)itr.next();
                try {
                    cl.stateChanged(this.changeEvent);
                }
                catch (Throwable t) {}
            }
        }
    }

    private static class HistoryLoader
    implements Runnable {
        private File file = null;
        private HistoryManager manager = null;

        public HistoryLoader(HistoryManager mgr, File f) {
            this.file = f;
            this.manager = mgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            InputStreamReader fr = null;
            BufferedReader br = null;
            StringBuffer buff = new StringBuffer("");
            try {
                ArrayList arrayList = this.manager.dataStore;
                synchronized (arrayList) {
                    fr = new FileReader(this.file);
                    br = new BufferedReader(fr);
                    while (br.ready()) {
                        String line = br.readLine();
                        if (line.trim().length() == 0) {
                            try {
                                this.manager.addHistoryItem(HistoryItem.decode(buff.toString()));
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            buff.setLength(0);
                            continue;
                        }
                        buff.append(line);
                        buff.append('\n');
                    }
                    Object[] arr = this.manager.dataStore.toArray();
                    HistoryItem.setComparableMode(0, this.manager.prefs.getBoolean("history.crc32-enabled"));
                    Arrays.sort(arr);
                    this.manager.dataStore.clear();
                    this.manager.dataStore.addAll(Arrays.asList(arr));
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    br.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                try {
                    fr.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
                this.manager.sessionEpoch = System.currentTimeMillis();
                this.manager.fireStateChanged();
                throw throwable;
            }
        }
    }

    private class HistorySupport
    implements IPCListener,
    PreferenceChangeListener {
        private HistorySupport() {
        }

        public void receiveMessage(Object src, String topic, Object msg) {
            if (topic.equals(HistoryManager.IPC_SERVICE_CHANGE)) {
                HistoryManager.this.updateHistorySet((DatabaseConnection)msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preferenceChange(PreferenceChangeEvent event) {
            String key = event.getKey();
            String val = event.getNewValue();
            if (val == null) {
                return;
            }
            if (key.equals("history.style")) {
                return;
            }
            if (key.equals("history.max-count")) {
                int sz = Integer.parseInt(val);
                if (sz < HistoryManager.this.size()) {
                    ArrayList arrayList = HistoryManager.this.dataStore;
                    synchronized (arrayList) {
                        for (int i = HistoryManager.this.size() - 1; i > sz; --i) {
                            HistoryManager.this.dataStore.remove(i);
                        }
                    }
                }
                return;
            }
            if (key.equals("history.max-days")) {
                boolean chkTime;
                boolean bl = chkTime = Integer.parseInt(val) >= 1;
                if (!chkTime) {
                    return;
                }
                if (!HistoryManager.this.isEmpty()) {
                    HistoryManager.this.cal.setTime(new Date());
                    HistoryManager.this.cal.roll(6, -1 * HistoryManager.this.prefs.getInt(key));
                    Date epoch = HistoryManager.this.cal.getTime();
                    ArrayList arrayList = HistoryManager.this.dataStore;
                    synchronized (arrayList) {
                        Iterator itr = HistoryManager.this.dataStore.iterator();
                        while (itr.hasNext()) {
                            HistoryItem i = (HistoryItem)itr.next();
                            if (!i.getTimeStamp().before(epoch)) continue;
                            try {
                                itr.remove();
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                return;
            }
        }
    }
}

