/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.compressor;

import com.googlecode.htmlcompressor.compressor.Compressor;
import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCompressor
implements Compressor {
    private boolean enabled = true;
    private boolean removeComments = true;
    private boolean removeMultiSpaces = true;
    private boolean removeIntertagSpaces = false;
    private boolean removeQuotes = false;
    private boolean compressJavaScript = false;
    private boolean compressCss = false;
    private List<Pattern> preservePatterns = null;
    private boolean yuiJsNoMunge = false;
    private boolean yuiJsPreserveAllSemiColons = false;
    private boolean yuiJsDisableOptimizations = false;
    private int yuiJsLineBreak = -1;
    private int yuiCssLineBreak = -1;
    private static final String tempCondCommentBlock = "<%%%COMPRESS~COND~{0}%%%>";
    private static final String tempPreBlock = "%%%COMPRESS~PRE~{0}%%%";
    private static final String tempTextAreaBlock = "%%%COMPRESS~TEXTAREA~{0}%%%";
    private static final String tempScriptBlock = "%%%COMPRESS~SCRIPT~{0}%%%";
    private static final String tempStyleBlock = "%%%COMPRESS~STYLE~{0}%%%";
    private static final String tempEventBlock = "%%%COMPRESS~EVENT~{0}%%%";
    private static final String tempUserBlock = "%%%COMPRESS~USER{0}~{1}%%%";
    private static final Pattern condCommentPattern = Pattern.compile("(<!(?:--)?\\[[^\\]]+?]>)(.*?)(<!\\[[^\\]]+]-->)", 34);
    private static final Pattern commentPattern = Pattern.compile("<!--[^\\[].*?-->", 34);
    private static final Pattern intertagPattern = Pattern.compile(">\\s+?<", 34);
    private static final Pattern multispacePattern = Pattern.compile("\\s{2,}", 34);
    private static final Pattern tagEndSpacePattern = Pattern.compile("(<(?:[^>]+?))(?:\\s+?)(/?>)", 34);
    private static final Pattern tagQuotePattern = Pattern.compile("\\s*=\\s*([\"'])([a-z0-9-_]+?)\\1(?=[^<]*?>)", 2);
    private static final Pattern prePattern = Pattern.compile("(<pre[^>]*?>)(.*?)(</pre>)", 34);
    private static final Pattern taPattern = Pattern.compile("(<textarea[^>]*?>)(.*?)(</textarea>)", 34);
    private static final Pattern scriptPattern = Pattern.compile("(<script[^>]*?>)(.*?)(</script>)", 34);
    private static final Pattern stylePattern = Pattern.compile("(<style[^>]*?>)(.*?)(</style>)", 34);
    private static final Pattern tagPropertyPattern = Pattern.compile("(\\s\\w+)\\s=\\s(?=[^<]*?>)", 2);
    private static final Pattern cdataPattern = Pattern.compile("\\s*<!\\[CDATA\\[(.*?)\\]\\]>\\s*", 34);
    private static final Pattern eventPattern1 = Pattern.compile("(\\son[a-z]+\\s*=\\s*\")([^\"\\\\\\r\\n]*(?:\\\\.[^\"\\\\\\r\\n]*)*)(\")", 2);
    private static final Pattern eventPattern2 = Pattern.compile("(\\son[a-z]+\\s*=\\s*')([^'\\\\\\r\\n]*(?:\\\\.[^'\\\\\\r\\n]*)*)(')", 2);
    private static final Pattern tempCondCommentPattern = Pattern.compile("<%%%COMPRESS~COND~(\\d+?)%%%>", 34);
    private static final Pattern tempPrePattern = Pattern.compile("%%%COMPRESS~PRE~(\\d+?)%%%", 34);
    private static final Pattern tempTextAreaPattern = Pattern.compile("%%%COMPRESS~TEXTAREA~(\\d+?)%%%", 34);
    private static final Pattern tempScriptPattern = Pattern.compile("%%%COMPRESS~SCRIPT~(\\d+?)%%%", 34);
    private static final Pattern tempStylePattern = Pattern.compile("%%%COMPRESS~STYLE~(\\d+?)%%%", 34);
    private static final Pattern tempEventPattern = Pattern.compile("%%%COMPRESS~EVENT~(\\d+?)%%%", 34);
    private ErrorReporter yuiErrorReporter = null;

    @Override
    public String compress(String html) throws Exception {
        if (!this.enabled || html == null || html.length() == 0) {
            return html;
        }
        ArrayList<String> condCommentBlocks = new ArrayList<String>();
        ArrayList<String> preBlocks = new ArrayList<String>();
        ArrayList<String> taBlocks = new ArrayList<String>();
        ArrayList<String> scriptBlocks = new ArrayList<String>();
        ArrayList<String> styleBlocks = new ArrayList<String>();
        ArrayList<String> eventBlocks = new ArrayList<String>();
        ArrayList<List<String>> userBlocks = new ArrayList<List<String>>();
        html = this.preserveBlocks(html, preBlocks, taBlocks, scriptBlocks, styleBlocks, eventBlocks, condCommentBlocks, userBlocks);
        html = this.processHtml(html);
        this.processScriptBlocks(scriptBlocks);
        this.processStyleBlocks(styleBlocks);
        html = this.returnBlocks(html, preBlocks, taBlocks, scriptBlocks, styleBlocks, eventBlocks, condCommentBlocks, userBlocks);
        return html.trim();
    }

    private String preserveBlocks(String html, List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<List<String>> userBlocks) throws Exception {
        if (this.preservePatterns != null) {
            for (int p = 0; p < this.preservePatterns.size(); ++p) {
                ArrayList<String> userBlock = new ArrayList<String>();
                Matcher matcher = this.preservePatterns.get(p).matcher(html);
                int index = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    if (matcher.group(0).trim().length() <= 0) continue;
                    userBlock.add(matcher.group(0));
                    matcher.appendReplacement(sb, MessageFormat.format(tempUserBlock, p, index++));
                }
                matcher.appendTail(sb);
                html = sb.toString();
                userBlocks.add(userBlock);
            }
        }
        Matcher matcher = condCommentPattern.matcher(html);
        int index = 0;
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            condCommentBlocks.add(matcher.group(1) + this.compress(matcher.group(2)) + matcher.group(3));
            matcher.appendReplacement(sb, MessageFormat.format(tempCondCommentBlock, index++));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern1.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempEventBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = eventPattern2.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            eventBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempEventBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = prePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            preBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempPreBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = scriptPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            scriptBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempScriptBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = stylePattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            styleBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempStyleBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = taPattern.matcher(html);
        index = 0;
        sb = new StringBuffer();
        while (matcher.find()) {
            if (matcher.group(2).trim().length() <= 0) continue;
            taBlocks.add(matcher.group(2));
            matcher.appendReplacement(sb, "$1" + MessageFormat.format(tempTextAreaBlock, index++) + "$3");
        }
        matcher.appendTail(sb);
        html = sb.toString();
        return html;
    }

    private String returnBlocks(String html, List<String> preBlocks, List<String> taBlocks, List<String> scriptBlocks, List<String> styleBlocks, List<String> eventBlocks, List<String> condCommentBlocks, List<List<String>> userBlocks) {
        Matcher matcher = tempTextAreaPattern.matcher(html);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(taBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempStylePattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(styleBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempScriptPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(scriptBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempPrePattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(preBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempEventPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(eventBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        matcher = tempCondCommentPattern.matcher(html);
        sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, Matcher.quoteReplacement(condCommentBlocks.get(Integer.parseInt(matcher.group(1)))));
        }
        matcher.appendTail(sb);
        html = sb.toString();
        if (this.preservePatterns != null) {
            for (int p = this.preservePatterns.size() - 1; p >= 0; --p) {
                Pattern tempUserPattern = Pattern.compile("%%%COMPRESS~USER" + p + "~(\\d+?)%%%");
                matcher = tempUserPattern.matcher(html);
                sb = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(userBlocks.get(p).get(Integer.parseInt(matcher.group(1)))));
                }
                matcher.appendTail(sb);
                html = sb.toString();
            }
        }
        return html;
    }

    private String processHtml(String html) {
        if (this.removeComments) {
            html = commentPattern.matcher(html).replaceAll("");
        }
        if (this.removeIntertagSpaces) {
            html = intertagPattern.matcher(html).replaceAll("><");
        }
        if (this.removeMultiSpaces) {
            html = multispacePattern.matcher(html).replaceAll(" ");
        }
        if (this.removeQuotes) {
            html = tagQuotePattern.matcher(html).replaceAll("=$2");
        }
        html = tagPropertyPattern.matcher(html).replaceAll("$1=");
        html = tagEndSpacePattern.matcher(html).replaceAll("$1$2");
        return html;
    }

    private void processScriptBlocks(List<String> scriptBlocks) throws Exception {
        if (this.compressJavaScript) {
            for (int i = 0; i < scriptBlocks.size(); ++i) {
                scriptBlocks.set(i, this.compressJavaScript(scriptBlocks.get(i)));
            }
        }
    }

    private void processStyleBlocks(List<String> styleBlocks) throws Exception {
        if (this.compressCss) {
            for (int i = 0; i < styleBlocks.size(); ++i) {
                styleBlocks.set(i, this.compressCssStyles(styleBlocks.get(i)));
            }
        }
    }

    private String compressJavaScript(String source) throws Exception {
        boolean cdataWrapper = false;
        Matcher matcher = cdataPattern.matcher(source);
        if (matcher.matches()) {
            cdataWrapper = true;
            source = matcher.group(1);
        }
        StringWriter result = new StringWriter();
        JavaScriptCompressor compressor = new JavaScriptCompressor((Reader)new StringReader(source), this.yuiErrorReporter);
        compressor.compress((Writer)result, this.yuiJsLineBreak, !this.yuiJsNoMunge, false, this.yuiJsPreserveAllSemiColons, this.yuiJsDisableOptimizations);
        if (cdataWrapper) {
            return "<![CDATA[" + result.toString() + "]]>";
        }
        return result.toString();
    }

    private String compressCssStyles(String source) throws Exception {
        StringWriter result = new StringWriter();
        CssCompressor compressor = new CssCompressor((Reader)new StringReader(source));
        compressor.compress((Writer)result, this.yuiCssLineBreak);
        return result.toString();
    }

    public boolean isCompressJavaScript() {
        return this.compressJavaScript;
    }

    public void setCompressJavaScript(boolean compressJavaScript) {
        this.compressJavaScript = compressJavaScript;
    }

    public boolean isCompressCss() {
        return this.compressCss;
    }

    public void setCompressCss(boolean compressCss) {
        this.compressCss = compressCss;
    }

    public boolean isYuiJsNoMunge() {
        return this.yuiJsNoMunge;
    }

    public void setYuiJsNoMunge(boolean yuiJsNoMunge) {
        this.yuiJsNoMunge = yuiJsNoMunge;
    }

    public boolean isYuiJsPreserveAllSemiColons() {
        return this.yuiJsPreserveAllSemiColons;
    }

    public void setYuiJsPreserveAllSemiColons(boolean yuiJsPreserveAllSemiColons) {
        this.yuiJsPreserveAllSemiColons = yuiJsPreserveAllSemiColons;
    }

    public boolean isYuiJsDisableOptimizations() {
        return this.yuiJsDisableOptimizations;
    }

    public void setYuiJsDisableOptimizations(boolean yuiJsDisableOptimizations) {
        this.yuiJsDisableOptimizations = yuiJsDisableOptimizations;
    }

    public int getYuiJsLineBreak() {
        return this.yuiJsLineBreak;
    }

    public void setYuiJsLineBreak(int yuiJsLineBreak) {
        this.yuiJsLineBreak = yuiJsLineBreak;
    }

    public int getYuiCssLineBreak() {
        return this.yuiCssLineBreak;
    }

    public void setYuiCssLineBreak(int yuiCssLineBreak) {
        this.yuiCssLineBreak = yuiCssLineBreak;
    }

    public boolean isRemoveQuotes() {
        return this.removeQuotes;
    }

    public void setRemoveQuotes(boolean removeQuotes) {
        this.removeQuotes = removeQuotes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRemoveComments() {
        return this.removeComments;
    }

    public void setRemoveComments(boolean removeComments) {
        this.removeComments = removeComments;
    }

    public boolean isRemoveMultiSpaces() {
        return this.removeMultiSpaces;
    }

    public void setRemoveMultiSpaces(boolean removeMultiSpaces) {
        this.removeMultiSpaces = removeMultiSpaces;
    }

    public boolean isRemoveIntertagSpaces() {
        return this.removeIntertagSpaces;
    }

    public void setRemoveIntertagSpaces(boolean removeIntertagSpaces) {
        this.removeIntertagSpaces = removeIntertagSpaces;
    }

    public List<Pattern> getPreservePatterns() {
        return this.preservePatterns;
    }

    public void setPreservePatterns(List<Pattern> preservePatterns) {
        this.preservePatterns = preservePatterns;
    }

    public ErrorReporter getYuiErrorReporter() {
        return this.yuiErrorReporter;
    }

    public void setYuiErrorReporter(ErrorReporter yuiErrorReporter) {
        this.yuiErrorReporter = yuiErrorReporter;
    }
}

