#include <hp48/lcd.h>

#define YMIN 0xfee66666		/* (int)(-1.10 << 24) */
#define YMAX 0x0119999a		/* (int)( 1.10 << 24) */
#define XMIN 0xfd266666		/* (int)(-2.85 << 24) */
#define XMAX 0x01a66666		/* (int)( 1.65 << 24) */

#define BREAKOUT 0x04000000
#define MAXITER 64

#define FIXED_MUL(x,y) ((int)(((long long)x * (long long)y) >> 24))

int
msetlev (int cx, int cy)
{
  int i;
  int x, y;
  int x2, y2;

  x = cx;
  y = cy;
  for (i = 1; i < MAXITER; i++)
    { 
      x2 = FIXED_MUL (x, x);
      y2 = FIXED_MUL (y, y);
      if ((unsigned int)(x2 + y2) >= BREAKOUT)
	break;
      y = 2 * FIXED_MUL (x, y) + cy;
      x = x2 - y2 + cx;
    }
  return i;
}


int
main (int argc, char **argv)
{
  eint 	x, y;
  int	ix, iy, l;
  int	deltax, deltay;

  deltay = (YMAX - YMIN) / LCD_HEIGHT;
  deltax = (XMAX - XMIN) / LCD_WIDTH;

  initscr ();
  clrscr ();

  iy = YMIN;
  for (y = 0; y < LCD_HEIGHT; y++)
    {
      ix = XMIN;
      for (x = 0; x < LCD_WIDTH; x++)
        {
	  setpixel (x, y);
          l = msetlev (ix, iy);
          if (l < MAXITER && l & 0x01)
	    clrpixel (x, y);
          ix += deltax;
        }
      iy += deltay;
    }

  exitscr ();
  return 0;
}

