/* $Id: malloc.c,v 1.1.1.2 1995/07/11 22:17:21 alex Exp $
 * Malloc library implementation.
 * Copyright (C) 1994 Alex T Ramos
 *
 * This file is part of the HP48 C Library, which is part of hp48xgcc.
 *
 * hp48xgcc is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * hp48xgcc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hp48xgcc; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <malloc.h>	/* Comply with own prototypes */
#include <hp48/core.h>

void	*malloc(size_t size)
{
    struct { int prolog:20; int length:20; } *h = sys_malloc(10 + 2*size);
    
    if(h) {
	/* "look normal" to avoid crash on next GC */
	h->prolog = 0x02A2C;
        h->length = 5 + 2*size;
	return h+10;
    }
    else {
	/* search through the free list HERE */
	return h;
    }
}

void	free(void *ptr)
{
    typedef struct { int nib:4; } nib;
    ((nib *)ptr)->nib = 1;
}


