/* Copyright (C) 1995 Eddie C. Dost
This file is part of the HP48 C Library.

The HP48 C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License
as published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The HP48 C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Library General Public License for more details. */

#include <rom.h>

	xref	___packsb
	xdef	_hypot

_hypot
	;
	; Floating point C.W := sqrt (B.W * B.W + R0.W * R0.W)
	;
	exg.a	c,d1
	push			; save frame-pointer
	exg.a	c,d1
	move.w	b,a
	move.w	r0,c
	jsr	SPLITAC		; calls setdec

	move.w	c,r1
	move.w	d,c
	move.w	c,r3		; arg2 in R1/R3

	move.w	b,c
	move.w	c,d
	move.w	a,c		; arg1 in A/B and C/D

	jsr	MULTF

	move.w	b,c
	exg.w	c,r3
	move.w	c,b
	move.w	c,d
	exg.w	a,r1		; arg1 * arg1 in R1/R3
	move.w	a,c		; arg2 in A/B and C/D

	jsr	MULTF		; arg2 * arg2 in A/B

	move.w	r3,c
	move.w	c,d
	move.w	r1,c		; arg1 * arg1 in C/D

	jsr	ADDF
	jsr	SQRTF
	jsr	___packsb
	sethex			; restore hexmode
	move.1	#7,p		; restore p
	pop
	move.a	c,d1		; restore frame-pointer
	move.w	a,c
	rtn

