
	; Relocator and Dynamic Linker for gcc-compiled HP48 programs
	; Should be stored in { HOME } as "GCCLDD"

	; assemble with class -a gccldd.s -o GCCLDD -exe

	; This code was written by Lutz Vieweg <lkv@mania.robin.de> 1994
	; It's in the public domain - do whatever you like with it.

DOCOL		equ	$02d9d
CK1NOLASTWD	equ	$18ab2
SEMI		equ	$0312b
CKandDISPATCH1	equ	$18fb2
DOHSTR		equ	$02a4e
DOBINT		equ	$02911
DOCODE		equ	$02dcc
GARBAGE		equ	$05F42
MEM		equ	$05F61
MAKEHXS		equ	$0EDE1
DIVIDEBY2	equ	$03E8E

save_regs	equ	$0679b
restore_regs    equ     $067d2
pusha		equ	$03A86

	textr	"HPHP48-E"

	dcr.5	DOCOL

	dcr.5	CK1NOLASTWD

	dcr.5	DOCOL	
	dcr.5	CKandDISPATCH1
	
	dcr.5	DOBINT
	dcr.5	$000AF

	; the following action is taken only when type == LibraryData

	dcr.5 	DOCOL
	dcr.5	GARBAGE

	dcr.5	DOCODE
code_start
	dcr.5	code_end-code_start
	
	; GLOBAL REGISTERS:
	; r2  used by reloc
	; r3  pointer to the reference-table

	jsr		save_regs

	bsr		drop		; drop the executable object, d1 points to the next stack-level
	sub.a		#5,d1		; adjust d1 to point to the level that was just dropped
	
	move.a	(d1),c	; adr. of executable lib-data object
	bsr		reloc		; resolve the relocations
			; d0 points now to the start of the reference-table
	move.a	r2,c		; recall the last-relocation-address storage pointer
	move.a	c,d1		; 
	move.a	(d1),c	; recall the last-relocation-address
	move.a	c,(d0)	; and store it as the first entry of the reference-table

	exg.a		d0,c		; store the pointer to the reference-table
	move.a	c,r3		; in r3 for later use.
	exg.a		c,d0		; and continue to use it...
.2
	add.a		#5,d0		; advance pointer to the next reference-table entry
	move.a	(d0),c	; get this entry
	beq.a		c,0,.1	; if it's == 0, no further shared libraries are to be linked
	
	; look for the next shared-lib on the stack
	exg.a		d0,c		; save the current reference-table pointer
	move.a	c,r0		; in r0, we need it after the relocation...
	
	bsr		drop		; drop the shared library from the stack,
	sub.a		#5,d1		; and adjust d1 to point to the just dropped stack-level
	move.a	(d1),c	; get the address of the shared-library object
	bsr		reloc		; check it for validity, and relocate it.
		
	move.a	r2,c		; recall the last-relocation-address storage pointer
	move.a	c,d1		;
	move.a	r0,c		; recall the current reference-table pointer...
	move.a	c,d0		; 
	move.a	(d1),c	; ..where we have to store the base-address of the
	move.a	c,(d0)	; just relocated shared library

	bra		.2			; ok, proceed with the next shared library (if there is one)

.1	
	; all shared libs are now relocated, and there base-address is stored
	; in the reference-table (which is pointed to by r3)
	; we may now parse the code-import table 

	add.a		#5,d0		; adjust d0 to point to the first entry of the code-import
	                  ; table

	move.a	r3,c		; get the start-address of the reference-table
	move.a	c,r0		; remember it for later use (see .3 below)
	move.a	c,b		; copy the reference-table pointer to b for easy access
	sub.a		#1,b		; and we subtract 1 from this pointer, because the offsets
	                  ; are 1 too big (to allow 0 as the termination sign)
	move.a	c,d1		; get the first entry, which is the code-start-adress
	move.a	(d1),c	;
	move.a	c,d		; and copy it to register d for easy access
.4
	clr.a		c			; set c.a to zero, so the next move will produce a valid address                  
	move.b	(d0),c	; get the code-number from the code-import table
	add.a		#2,d0		; adjust the pointer to the next entry
	beq.b		c,0,.3	; if the code-number is zero, there are no more code-imports

	add.a		b,c		; add the code-number offset to the start of the ref-table
	move.a	c,d1		; and get the start-address of the library-binary
	move.a	(d1),c	; from there 
	move.a	(d0),a	; get the offset into the library
	add.a		#5,d0		; adjust the pointer to the next entry
	add.a		c,a		; and calculate the effective address inside the lib-binary
	
	move.a	(d0),c	; get the offset into the code-binary
	add.a		#5,d0		; adjust the pointer to the next entry
	add.a		d,c		; and add the start of the code-binary to it
	move.a	c,d1		; this is now where we need to insert the calculated address
	move.a	a,(d1)	; apply the import
	
	bra		.4			; proceed with the next code-import

.3
	; all code-imports are now done, we may proceed with the shared-library imports
	; b is still a pointer to the reference-table minus 1
	
.6
	move.a	r0,c		; get the actual address in the reference-table (set above)
	add.a		#5,c     ; adjust it to the next entry
	move.a	c,r0		;
	move.a	c,d1		;
	move.a	(d1),c	; get the start-address of the actual shared library
	beq.a		c,0,.5	; if it's zero, there's no shared lib left to be worked on
	move.a	c,d		; and store it in register d for easy access
	move.a	c,r1		; and in r1, which will serve as a (--pointer) to the imports
	                  ; of that shared lib 
.7
	clr.a		c			; set c.a to zero, so the next move will produce a valid address                  
	move.b	(d0),c	; get the code-number from the shared-lib-import table
	add.a		#2,d0		; adjust the pointer to the next entry
	beq.b		c,0,.6	; if the code-number is 0, there are no more imports for this lib

	add.a		b,c		; add the code-number offset to the start of the ref-table
	move.a	c,d1		; and get the start-address of the library-binary
	move.a	(d1),c	; from there 
	move.a	(d0),a	; get the offset into the library
	add.a		#5,d0		; adjust the pointer to the next entry
	add.a		c,a		; and calculate the effective address inside the lib-binary
	
	move.a	r1,c		; recall the (--pointer) to the import-tab of the shared lib
	sub.a		#5,c		; decrement it
	move.a	c,r1		; save it
	move.a	c,d1		; this is the address where we can get the offset from
	move.a	(d1),c	; get the offset into the library where the import will be done
	add.a		d,c		; and add the start of the library-binary to it
	
	move.a	c,d1		; this is now where we need to insert the calculated address
	move.a	a,(d1)	; apply the import
	
	bra		.7			; proceed with the next shared-lib-import

.5
	; all shared-library imports are now resolved
	
	; we are now ready to start the program, relocation and dynamic
	; linkage are done

	; jump into the program-code (with saved registers)
		
	move.a	r3,a		; recall the adress where the relocation address was stored
	jmp	(a)		; into from r3 and jump there
	
drop
	; DROP one object
	
	jsr		restore_regs
	add.a		#5,d1
	inc.a		d
	jmp		save_regs
		
exit
	jsr		restore_regs
	move.a	#$203,c
	jmp		$10F40

exit2
	jsr		restore_regs
	move.a	#$00a,c
	jmp		$10F40

	
reloc		; IN:		c = adress of library-data object
			; OUT:	d0 = first adress after relocation table
			;        r2 = points to the storage of the "last-relocation-address" 
	move.a	c,d0
	add.a		#10,d0	; skip type & length of libdata object
	
	move.a	(d0),a	; magic-word
	move.a	#$47430,c
	beq.a		a,c,.c1
	pop
	bra		exit		; exit if wrong magic word
.c1
	
	add.a		#5,d0		; d0 now points to length of rdl-data
	move.a	(d0),a
	exg.a		d0,c
	add.a		c,a		; this is the adress where the code begins
	exg.a		c,d0
	move.a	a,b		; store this adress in b for relocation
	
	add.a		#5,d0		; d0 now points to "last relocation adr" storage
	exg.a		d0,c
	move.a	c,d0
	move.a	c,r2		; store the adress of the "last relocation adr" for later use
	move.a	(d0),a	; get last relocation adress
	subr.a	b,a		; compute newadr - lastadr and store result in a
							; this offset has to be added to all the relocation
							; table entries...
							
	bne.a		a,0,.2	; compare last relocation adress with actual one,
							; if there's no difference, skip the relocation table
	; there was no difference..
.3
	add.a		#5,d0
	move.a	(d0),c
	bne.a		c,0,.3
	bra		.1			; reloc-tab is skipped

.2
	move.a	b,c
	move.a	c,(d0)	; store the new "last-relocation adress"
	move.a	(d0),c	; test whether the value could be stored - 
	bne.a		c,b,exit2	; fails if code to be relocated is in ROM
	add.a		#5,d0		; d0 now points to the first entry of the relocation table
	move.a	(d0),c	; get this entry
	beq.a		c,0,.1	; if entry == 0, relocation is finished
.4
	add.a		b,c		; compute effective address where to apply relocation
	move.a	c,d1
	move.a	(d1),c	; get value from there
	add.a		a,c		; and add the difference to the new relocation-position
	move.a	c,(d1)	; store the new value
	
	add.a		#5,d0		; d0 now points to the next entry of the relocation table
	move.a	(d0),c	; get this entry
	bne.a		c,0,.4	; if entry == 0, relocation is finished, else loop
	
.1
	; relocation is finished, here
	
	add.a		#5,d0		; advance the pointer to the following address
	
	; d0 now points to the first address after the relocation-table
	; r2 holds a pointer to the "last relocation adress"
	rtn
	
code_end
	dcr.5	SEMI  ; end of type-dispatch action
	dcr.5	SEMI  ; end of type-dispatch
	
	dcr.5	SEMI ; end of program

