/* $Id: object.h,v 1.1.1.2 1995/07/11 22:16:43 alex Exp $
 * C definitions for hp48 object interface.
 * Copyright (C) 1994 Alex T Ramos
 *
 * This file is part of the HP48 C Library, which is part of hp48xgcc.
 *
 * hp48xgcc is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * hp48xgcc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with hp48xgcc; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _HP48_OBJECT_H
#define _HP48_OBJECT_H

/* Use simply `hp_object foo;' to declare an HP Object. */

	typedef struct hp_object hp_object;

/*
 * return length in chars of object body 
 */
#  define OBJ_LENGTH(OBJ) 		(((OBJ)->_hide.string.length-5)/2)

/*
 * return the length in nibbles of the whole object 
 */
#  define OBJ_SIZE(OBJ)			((OBJ)->_hide.string.length+5)

/*
 * return pointer to the object body
 */
#  define OBJ_BODY(OBJ)			((OBJ)->_hide.string.body)

/*
 * return hex string of TYPE. Can be used as lvalue.
 */
#  define OBJ_HXS(OBJ,TYPE)		(*(TYPE *)&((OBJ)->_hide.hxs.body[0]))


/*
 * The names of the fields in this structure are subject to
 * change without prior notice. Use the macros instead. 
 */
struct hp_object {
    unsigned prolog:20;
    union {
	struct {
	    unsigned length:20;
	    char     body[0];
	} string, library, code, hxs;	
	float real;
	unsigned sysint : 20;
    } _hide;
};


#endif





