
#ifndef clld_h
#define clld_h


#include "object.h"

extern template class ListItem<Import>;

class InternalReloc {

public:

	ObjectFile * obj;
	union {
		unsigned long offset; // if obj points to a static object, the internal
		                     // relocation is applied at a certain offset
		                     
		ListItem<Import> * shimport; // if obj points to a shared library, the
		                   // internal relocation is applied to one of its imports
	};
	
	InternalReloc( ObjectFile * o, unsigned long s ) : obj(o), offset(s) { };
	InternalReloc( ObjectFile * o, ListItem<Import> * i) :
	         obj(o), shimport(i) { };
	InternalReloc(void) : obj(0), offset(0) { };

};

class CodeImport : public Import {

public:

	unsigned long liboff;

	CodeImport(void) : Import(), liboff(0) { };
	CodeImport(unsigned long o, int t, const Str & n, unsigned long l) :
	    Import(o, t, n, false), liboff(l) { };
	    
};

extern template class ListItem<InternalReloc>;
extern template class List<InternalReloc>;

extern template class ListItem<Import>;
extern template class List<Import>;

class InternalObjectFile : public ObjectFile {

public:

	List<InternalReloc> intrelocs;
	List<Import> shimports;
	int	ShLibNumber;
	
	InternalObjectFile(void) : ObjectFile(), ShLibNumber(0) { };
	
};

class InternalObjectFileP {

public:

	InternalObjectFile * iofp;
	
	InternalObjectFileP(void) : iofp(0) { };
	InternalObjectFileP(InternalObjectFile * p) : iofp(p) { };

};

int resolve_references (List<InternalObjectFile> & obs,
                        List<CodeImport> & cimports,
                        List<InternalObjectFileP> & shlibs
                       ); 

extern bool verbose; // should we talk to the user?
extern bool shared; // are we linking into a shared library rather than an executable?

#endif clld_h


