/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.FontUIResource;
import snmp.SNMPInteger;
import snmp.SNMPObject;
import snmp.SNMPOctetString;
import snmp.SNMPSequence;
import snmp.SNMPVarBindList;
import snmp.SNMPv1CommunicationInterface;

public class HostMonitor
extends JFrame
implements ActionListener,
Runnable {
    JButton newHostButton;
    JButton newCommunityButton;
    JButton scanButton;
    JTextArea messagesArea;
    JScrollPane messagesScroll;
    JScrollPane hostTableScroll;
    JTextField hostIDField;
    JTextField communityField;
    JLabel authorLabel;
    JLabel hostIDLabel;
    JLabel communityLabel;
    JTable hostTable;
    MenuBar theMenubar;
    Menu fileMenu;
    MenuItem quitItem;
    MenuItem aboutItem;
    SNMPv1CommunicationInterface comInterface;
    String community;
    InetAddress hostAddress;
    int version;
    int wirelessHostNum = 1;
    Thread statusThread;
    Vector hostInfoVector = new Vector();
    Vector columnNamesVector = new Vector();

    public HostMonitor() {
        this.columnNamesVector.add("Host Name");
        this.columnNamesVector.add("MAC Address");
        this.setUpDisplay();
        try {
            this.version = 0;
            this.hostAddress = InetAddress.getByName(this.hostIDField.getText());
            this.community = this.communityField.getText();
            this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
            this.comInterface.setSocketTimeout(5000);
            this.statusThread = new Thread(this);
        }
        catch (Exception exception) {
            this.messagesArea.setText("Exception during startup:  " + exception + "\n");
        }
    }

    private void setUpDisplay() {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        this.getRootPane().setBorder(new BevelBorder(0));
        UIManager uIManager = new UIManager();
        FontUIResource fontUIResource = new FontUIResource("SansSerif", 0, 10);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).indexOf("font") <= -1 && ((String)object).indexOf("Font") <= -1) continue;
            UIManager.put(object, fontUIResource);
        }
        this.addWindowListener(new WindowCloseAdapter());
        this.theMenubar = new MenuBar();
        this.setMenuBar(this.theMenubar);
        this.fileMenu = new Menu("File");
        this.aboutItem = new MenuItem("About...");
        this.aboutItem.setActionCommand("about");
        this.aboutItem.addActionListener(this);
        this.fileMenu.add(this.aboutItem);
        this.fileMenu.addSeparator();
        this.quitItem = new MenuItem("Quit");
        this.quitItem.setActionCommand("quit");
        this.quitItem.addActionListener(this);
        this.fileMenu.add(this.quitItem);
        this.theMenubar.add(this.fileMenu);
        this.hostIDLabel = new JLabel("Base station address:");
        this.hostIDField = new JTextField(10);
        this.hostIDField.setText("10.0.1.1");
        this.hostIDField.setEditable(false);
        this.communityLabel = new JLabel("Community (password):");
        this.communityField = new JTextField(10);
        this.communityField.setText("");
        this.communityField.setEditable(false);
        this.authorLabel = new JLabel(" Version 1.0        J. Sevy, May 2001");
        this.authorLabel.setFont(new Font("SansSerif", 2, 8));
        this.newHostButton = new JButton("  Set address  ");
        this.newHostButton.setActionCommand("new host");
        this.newHostButton.addActionListener(this);
        this.newCommunityButton = new JButton(" Set community ");
        this.newCommunityButton.setActionCommand("new community");
        this.newCommunityButton.addActionListener(this);
        this.scanButton = new JButton("Start monitoring");
        this.scanButton.setActionCommand("start monitoring");
        this.scanButton.addActionListener(this);
        this.hostTable = new JTable(this.hostInfoVector, this.columnNamesVector);
        this.hostTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        this.hostTableScroll = new JScrollPane(this.hostTable);
        this.messagesArea = new JTextArea(3, 50);
        this.messagesScroll = new JScrollPane(this.messagesArea);
        object = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.setTitle("Access Point Host Monitoring Utility");
        Panel panel = new Panel();
        panel.setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDLabel, gridBagConstraints);
        panel.add(this.hostIDLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.hostIDField, gridBagConstraints);
        panel.add(this.hostIDField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(this.newHostButton, gridBagConstraints);
        panel.add(this.newHostButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityLabel, gridBagConstraints);
        panel.add(this.communityLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.communityField, gridBagConstraints);
        panel.add(this.communityField);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        ((GridBagLayout)object).setConstraints(this.newCommunityButton, gridBagConstraints);
        panel.add(this.newCommunityButton);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.scanButton, gridBagConstraints);
        panel.add(this.scanButton);
        gridBagConstraints.gridwidth = 1;
        this.getContentPane().setLayout((LayoutManager)object);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        ((GridBagLayout)object).setConstraints(panel, gridBagConstraints);
        this.getContentPane().add(panel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        JLabel jLabel = new JLabel("Attached wireless hosts");
        ((GridBagLayout)object).setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        ((GridBagLayout)object).setConstraints(this.hostTableScroll, gridBagConstraints);
        this.getContentPane().add(this.hostTableScroll);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jLabel = new JLabel("Messages");
        ((GridBagLayout)object).setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        ((GridBagLayout)object).setConstraints(this.messagesScroll, gridBagConstraints);
        this.getContentPane().add(this.messagesScroll);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        ((GridBagLayout)object).setConstraints(this.authorLabel, gridBagConstraints);
        this.getContentPane().add(this.authorLabel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == "quit") {
            this.stopMonitoring();
            System.exit(0);
        }
        if (string == "about") {
            object = new AboutDialog(this);
        }
        if (string == "new host" && (object = JOptionPane.showInputDialog("Input access point address:")) != null) {
            try {
                this.version = 0;
                this.hostAddress = InetAddress.getByName((String)object);
                this.stopMonitoring();
                this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
                this.comInterface.setSocketTimeout(5000);
                this.hostIDField.setText((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                JOptionPane.showMessageDialog(this, "Unknown host supplied.");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error setting new access point address: " + exception);
            }
        }
        if (string == "new community" && (object = JOptionPane.showInputDialog("Input new community:")) != null) {
            try {
                this.version = 0;
                this.community = object;
                this.stopMonitoring();
                this.comInterface = new SNMPv1CommunicationInterface(this.version, this.hostAddress, this.community);
                this.comInterface.setSocketTimeout(5000);
                this.communityField.setText((String)object);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Error setting new community: " + exception);
            }
        }
        if (string == "start monitoring") {
            this.startMonitoring();
        }
        if (string == "stop monitoring") {
            this.stopMonitoring();
        }
    }

    private void stopMonitoring() {
        if (this.statusThread.isAlive()) {
            try {
                this.statusThread.interrupt();
                this.statusThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.messagesArea.setText("Exception during monitoring thread exit:  " + interruptedException + "\n");
            }
            this.scanButton.setText("Start monitoring");
            this.scanButton.setActionCommand("start monitoring");
        }
    }

    private void startMonitoring() {
        if (!this.statusThread.isAlive()) {
            this.scanButton.setText("Stop monitoring");
            this.scanButton.setActionCommand("stop monitoring");
            this.statusThread = new Thread(this);
            this.statusThread.start();
        }
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = String.valueOf(string) + Integer.toHexString(n2 / 16);
        string = String.valueOf(string) + Integer.toHexString(n2 % 16);
        return string;
    }

    public void run() {
        while (!Thread.interrupted()) {
            try {
                String string;
                this.messagesArea.setText("");
                this.hostInfoVector.removeAllElements();
                int n = 1;
                while (n <= 3) {
                    string = "1.3.6.1.4.1.762.2.5.5." + n;
                    this.comInterface.setMIBEntry(string, new SNMPInteger(500L));
                    string = "1.3.6.1.4.1.762.2.5.4." + n;
                    this.comInterface.setMIBEntry(string, new SNMPInteger(3L));
                    ++n;
                }
                string = "1.3.6.1.4.1.762.2.5.1.0";
                SNMPVarBindList sNMPVarBindList = this.comInterface.getMIBEntry(string);
                SNMPSequence sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                SNMPInteger sNMPInteger = (SNMPInteger)sNMPSequence.getSNMPObjectAt(1);
                int n2 = Integer.parseInt(sNMPInteger.toString());
                if (n2 > 0) {
                    TreeSet<HostInfo> treeSet = new TreeSet<HostInfo>();
                    int n3 = 0;
                    while (n3 < n2) {
                        HostInfo hostInfo = new HostInfo();
                        string = "1.3.6.1.4.1.762.2.5.2.1.3." + (n3 + 1);
                        sNMPVarBindList = this.comInterface.getMIBEntry(string);
                        sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                        SNMPObject sNMPObject = sNMPSequence.getSNMPObjectAt(1);
                        String string2 = sNMPObject.toString();
                        hostInfo.add(string2);
                        string = "1.3.6.1.4.1.762.2.5.2.1.11." + (n3 + 1);
                        sNMPVarBindList = this.comInterface.getMIBEntry(string);
                        sNMPSequence = (SNMPSequence)sNMPVarBindList.getSNMPObjectAt(0);
                        SNMPOctetString sNMPOctetString = (SNMPOctetString)sNMPSequence.getSNMPObjectAt(1);
                        String string3 = sNMPOctetString.toHexString();
                        hostInfo.add(string3);
                        treeSet.add(hostInfo);
                        ++n3;
                    }
                    this.hostInfoVector.addAll(treeSet);
                }
                this.hostTable.tableChanged(new TableModelEvent(this.hostTable.getModel()));
            }
            catch (Exception exception) {
                this.messagesArea.setText("Exception during base station monitoring:  " + exception + "\n" + "Check community name.");
            }
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                this.statusThread.interrupt();
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            HostMonitor hostMonitor = new HostMonitor();
            hostMonitor.pack();
            Dimension dimension = hostMonitor.getSize();
            dimension.height += 20;
            dimension.width += 20;
            ((Component)hostMonitor).setSize(dimension);
            hostMonitor.show();
        }
        catch (Exception exception) {}
    }

    private class WindowCloseAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            HostMonitor.this.stopMonitoring();
            System.exit(0);
        }

        WindowCloseAdapter() {
        }
    }
}

