/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import groovy.lang.Closure;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.group.PGroupBuilder;
import groovyx.gpars.remote.LocalHost;
import groovyx.gpars.remote.LocalHostRegistry;
import groovyx.gpars.remote.RemoteNode;
import groovyx.gpars.remote.RemoteNodeDiscoveryListener;
import groovyx.gpars.serial.SerialHandles;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LocalNode {
    private final List<RemoteNodeDiscoveryListener> listeners = Collections.synchronizedList(new LinkedList());
    private final ThreadPoolExecutor scheduler;
    private final Actor mainActor;
    private final UUID id = UUID.randomUUID();
    private final LocalHost localHost;

    public LocalNode() {
        this(null, null);
    }

    public LocalNode(Runnable runnable) {
        this(null, runnable);
    }

    public LocalNode(LocalHost provider) {
        this(provider, null);
    }

    public LocalNode(LocalHost provider, Runnable runnable) {
        this.scheduler = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactory(){
            ThreadFactory threadFactory = Executors.defaultThreadFactory();

            public Thread newThread(Runnable r) {
                Thread thread = this.threadFactory.newThread(r);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println("Uncaught exception occurred in actor pool " + t.getName());
                        e.printStackTrace(System.err);
                    }
                });
                return thread;
            }
        });
        PGroup group = PGroupBuilder.createFromPool(this.scheduler);
        if (runnable != null) {
            if (runnable instanceof Closure) {
                ((Closure)runnable).setDelegate((Object)this);
                ((Closure)runnable).setResolveStrategy(1);
            }
            this.mainActor = group.actor(runnable);
        } else {
            this.mainActor = null;
        }
        this.localHost = provider;
        if (runnable != null) {
            this.connect(provider);
        }
    }

    public void connect() {
        if (this.localHost != null) {
            this.connect(this.localHost);
        } else {
            LocalHostRegistry.connect(this);
        }
    }

    public void connect(final LocalHost provider) {
        this.scheduler.execute(new Runnable(){

            public void run() {
                provider.connect(LocalNode.this);
            }
        });
    }

    public void disconnect() {
        if (this.mainActor != null && this.mainActor.isActive()) {
            this.mainActor.stop();
        }
        if (this.localHost == null) {
            LocalHostRegistry.disconnect(this);
        } else {
            this.scheduler.execute(new Runnable(){

                public void run() {
                    LocalNode.this.localHost.disconnect(LocalNode.this);
                }
            });
        }
    }

    public void addDiscoveryListener(RemoteNodeDiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public void addDiscoveryListener(Closure listener) {
        this.listeners.add(new RemoteNodeDiscoveryListener.RemoteNodeDiscoveryListenerClosure(listener));
    }

    public void removeDiscoveryListener(RemoteNodeDiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    public void onConnect(final RemoteNode node) {
        for (final RemoteNodeDiscoveryListener listener : this.listeners) {
            this.scheduler.execute(new Runnable(){

                public void run() {
                    listener.onConnect(node);
                }
            });
        }
    }

    public void onDisconnect(final RemoteNode node) {
        for (final RemoteNodeDiscoveryListener listener : this.listeners) {
            this.scheduler.execute(new Runnable(){

                public void run() {
                    listener.onDisconnect(node);
                }
            });
        }
    }

    public Actor getMainActor() {
        return this.mainActor;
    }

    public Executor getScheduler() {
        return this.scheduler;
    }

    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public SerialHandles getLocalHost() {
        return this.localHost;
    }
}

