/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.stream;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowQueue;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.SyncDataflowVariable;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.impl.ThenMessagingRunnable;
import groovyx.gpars.dataflow.operator.BinaryChoiceClosure;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.ChoiceClosure;
import groovyx.gpars.dataflow.operator.CopyChannelsClosure;
import groovyx.gpars.dataflow.operator.FilterClosure;
import groovyx.gpars.dataflow.operator.SeparationClosure;
import groovyx.gpars.dataflow.stream.FListIterator;
import groovyx.gpars.dataflow.stream.StreamCore;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataflowStreamReadAdapter<T>
implements DataflowReadChannel<T> {
    private StreamCore<T> head;
    private StreamCore<T> asyncHead;

    public DataflowStreamReadAdapter(StreamCore<T> stream) {
        this.head = stream;
        this.asyncHead = this.head;
    }

    public Iterator<T> iterator() {
        return new FListIterator<T>(this.head);
    }

    public final String toString() {
        return this.head.toString();
    }

    @Override
    public T getVal() throws InterruptedException {
        T first = this.head.getFirst();
        this.moveHead();
        return first;
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        Object value = this.head.getFirstDFV().getVal(timeout, units);
        if (value == null) {
            if (this.shouldReportTimeout()) {
                return null;
            }
            Object result = this.head.getFirstDFV().getVal();
            this.moveHead();
            return result;
        }
        this.moveHead();
        return value;
    }

    private boolean shouldReportTimeout() {
        DataflowVariable<T> firstDFV = this.head.getFirstDFV();
        if (!firstDFV.isBound()) {
            return true;
        }
        if (firstDFV instanceof SyncDataflowVariable) {
            return ((SyncDataflowVariable)firstDFV).awaitingParties();
        }
        return false;
    }

    @Override
    public void getValAsync(MessageStream callback) {
        this.asyncHead.getFirstDFV().getValAsync(callback);
        this.moveAsyncHead();
    }

    @Override
    public void getValAsync(Object attachment, MessageStream callback) {
        this.asyncHead.getFirstDFV().getValAsync(attachment, callback);
        this.moveAsyncHead();
    }

    @Override
    public <V> Promise<V> rightShift(Closure<V> closure) {
        return this.then(closure);
    }

    @Override
    public <V> void whenBound(Closure<V> closure) {
        this.asyncHead.getFirstDFV().whenBound(closure);
        this.moveAsyncHead();
    }

    @Override
    public <V> void whenBound(Pool pool, Closure<V> closure) {
        this.asyncHead.getFirstDFV().whenBound(pool, closure);
        this.moveAsyncHead();
    }

    @Override
    public <V> void whenBound(PGroup group, Closure<V> closure) {
        this.asyncHead.getFirstDFV().whenBound(group, closure);
        this.moveAsyncHead();
    }

    @Override
    public void whenBound(MessageStream stream) {
        this.asyncHead.getFirstDFV().whenBound(stream);
        this.moveAsyncHead();
    }

    @Override
    public final <V> Promise<V> then(Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(Pool pool, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(pool, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> Promise<V> then(PGroup group, Closure<V> closure) {
        DataflowVariable result = new DataflowVariable();
        this.whenBound(group, new ThenMessagingRunnable(result, closure));
        return result;
    }

    @Override
    public <V> void wheneverBound(Closure<V> closure) {
        this.head.wheneverBound(closure);
    }

    @Override
    public void wheneverBound(MessageStream stream) {
        this.head.wheneverBound(stream);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Closure<V> closure) {
        return this.chainWith(Dataflow.retrieveCurrentDFPGroup(), closure);
    }

    @Override
    public final <V> DataflowReadChannel<V> chainWith(Pool pool, Closure<V> closure) {
        return this.chainWith(new DefaultPGroup(pool), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        DataflowQueue result = new DataflowQueue();
        group.operator(this, result, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> or(Closure<V> closure) {
        return this.chainWith(closure);
    }

    @Override
    public DataflowReadChannel<T> filter(Closure<Boolean> closure) {
        return this.chainWith(new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(Pool pool, Closure<Boolean> closure) {
        return this.chainWith(pool, new FilterClosure(closure));
    }

    @Override
    public DataflowReadChannel<T> filter(PGroup group, Closure<Boolean> closure) {
        return this.chainWith(group, new FilterClosure(closure));
    }

    @Override
    public void into(DataflowWriteChannel<T> target) {
        this.into(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public void into(Pool pool, DataflowWriteChannel<T> target) {
        this.into(new DefaultPGroup(pool), target);
    }

    @Override
    public void into(PGroup group, DataflowWriteChannel<T> target) {
        group.operator(this, target, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public void or(DataflowWriteChannel<T> target) {
        this.into(target);
    }

    @Override
    public void split(DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), target1, target2);
    }

    @Override
    public void split(Pool pool, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(new DefaultPGroup(pool), target1, target2);
    }

    @Override
    public void split(PGroup group, DataflowWriteChannel<T> target1, DataflowWriteChannel<T> target2) {
        this.split(group, Arrays.asList(target1, target2));
    }

    @Override
    public void split(List<DataflowWriteChannel<T>> targets) {
        this.split(Dataflow.retrieveCurrentDFPGroup(), targets);
    }

    @Override
    public void split(Pool pool, List<DataflowWriteChannel<T>> targets) {
        this.split(new DefaultPGroup(pool), targets);
    }

    @Override
    public void split(PGroup group, List<DataflowWriteChannel<T>> targets) {
        group.operator(Arrays.asList(this), targets, new ChainWithClosure(new CopyChannelsClosure()));
    }

    @Override
    public DataflowReadChannel<T> tap(DataflowWriteChannel<T> target) {
        return this.tap(Dataflow.retrieveCurrentDFPGroup(), target);
    }

    @Override
    public DataflowReadChannel<T> tap(Pool pool, DataflowWriteChannel<T> target) {
        return this.tap(new DefaultPGroup(pool), target);
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, DataflowWriteChannel<T> target) {
        DataflowQueue result = new DataflowQueue();
        group.operator(Arrays.asList(this), Arrays.asList(result, target), new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(pool, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, DataflowReadChannel<Object> other, Closure<V> closure) {
        return this.merge(group, Arrays.asList(other), closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge(Dataflow.retrieveCurrentDFPGroup(), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(Pool pool, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        return this.merge((PGroup)new DefaultPGroup(pool), others, closure);
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        DataflowQueue result = new DataflowQueue();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public void binaryChoice(DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(Dataflow.retrieveCurrentDFPGroup(), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(Pool pool, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        this.binaryChoice(new DefaultPGroup(pool), trueBranch, falseBranch, code);
    }

    @Override
    public void binaryChoice(PGroup group, DataflowWriteChannel<T> trueBranch, DataflowWriteChannel<T> falseBranch, Closure<Boolean> code) {
        group.operator(Arrays.asList(this), Arrays.asList(trueBranch, falseBranch), (Closure)new BinaryChoiceClosure(code));
    }

    @Override
    public void choice(List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void choice(Pool pool, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        this.choice(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void choice(PGroup group, List<DataflowWriteChannel<T>> outputs, Closure<Integer> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new ChoiceClosure(code));
    }

    @Override
    public void separate(List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(Dataflow.retrieveCurrentDFPGroup(), outputs, code);
    }

    @Override
    public void separate(Pool pool, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        this.separate(new DefaultPGroup(pool), outputs, code);
    }

    @Override
    public void separate(PGroup group, List<DataflowWriteChannel<?>> outputs, Closure<List<Object>> code) {
        group.operator(Arrays.asList(this), outputs, (Closure)new SeparationClosure(code));
    }

    @Override
    public boolean isBound() {
        return this.head.getFirstDFV().isBound();
    }

    @Override
    public int length() {
        StreamCore current = this.head;
        int length = 0;
        while (current.getFirstDFV().isBound()) {
            ++length;
            current = (StreamCore)current.getRest();
        }
        return length;
    }

    @Override
    public DataflowExpression<T> poll() throws InterruptedException {
        DataflowVariable<T> firstDFV = this.head.getFirstDFV();
        if (firstDFV.isBound()) {
            this.moveHead();
            return firstDFV;
        }
        return null;
    }

    protected final List<DataflowVariable<T>> allUnprocessedDFVs() throws InterruptedException {
        ArrayList<DataflowVariable<T>> values = new ArrayList<DataflowVariable<T>>();
        StreamCore<T> currentHead = this.asyncHead;
        while (currentHead != null) {
            values.add(currentHead.getFirstDFV());
            currentHead = currentHead.rest.get();
        }
        return values;
    }

    private void moveHead() {
        if (this.head == this.asyncHead) {
            this.moveAsyncHead();
        }
        this.head = (StreamCore)this.head.getRest();
    }

    private void moveAsyncHead() {
        this.asyncHead = (StreamCore)this.asyncHead.getRest();
    }
}

