/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.dataflow.operator.DataflowSelectorActor;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;

final class ForkingDataflowSelectorActor
extends DataflowSelectorActor {
    private final Semaphore semaphore;
    private final Pool threadPool;
    private final int maxForks;

    ForkingDataflowSelectorActor(DataflowSelector owningOperator, PGroup group, List outputs, List inputs, Closure code, int maxForks) {
        super(owningOperator, group, outputs, inputs, code);
        this.maxForks = maxForks;
        this.semaphore = new Semaphore(maxForks);
        this.threadPool = group.getThreadPool();
    }

    void startTask(final int index, final Object result) {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot obtain the semaphore to fork operator's body.", e);
        }
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ForkingDataflowSelectorActor.super.startTask(index, result);
                }
                catch (Throwable throwable) {
                    ForkingDataflowSelectorActor.this.owningProcessor.fireAfterRun(Arrays.asList(result));
                    ForkingDataflowSelectorActor.this.semaphore.release();
                    throw throwable;
                }
                ForkingDataflowSelectorActor.this.owningProcessor.fireAfterRun(Arrays.asList(result));
                ForkingDataflowSelectorActor.this.semaphore.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardPoisonPill(Object data) {
        try {
            this.semaphore.acquire(this.maxForks);
        }
        catch (InterruptedException e) {
            this.owningProcessor.reportError(e);
        }
        finally {
            super.forwardPoisonPill(data);
            this.semaphore.release(this.maxForks);
        }
    }
}

