/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.operator.DataflowOperatorActor;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.ForkingDataflowOperatorActor;
import groovyx.gpars.group.PGroup;
import java.util.Collection;
import java.util.Map;

public final class DataflowOperator
extends DataflowProcessor {
    public DataflowOperator(PGroup group, Map channels, Closure code) {
        super(channels, code);
        int parameters = code.getMaximumNumberOfParameters();
        if (DataflowOperator.verifyChannelParameters(channels, parameters)) {
            throw new IllegalArgumentException("The operator's body accepts " + parameters + " parameters while it is given " + DataflowOperator.countInputChannels(channels) + " input streams. The numbers must match.");
        }
        if (DataflowOperator.shouldBeMultiThreaded(channels)) {
            DataflowOperator.checkMaxForks(channels);
            this.actor = new ForkingDataflowOperatorActor(this, group, DataflowOperator.extractOutputs(channels), DataflowOperator.extractInputs(channels), (Closure)code.clone(), (Integer)channels.get("maxForks"));
        } else {
            this.actor = new DataflowOperatorActor(this, group, DataflowOperator.extractOutputs(channels), DataflowOperator.extractInputs(channels), (Closure)code.clone());
        }
    }

    private static boolean verifyChannelParameters(Map channels, int parameters) {
        if (channels == null) {
            return true;
        }
        Collection inputs = (Collection)channels.get("inputs");
        return inputs == null || inputs.isEmpty() || parameters != inputs.size();
    }

    private static String countInputChannels(Map channels) {
        if (channels == null) {
            return "Null";
        }
        Collection inputs = (Collection)channels.get("inputs");
        return String.valueOf(inputs.size());
    }
}

