/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public final class ResizeableCountDownLatch {
    private final Sync sync;

    public ResizeableCountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(count);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public boolean attemptToCountDownAndAwait(long timeout) throws InterruptedException {
        if (this.await(timeout, TimeUnit.NANOSECONDS)) {
            return true;
        }
        this.increaseCount();
        if (this.getCount() <= 1L) {
            this.countDown();
            return true;
        }
        return false;
    }

    public boolean isReleasedFlag() {
        return this.sync.getCount() == 0;
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public void increaseCount() {
        this.sync.increaseCount();
    }

    public void decreaseCount() {
        this.sync.decreaseCount();
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int count) {
            this.setState(count);
        }

        int getCount() {
            return this.getState();
        }

        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        public boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }

        public void increaseCount() {
            boolean repeat = true;
            while (repeat) {
                int state = this.getState();
                repeat = !this.compareAndSetState(state, state + 1);
            }
        }

        public void decreaseCount() {
            boolean repeat = true;
            while (repeat) {
                int state = this.getState();
                repeat = !this.compareAndSetState(state, state - 1);
            }
        }
    }
}

