/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.SyncDataflowQueue;
import groovyx.gpars.dataflow.SyncDataflowVariable;
import groovyx.gpars.dataflow.expression.DataflowExpression;
import groovyx.gpars.dataflow.operator.ChainWithClosure;
import groovyx.gpars.dataflow.operator.CopyChannelsClosure;
import groovyx.gpars.dataflow.stream.DataflowStreamReadAdapter;
import groovyx.gpars.dataflow.stream.StreamCore;
import groovyx.gpars.group.PGroup;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SyncDataflowStreamReadAdapter<T>
extends DataflowStreamReadAdapter<T> {
    private boolean closed = false;
    private boolean wheneverBoundSet = false;

    SyncDataflowStreamReadAdapter(StreamCore<T> stream) {
        super(stream);
    }

    @Override
    public Iterator<T> iterator() {
        this.checkClosed();
        return super.iterator();
    }

    @Override
    public T getVal() throws InterruptedException {
        this.checkClosed();
        return super.getVal();
    }

    @Override
    public T getVal(long timeout, TimeUnit units) throws InterruptedException {
        this.checkClosed();
        return super.getVal(timeout, units);
    }

    @Override
    public void getValAsync(MessageStream callback) {
        this.checkClosed();
        super.getValAsync(callback);
    }

    @Override
    public void getValAsync(Object attachment, MessageStream callback) {
        this.checkClosed();
        super.getValAsync(attachment, callback);
    }

    @Override
    public <V> Promise<V> rightShift(Closure<V> closure) {
        return this.then(closure);
    }

    @Override
    public <V> void whenBound(Closure<V> closure) {
        this.checkClosed();
        super.whenBound(closure);
    }

    @Override
    public <V> void whenBound(Pool pool, Closure<V> closure) {
        this.checkClosed();
        super.whenBound(pool, closure);
    }

    @Override
    public <V> void whenBound(PGroup group, Closure<V> closure) {
        this.checkClosed();
        super.whenBound(group, closure);
    }

    @Override
    public void whenBound(MessageStream stream) {
        this.checkClosed();
        super.whenBound(stream);
    }

    @Override
    public <V> void wheneverBound(Closure<V> closure) {
        this.checkClosed();
        this.wheneverBoundSet = true;
        super.wheneverBound(closure);
    }

    @Override
    public void wheneverBound(MessageStream stream) {
        this.checkClosed();
        this.wheneverBoundSet = true;
        super.wheneverBound(stream);
    }

    @Override
    public <V> DataflowReadChannel<V> chainWith(PGroup group, Closure<V> closure) {
        SyncDataflowQueue result = new SyncDataflowQueue();
        group.operator(this, result, new ChainWithClosure(closure));
        return result;
    }

    @Override
    public DataflowReadChannel<T> tap(PGroup group, DataflowWriteChannel<T> target) {
        SyncDataflowQueue result = new SyncDataflowQueue();
        group.operator(Arrays.asList(this), Arrays.asList(result, target), new ChainWithClosure(new CopyChannelsClosure()));
        return result;
    }

    @Override
    public <V> DataflowReadChannel<V> merge(PGroup group, List<DataflowReadChannel<Object>> others, Closure<V> closure) {
        SyncDataflowQueue result = new SyncDataflowQueue();
        ArrayList<DataflowReadChannel<Object>> inputs = new ArrayList<DataflowReadChannel<Object>>();
        inputs.add(this);
        inputs.addAll(others);
        group.operator(inputs, Arrays.asList(result), new ChainWithClosure(closure));
        return result;
    }

    @Override
    public boolean isBound() {
        this.checkClosed();
        return super.isBound();
    }

    @Override
    public DataflowExpression<T> poll() throws InterruptedException {
        this.checkClosed();
        return super.poll();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("The subscription channel has already been un-subscribed and closed");
        }
    }

    void close() throws InterruptedException {
        if (this.wheneverBoundSet) {
            throw new IllegalStateException("The subscription cannot be closed since it has active wheneverBound handlers.");
        }
        if (this.closed) {
            throw new IllegalStateException("The subscription has already been closed before.");
        }
        this.closed = true;
        List dataflowVariables = this.allUnprocessedDFVs();
        for (DataflowVariable dataflowVariable : dataflowVariables) {
            ((SyncDataflowVariable)dataflowVariable).decrementParties();
        }
    }
}

