/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovy.lang.Closure;
import groovyx.gpars.GParsConfig;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.Select;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.group.DefaultPGroup;
import groovyx.gpars.group.PGroup;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Dataflow {
    public static final PGroup DATA_FLOW_GROUP = new DefaultPGroup(GParsConfig.retrieveDefaultPool());
    public static final ThreadLocal<PGroup> activeParallelGroup = new ThreadLocal();

    public static PGroup retrieveCurrentDFPGroup() {
        PGroup pGroup = activeParallelGroup.get();
        if (pGroup == null) {
            pGroup = DATA_FLOW_GROUP;
        }
        return pGroup;
    }

    public static DataflowVariable task(Closure code) {
        return DATA_FLOW_GROUP.task(code);
    }

    public static DataflowVariable task(Callable callable) {
        return DATA_FLOW_GROUP.task(callable);
    }

    public static DataflowVariable task(Runnable runnable) {
        return DATA_FLOW_GROUP.task(runnable);
    }

    public static DataflowProcessor operator(Map channels, Closure code) {
        return DATA_FLOW_GROUP.operator(channels, code);
    }

    public static DataflowProcessor operator(List inputChannels, List outputChannels, Closure code) {
        return DATA_FLOW_GROUP.operator(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor operator(List inputChannels, List outputChannels, int maxForks, Closure code) {
        return DATA_FLOW_GROUP.operator(inputChannels, outputChannels, maxForks, code);
    }

    public static DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, Closure code) {
        return DATA_FLOW_GROUP.operator(input, output, code);
    }

    public static DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, int maxForks, Closure code) {
        return DATA_FLOW_GROUP.operator(input, output, maxForks, code);
    }

    public static DataflowProcessor selector(Map channels, Closure code) {
        return DATA_FLOW_GROUP.selector(channels, code);
    }

    public static DataflowProcessor selector(List inputChannels, List outputChannels, Closure code) {
        return DATA_FLOW_GROUP.selector(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor selector(Map channels) {
        return DATA_FLOW_GROUP.selector(channels);
    }

    public static DataflowProcessor selector(List inputChannels, List outputChannels) {
        return DATA_FLOW_GROUP.selector(inputChannels, outputChannels);
    }

    public static DataflowProcessor prioritySelector(Map channels, Closure code) {
        return DATA_FLOW_GROUP.prioritySelector(channels, code);
    }

    public static DataflowProcessor prioritySelector(List inputChannels, List outputChannels, Closure code) {
        return DATA_FLOW_GROUP.prioritySelector(inputChannels, outputChannels, code);
    }

    public static DataflowProcessor prioritySelector(Map channels) {
        return DATA_FLOW_GROUP.prioritySelector(channels);
    }

    public static DataflowProcessor prioritySelector(List inputChannels, List outputChannels) {
        return DATA_FLOW_GROUP.prioritySelector(inputChannels, outputChannels);
    }

    public static DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels) {
        return DATA_FLOW_GROUP.splitter(inputChannel, outputChannels);
    }

    public static DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels, int maxForks) {
        return DATA_FLOW_GROUP.splitter(inputChannel, outputChannels, maxForks);
    }

    public static Select<?> select(DataflowReadChannel<?> ... channels) {
        return DATA_FLOW_GROUP.select(channels);
    }

    public static Select<?> select(List<DataflowReadChannel> channels) {
        return DATA_FLOW_GROUP.select(channels);
    }

    public static <T> Promise<T> whenAllBound(List<Promise<?>> promises, Closure<T> code) {
        return Dataflow.retrieveCurrentDFPGroup().whenAllBound(promises, code);
    }
}

