/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.time.Duration;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.RemoteSerialized;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageStream
extends WithSerialId {
    private static final long serialVersionUID = 7644465423857532477L;

    public abstract MessageStream send(Object var1);

    public final MessageStream send() {
        return this.send(new Object());
    }

    public final <T> MessageStream send(T message, MessageStream replyTo) {
        return this.send(new ActorMessage(message, replyTo));
    }

    public final <T> MessageStream leftShift(T message) {
        return this.send(message);
    }

    public final <T> MessageStream call(T message) {
        return this.send(message);
    }

    public final <T, V> V sendAndWait(T message) throws InterruptedException {
        ResultWaiter to = new ResultWaiter();
        this.send(new ActorMessage(message, to));
        return to.getResult();
    }

    public final <T> Object sendAndWait(T message, long timeout, TimeUnit units) throws InterruptedException {
        ResultWaiter to = new ResultWaiter();
        this.send(new ActorMessage(message, to));
        return to.getResult(timeout, units);
    }

    public final <T> Object sendAndWait(T message, Duration duration) throws InterruptedException {
        return this.sendAndWait(message, duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public Class<RemoteMessageStream> getRemoteClass() {
        return RemoteMessageStream.class;
    }

    static void reInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    public static class SendTo
    extends SerialMsg {
        private static final long serialVersionUID = 1989120447646342520L;
        private final MessageStream to;
        private final ActorMessage message;

        public SendTo(MessageStream to, ActorMessage message) {
            this.to = to;
            this.message = message;
        }

        public MessageStream getTo() {
            return this.to;
        }

        public ActorMessage getMessage() {
            return this.message;
        }

        public void execute(RemoteConnection conn) {
            this.to.send(this.message);
        }
    }

    public static class RemoteMessageStream
    extends MessageStream
    implements RemoteSerialized {
        private static final long serialVersionUID = 3936054469565089659L;
        private final RemoteHost remoteHost;

        public RemoteMessageStream(RemoteHost host) {
            this.remoteHost = host;
        }

        public MessageStream send(Object message) {
            if (!(message instanceof ActorMessage)) {
                message = new ActorMessage(message, Actor.threadBoundActor());
            }
            this.remoteHost.write(new SendTo(this, (ActorMessage)message));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultWaiter<V>
    extends MessageStream {
        private static final long serialVersionUID = 6512046150496489148L;
        private volatile Object value = Thread.currentThread();
        private volatile boolean isSet;

        private ResultWaiter() {
        }

        @Override
        public MessageStream send(Object message) {
            if (this.isSet) {
                throw new IllegalStateException("A reply has already been sent. The originator does not expect more than one reply.");
            }
            Thread thread = (Thread)this.value;
            this.value = message instanceof ActorMessage ? ((ActorMessage)message).getPayLoad() : message;
            this.isSet = true;
            LockSupport.unpark(thread);
            return this;
        }

        public V getResult() throws InterruptedException {
            while (!this.isSet) {
                LockSupport.park();
                Thread thread = Thread.currentThread();
                if (!thread.isInterrupted()) continue;
                throw new InterruptedException();
            }
            this.rethrowException();
            return (V)this.value;
        }

        public Object getResult(long timeout, TimeUnit units) throws InterruptedException {
            long endNano = System.nanoTime() + units.toNanos(timeout);
            while (!this.isSet) {
                long toWait = endNano - System.nanoTime();
                if (toWait <= 0L) {
                    return null;
                }
                LockSupport.parkNanos(toWait);
                MessageStream.reInterrupt();
            }
            this.rethrowException();
            return this.value;
        }

        private void rethrowException() {
            if (this.value instanceof Throwable) {
                if (this.value instanceof RuntimeException) {
                    throw (RuntimeException)this.value;
                }
                throw new RuntimeException((Throwable)this.value);
            }
        }

        public void onDeliveryError(Object msg) {
            this.send(new IllegalStateException("Delivery error. Maybe target actor is not active"));
        }
    }
}

