/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.indy;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.InvocationWriter;
import org.codehaus.groovy.classgen.asm.MethodCallerMultiAdapter;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.wrappers.Wrapper;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.objectweb.asm.Handle;

public class InvokeDynamicWriter
extends InvocationWriter {
    private static final String INDY_INTERFACE_NAME = IndyInterface.class.getName().replace('.', '/');
    private static final String BSM_METHOD_TYPE_DESCRIPTOR = MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class).toMethodDescriptorString();
    private static final Handle BSM = new Handle(6, INDY_INTERFACE_NAME, "bootstrap", BSM_METHOD_TYPE_DESCRIPTOR);
    private static final Handle BSM_SAFE = new Handle(6, INDY_INTERFACE_NAME, "bootstrapSafe", BSM_METHOD_TYPE_DESCRIPTOR);
    private static final Handle BSM_CURRENT = new Handle(6, INDY_INTERFACE_NAME, "bootstrapCurrent", BSM_METHOD_TYPE_DESCRIPTOR);
    private static final Handle BSM_CURRENT_SAFE = new Handle(6, INDY_INTERFACE_NAME, "bootstrapCurrentSafe", BSM_METHOD_TYPE_DESCRIPTOR);
    private WriterController controller;

    public InvokeDynamicWriter(WriterController wc) {
        super(wc);
        this.controller = wc;
    }

    @Override
    public void makeCall(Expression origin, Expression receiver, Expression message, Expression arguments, MethodCallerMultiAdapter adapter, boolean safe, boolean spreadSafe, boolean implicitThis) {
        int numberOfArguments;
        String methodName;
        MethodCallExpression mce;
        MethodNode target;
        boolean containsSpreadExpression = AsmClassGenerator.containsSpreadExpression(arguments);
        if (containsSpreadExpression) {
            super.makeCall(origin, receiver, message, arguments, adapter, safe, spreadSafe, implicitThis);
            return;
        }
        if (origin instanceof MethodCallExpression && this.writeDirectMethodCall(target = (mce = (MethodCallExpression)origin).getMethodTarget(), implicitThis, receiver, InvokeDynamicWriter.makeArgumentList(arguments))) {
            return;
        }
        ClassNode cn = this.controller.getClassNode();
        if (this.controller.isInClosure() && !implicitThis && AsmClassGenerator.isThisExpression(receiver)) {
            cn = cn.getOuterClass();
        }
        ClassExpression sender = new ClassExpression(cn);
        OperandStack operandStack = this.controller.getOperandStack();
        CompileStack compileStack = this.controller.getCompileStack();
        AsmClassGenerator acg = this.controller.getAcg();
        if (!(adapter != invokeMethod && adapter != invokeMethodOnCurrent && adapter != invokeStaticMethod || spreadSafe || (methodName = this.getMethodName(message)) == null)) {
            this.makeIndyCall(adapter, receiver, implicitThis, safe, methodName, arguments);
            return;
        }
        compileStack.pushLHS(false);
        if (adapter == AsmClassGenerator.setProperty) {
            ConstantExpression.NULL.visit(acg);
        } else {
            sender.visit(acg);
        }
        compileStack.pushImplicitThis(implicitThis);
        receiver.visit(acg);
        operandStack.box();
        compileStack.popImplicitThis();
        int operandsToRemove = 2;
        if (message != null) {
            message.visit(acg);
            operandStack.box();
            ++operandsToRemove;
        }
        int n = numberOfArguments = containsSpreadExpression ? -1 : AsmClassGenerator.argumentSize(arguments);
        if (numberOfArguments > 0 || containsSpreadExpression) {
            ArgumentListExpression ae = InvokeDynamicWriter.makeArgumentList(arguments);
            if (containsSpreadExpression) {
                acg.despreadList(ae.getExpressions(), true);
            } else {
                ae.visit(acg);
            }
        } else if (numberOfArguments > 0) {
            operandsToRemove += numberOfArguments;
            TupleExpression te = (TupleExpression)arguments;
            for (int i = 0; i < numberOfArguments; ++i) {
                Expression argument = te.getExpression(i);
                argument.visit(acg);
                operandStack.box();
                if (!(argument instanceof CastExpression)) continue;
                acg.loadWrapper(argument);
            }
        }
        adapter.call(this.controller.getMethodVisitor(), numberOfArguments, safe, spreadSafe);
        compileStack.popLHS();
        operandStack.replace(ClassHelper.OBJECT_TYPE, operandsToRemove);
    }

    private void makeIndyCall(MethodCallerMultiAdapter adapter, Expression receiver, boolean implicitThis, boolean safe, String methodName, Expression arguments) {
        CompileStack compileStack = this.controller.getCompileStack();
        OperandStack operandStack = this.controller.getOperandStack();
        compileStack.pushLHS(false);
        String sig = "(";
        compileStack.pushImplicitThis(implicitThis);
        receiver.visit(this.controller.getAcg());
        compileStack.popImplicitThis();
        sig = sig + BytecodeHelper.getTypeDescription(operandStack.getTopOperand());
        int numberOfArguments = 1;
        ArgumentListExpression ae = InvokeDynamicWriter.makeArgumentList(arguments);
        for (Expression arg : ae.getExpressions()) {
            arg.visit(this.controller.getAcg());
            if (arg instanceof CastExpression) {
                operandStack.box();
                this.controller.getAcg().loadWrapper(arg);
                sig = sig + BytecodeHelper.getTypeDescription(Wrapper.class);
            } else {
                sig = sig + BytecodeHelper.getTypeDescription(operandStack.getTopOperand());
            }
            ++numberOfArguments;
        }
        sig = sig + ")Ljava/lang/Object;";
        Handle bsmHandle = this.getBsmHandle(adapter, safe);
        this.controller.getMethodVisitor().visitInvokeDynamicInsn(methodName, sig, bsmHandle, new Object[0]);
        operandStack.replace(ClassHelper.OBJECT_TYPE, numberOfArguments);
        compileStack.popLHS();
    }

    private Handle getBsmHandle(MethodCallerMultiAdapter adapter, boolean safe) {
        if (adapter == invokeMethodOnCurrent) {
            if (safe) {
                return BSM_CURRENT_SAFE;
            }
            return BSM_CURRENT;
        }
        if (safe) {
            return BSM_SAFE;
        }
        return BSM;
    }

    @Override
    public void makeSingleArgumentCall(Expression receiver, String message, Expression arguments) {
        this.makeIndyCall(null, receiver, false, false, message, arguments);
    }
}

