/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.parser.GroovyTokenTypes;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyConstructorDoc;
import org.codehaus.groovy.groovydoc.GroovyFieldDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAbstractableElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAnnotationRef;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

public class SimpleGroovyClassDocAssembler
extends VisitorAdapter
implements GroovyTokenTypes {
    private static final String FS = "/";
    private static final Pattern PREV_JAVADOC_COMMENT_PATTERN = Pattern.compile("(?s)/\\*\\*(.*?)\\*/");
    private final Stack<GroovySourceAST> stack;
    private Map<String, GroovyClassDoc> classDocs;
    private List<String> importedClassesAndPackages;
    private List<LinkArgument> links;
    private Properties properties;
    private SimpleGroovyFieldDoc currentFieldDoc;
    private SourceBuffer sourceBuffer;
    private String packagePath;
    private LineColumn lastLineCol;
    private boolean insideEnum;
    private Map<String, SimpleGroovyClassDoc> foundClasses;
    private boolean isGroovy;
    private boolean deferSetup;
    private String className;

    public SimpleGroovyClassDocAssembler(String packagePath, String file, SourceBuffer sourceBuffer, List<LinkArgument> links, Properties properties, boolean isGroovy) {
        this.sourceBuffer = sourceBuffer;
        this.packagePath = packagePath;
        this.links = links;
        this.properties = properties;
        this.isGroovy = isGroovy;
        this.stack = new Stack();
        this.classDocs = new HashMap<String, GroovyClassDoc>();
        this.className = file;
        if (file != null) {
            int idx = file.lastIndexOf(".");
            this.className = file.substring(0, idx);
        }
        this.deferSetup = packagePath.equals("DefaultPackage");
        this.importedClassesAndPackages = new ArrayList<String>();
        if (!this.deferSetup) {
            this.setUpImports(packagePath, links, isGroovy, this.className);
        }
        this.lastLineCol = new LineColumn(1, 1);
    }

    private void setUpImports(String packagePath, List<LinkArgument> links, boolean isGroovy, String className) {
        this.importedClassesAndPackages.add(packagePath + "/*");
        if (isGroovy) {
            for (String pkg : ResolveVisitor.DEFAULT_IMPORTS) {
                this.importedClassesAndPackages.add(pkg.replace('.', '/') + "*");
            }
        } else {
            this.importedClassesAndPackages.add("java/lang/*");
        }
        SimpleGroovyClassDoc currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, className, links);
        currentClassDoc.setFullPathName(packagePath + FS + className);
        currentClassDoc.setGroovy(isGroovy);
        this.classDocs.put(currentClassDoc.getFullPathName(), currentClassDoc);
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        this.postProcessClassDocs();
        return this.classDocs;
    }

    public void visitInterfaceDef(GroovySourceAST t, int visit) {
        this.visitClassDef(t, visit);
    }

    public void visitEnumDef(GroovySourceAST t, int visit) {
        this.visitClassDef(t, visit);
        SimpleGroovyClassDoc currentClassDoc = this.getCurrentOrTopLevelClassDoc(t);
        if (visit == 4 && currentClassDoc != null) {
            this.adjustForAutomaticEnumMethods(currentClassDoc);
        }
    }

    public void visitAnnotationDef(GroovySourceAST t, int visit) {
        this.visitClassDef(t, visit);
    }

    public void visitClassDef(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String shortName;
            SimpleGroovyClassDoc parent = this.getCurrentClassDoc();
            String className = shortName = this.getIdentFor(t);
            if (parent != null && this.isNested() && !this.insideAnonymousInnerClass()) {
                className = parent.name() + "." + className;
            } else {
                this.foundClasses = new HashMap<String, SimpleGroovyClassDoc>();
            }
            SimpleGroovyClassDoc current = (SimpleGroovyClassDoc)this.classDocs.get(this.packagePath + FS + className);
            if (current == null) {
                current = new SimpleGroovyClassDoc(this.importedClassesAndPackages, className, this.links);
                current.setGroovy(this.isGroovy);
            }
            current.setRawCommentText(this.getJavaDocCommentsBeforeNode(t));
            current.setFullPathName(this.packagePath + FS + current.name());
            current.setTokenType(t.getType());
            this.processAnnotations(t, current);
            this.processModifiers(t, current);
            this.classDocs.put(current.getFullPathName(), current);
            this.foundClasses.put(shortName, current);
            if (parent != null) {
                parent.addNested(current);
                current.setOuter(parent);
            }
        }
    }

    public void visitPackageDef(GroovySourceAST t, int visit) {
        if (visit == 1 && this.deferSetup) {
            String packageWithSlashes = this.extractImportPath(t);
            this.setUpImports(packageWithSlashes, this.links, this.isGroovy, this.className);
        }
    }

    public void visitImport(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String importTextWithSlashesInsteadOfDots = this.extractImportPath(t);
            this.importedClassesAndPackages.add(importTextWithSlashesInsteadOfDots);
        }
    }

    public void visitExtendsClause(GroovySourceAST t, int visit) {
        SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
        if (visit == 1) {
            for (GroovySourceAST superClassNode : this.findTypeNames(t)) {
                String superClassName = this.extractName(superClassNode);
                if (currentClassDoc.isInterface()) {
                    currentClassDoc.addInterfaceName(superClassName);
                    continue;
                }
                currentClassDoc.setSuperClassName(superClassName);
            }
        }
    }

    public void visitImplementsClause(GroovySourceAST t, int visit) {
        if (visit == 1) {
            for (GroovySourceAST classNode : this.findTypeNames(t)) {
                this.getCurrentClassDoc().addInterfaceName(this.extractName(classNode));
            }
        }
    }

    private List<GroovySourceAST> findTypeNames(GroovySourceAST t) {
        ArrayList<GroovySourceAST> types = new ArrayList<GroovySourceAST>();
        for (AST child = t.getFirstChild(); child != null; child = child.getNextSibling()) {
            GroovySourceAST groovySourceAST = (GroovySourceAST)child;
            if (groovySourceAST.getType() == 12) {
                types.add((GroovySourceAST)groovySourceAST.getFirstChild());
                continue;
            }
            types.add(groovySourceAST);
        }
        return types;
    }

    public void visitCtorIdent(GroovySourceAST t, int visit) {
        if (visit == 1 && !this.insideEnum && !this.insideAnonymousInnerClass()) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            SimpleGroovyConstructorDoc currentConstructorDoc = new SimpleGroovyConstructorDoc(currentClassDoc.name(), currentClassDoc);
            currentConstructorDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t));
            this.processModifiers(t, currentConstructorDoc);
            this.addParametersTo(t, currentConstructorDoc);
            this.processAnnotations(t, currentConstructorDoc);
            currentClassDoc.add(currentConstructorDoc);
        }
    }

    public void visitMethodDef(GroovySourceAST t, int visit) {
        if (visit == 1 && !this.insideEnum && !this.insideAnonymousInnerClass()) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            if (currentClassDoc == null) {
                if ("true".equals(this.properties.getProperty("processScripts", "true"))) {
                    currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, this.className, this.links);
                    currentClassDoc.setFullPathName(this.packagePath + FS + this.className);
                    currentClassDoc.setPublic(true);
                    currentClassDoc.setScript(true);
                    currentClassDoc.setGroovy(this.isGroovy);
                    currentClassDoc.setSuperClassName("groovy/lang/Script");
                    if ("true".equals(this.properties.getProperty("includeMainForScripts", "true"))) {
                        currentClassDoc.add(this.createMainMethod(currentClassDoc));
                    }
                    this.classDocs.put(currentClassDoc.getFullPathName(), currentClassDoc);
                    if (this.foundClasses == null) {
                        this.foundClasses = new HashMap<String, SimpleGroovyClassDoc>();
                    }
                    this.foundClasses.put(this.className, currentClassDoc);
                } else {
                    return;
                }
            }
            SimpleGroovyMethodDoc currentMethodDoc = this.createMethod(t, currentClassDoc);
            currentClassDoc.add(currentMethodDoc);
        }
    }

    private SimpleGroovyMethodDoc createMethod(GroovySourceAST t, SimpleGroovyClassDoc currentClassDoc) {
        String methodName = this.getIdentFor(t);
        SimpleGroovyMethodDoc currentMethodDoc = new SimpleGroovyMethodDoc(methodName, currentClassDoc);
        currentMethodDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t));
        this.processModifiers(t, currentMethodDoc);
        currentMethodDoc.setReturnType(new SimpleGroovyType(this.getTypeOrDefault(t)));
        this.addParametersTo(t, currentMethodDoc);
        this.processAnnotations(t, currentMethodDoc);
        return currentMethodDoc;
    }

    private GroovyMethodDoc createMainMethod(SimpleGroovyClassDoc currentClassDoc) {
        SimpleGroovyMethodDoc mainMethod = new SimpleGroovyMethodDoc("main", currentClassDoc);
        mainMethod.setPublic(true);
        mainMethod.setStatic(true);
        mainMethod.setCommentText("Implicit main method for Groovy Scripts");
        mainMethod.setFirstSentenceCommentText(mainMethod.commentText());
        SimpleGroovyParameter args = new SimpleGroovyParameter("args");
        SimpleGroovyType argsType = new SimpleGroovyType("java.lang.String[]");
        args.setType(argsType);
        mainMethod.add(args);
        SimpleGroovyType returnType = new SimpleGroovyType("void");
        mainMethod.setReturnType(returnType);
        return mainMethod;
    }

    public void visitAnnotationFieldDef(GroovySourceAST t, int visit) {
        if (this.isGroovy && visit == 1) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            SimpleGroovyMethodDoc currentMethodDoc = this.createMethod(t, currentClassDoc);
            String defaultText = this.getDefaultValue(t);
            if (defaultText != null) {
                String orig = currentMethodDoc.getRawCommentText();
                currentMethodDoc.setRawCommentText(orig + "\n* @default " + defaultText);
            }
            currentClassDoc.add(currentMethodDoc);
        } else if (visit == 1) {
            this.visitVariableDef(t, visit);
            String defaultText = this.getDefaultValue(t);
            if (this.isGroovy) {
                this.currentFieldDoc.setPublic(true);
            }
            if (defaultText != null) {
                this.currentFieldDoc.setConstantValueExpression(defaultText);
                String orig = this.currentFieldDoc.getRawCommentText();
                this.currentFieldDoc.setRawCommentText(orig + "\n* @default " + defaultText);
            }
        }
    }

    public void visitEnumConstantDef(GroovySourceAST t, int visit) {
        if (visit == 1) {
            SimpleGroovyClassDoc currentClassDoc = this.getCurrentClassDoc();
            this.insideEnum = true;
            String enumConstantName = this.getIdentFor(t);
            SimpleGroovyFieldDoc currentEnumConstantDoc = new SimpleGroovyFieldDoc(enumConstantName, currentClassDoc);
            currentEnumConstantDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t));
            this.processModifiers(t, currentEnumConstantDoc);
            String typeName = this.getTypeNodeAsText(t.childOfType(12), currentClassDoc.getTypeDescription());
            currentEnumConstantDoc.setType(new SimpleGroovyType(typeName));
            currentClassDoc.addEnumConstant(currentEnumConstantDoc);
        } else if (visit == 4) {
            this.insideEnum = false;
        }
    }

    public void visitVariableDef(GroovySourceAST t, int visit) {
        SimpleGroovyClassDoc currentClassDoc;
        if (visit == 1 && !this.insideAnonymousInnerClass() && this.isFieldDefinition() && (currentClassDoc = this.getCurrentClassDoc()) != null) {
            String fieldName = this.getIdentFor(t);
            this.currentFieldDoc = new SimpleGroovyFieldDoc(fieldName, currentClassDoc);
            this.currentFieldDoc.setRawCommentText(this.getJavaDocCommentsBeforeNode(t));
            boolean isProp = this.processModifiers(t, this.currentFieldDoc);
            this.currentFieldDoc.setType(new SimpleGroovyType(this.getTypeOrDefault(t)));
            this.processAnnotations(t, this.currentFieldDoc);
            if (isProp) {
                currentClassDoc.addProperty(this.currentFieldDoc);
            } else {
                currentClassDoc.add(this.currentFieldDoc);
            }
        }
    }

    public void visitAssign(GroovySourceAST t, int visit) {
        this.gobbleComments(t, visit);
    }

    public void visitMethodCall(GroovySourceAST t, int visit) {
        this.gobbleComments(t, visit);
    }

    private void gobbleComments(GroovySourceAST t, int visit) {
        SimpleGroovyClassDoc currentClassDoc;
        if (visit == 1 && ((currentClassDoc = this.getCurrentClassDoc()) == null || currentClassDoc.isScript()) && (t.getLine() > this.lastLineCol.getLine() || t.getLine() == this.lastLineCol.getLine() && t.getColumn() > this.lastLineCol.getColumn())) {
            this.getJavaDocCommentsBeforeNode(t);
            this.lastLineCol = new LineColumn(t.getLine(), t.getColumn());
        }
    }

    private void postProcessClassDocs() {
        for (GroovyClassDoc groovyClassDoc : this.classDocs.values()) {
            GroovyConstructorDoc[] constructors;
            SimpleGroovyClassDoc classDoc = (SimpleGroovyClassDoc)groovyClassDoc;
            if (!classDoc.isClass() || (constructors = classDoc.constructors()) == null || constructors.length != 0) continue;
            SimpleGroovyConstructorDoc constructorDoc = new SimpleGroovyConstructorDoc(classDoc.name(), classDoc);
            classDoc.add(constructorDoc);
        }
    }

    private boolean isNested() {
        return this.getCurrentClassDoc() != null;
    }

    private boolean isTopLevelConstruct(GroovySourceAST node) {
        if (node == null) {
            return false;
        }
        int type = node.getType();
        return type == 13 || type == 14 || type == 63 || type == 60;
    }

    private void adjustForAutomaticEnumMethods(SimpleGroovyClassDoc currentClassDoc) {
        SimpleGroovyMethodDoc valueOf = new SimpleGroovyMethodDoc("valueOf", currentClassDoc);
        valueOf.setRawCommentText("Returns the enum constant of this type with the specified name.");
        SimpleGroovyParameter parameter = new SimpleGroovyParameter("name");
        parameter.setTypeName("String");
        valueOf.add(parameter);
        valueOf.setReturnType(new SimpleGroovyType(currentClassDoc.name()));
        currentClassDoc.add(valueOf);
        SimpleGroovyMethodDoc values = new SimpleGroovyMethodDoc("values", currentClassDoc);
        values.setRawCommentText("Returns an array containing the constants of this enum type, in the order they are declared.");
        values.setReturnType(new SimpleGroovyType(currentClassDoc.name() + "[]"));
        currentClassDoc.add(values);
    }

    private String extractImportPath(GroovySourceAST t) {
        GroovySourceAST child = t.childOfType(89);
        if (child == null) {
            child = t.childOfType(86);
        }
        return this.recurseDownImportBranch(child);
    }

    private String recurseDownImportBranch(GroovySourceAST t) {
        if (t != null) {
            if (t.getType() == 89) {
                GroovySourceAST firstChild = (GroovySourceAST)t.getFirstChild();
                GroovySourceAST secondChild = (GroovySourceAST)firstChild.getNextSibling();
                return this.recurseDownImportBranch(firstChild) + FS + this.recurseDownImportBranch(secondChild);
            }
            if (t.getType() == 86) {
                return t.getText();
            }
            if (t.getType() == 111) {
                return t.getText();
            }
        }
        return "";
    }

    private void addAnnotationRef(SimpleGroovyProgramElementDoc node, GroovySourceAST t) {
        GroovySourceAST classNode = t.childOfType(86);
        if (classNode != null) {
            node.addAnnotationRef(new SimpleGroovyAnnotationRef(this.extractName(classNode), this.getChildTextFromSource(t).trim()));
        }
    }

    private void addAnnotationRef(SimpleGroovyParameter node, GroovySourceAST t) {
        GroovySourceAST classNode = t.childOfType(86);
        if (classNode != null) {
            node.addAnnotationRef(new SimpleGroovyAnnotationRef(this.extractName(classNode), this.getChildTextFromSource(t).trim()));
        }
    }

    private void addAnnotationRefs(SimpleGroovyProgramElementDoc node, List<GroovySourceAST> nodes) {
        for (GroovySourceAST t : nodes) {
            this.addAnnotationRef(node, t);
        }
    }

    private void processAnnotations(GroovySourceAST t, SimpleGroovyProgramElementDoc node) {
        GroovySourceAST modifiers = t.childOfType(5);
        if (modifiers != null) {
            this.addAnnotationRefs(node, modifiers.childrenOfType(65));
        }
    }

    private String getDefaultValue(GroovySourceAST t) {
        GroovySourceAST child = (GroovySourceAST)t.getFirstChild();
        if (t.getNumberOfChildren() != 4) {
            return null;
        }
        for (int i = 1; i < t.getNumberOfChildren(); ++i) {
            child = (GroovySourceAST)child.getNextSibling();
        }
        GroovySourceAST nodeToProcess = child;
        if (child.getType() != 68 && child.getNumberOfChildren() > 0) {
            nodeToProcess = (GroovySourceAST)child.getFirstChild();
        }
        return this.getChildTextFromSource(nodeToProcess, ";");
    }

    private String getChildTextFromSource(GroovySourceAST child) {
        return this.sourceBuffer.getSnippet(new LineColumn(child.getLine(), child.getColumn()), new LineColumn(child.getLineLast(), child.getColumnLast()));
    }

    private String getChildTextFromSource(GroovySourceAST child, String tokens) {
        String text = this.sourceBuffer.getSnippet(new LineColumn(child.getLine(), child.getColumn()), new LineColumn(child.getLine() + 1, 0));
        StringTokenizer st = new StringTokenizer(text, tokens);
        return st.nextToken();
    }

    private boolean isFieldDefinition() {
        GroovySourceAST parentNode = this.getParentNode();
        return parentNode != null && parentNode.getType() == 6;
    }

    private boolean insideAnonymousInnerClass() {
        GroovySourceAST grandParentNode = this.getGrandParentNode();
        return grandParentNode != null && grandParentNode.getType() == 157;
    }

    private boolean processModifiers(GroovySourceAST t, SimpleGroovyAbstractableElementDoc memberOrClass) {
        GroovySourceAST modifiers = t.childOfType(5);
        boolean hasNonPublicVisibility = false;
        boolean hasPublicVisibility = false;
        if (modifiers != null) {
            block8: for (AST currentModifier = modifiers.getFirstChild(); currentModifier != null; currentModifier = currentModifier.getNextSibling()) {
                int type = currentModifier.getType();
                switch (type) {
                    case 114: {
                        memberOrClass.setPublic(true);
                        hasPublicVisibility = true;
                        continue block8;
                    }
                    case 115: {
                        memberOrClass.setProtected(true);
                        hasNonPublicVisibility = true;
                        continue block8;
                    }
                    case 113: {
                        memberOrClass.setPrivate(true);
                        hasNonPublicVisibility = true;
                        continue block8;
                    }
                    case 82: {
                        memberOrClass.setStatic(true);
                        continue block8;
                    }
                    case 37: {
                        memberOrClass.setFinal(true);
                        continue block8;
                    }
                    case 38: {
                        memberOrClass.setAbstract(true);
                    }
                }
            }
            if (!hasNonPublicVisibility && this.isGroovy && !(memberOrClass instanceof GroovyFieldDoc)) {
                memberOrClass.setPublic(true);
            } else if (!(hasNonPublicVisibility || hasPublicVisibility || this.isGroovy)) {
                if (this.insideInterface(memberOrClass) || this.insideAnnotationDef(memberOrClass)) {
                    memberOrClass.setPublic(true);
                } else {
                    memberOrClass.setPackagePrivate(true);
                }
            }
            if (memberOrClass instanceof GroovyFieldDoc && !hasNonPublicVisibility && !hasPublicVisibility && this.isGroovy) {
                return true;
            }
        } else if (this.isGroovy && !(memberOrClass instanceof GroovyFieldDoc)) {
            memberOrClass.setPublic(true);
        } else if (!this.isGroovy) {
            if (this.insideInterface(memberOrClass) || this.insideAnnotationDef(memberOrClass)) {
                memberOrClass.setPublic(true);
            } else {
                memberOrClass.setPackagePrivate(true);
            }
        }
        return memberOrClass instanceof GroovyFieldDoc && this.isGroovy && !hasNonPublicVisibility & !hasPublicVisibility;
    }

    private boolean insideInterface(SimpleGroovyAbstractableElementDoc memberOrClass) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current == null || current == memberOrClass) {
            return false;
        }
        return current.isInterface();
    }

    private boolean insideAnnotationDef(SimpleGroovyAbstractableElementDoc memberOrClass) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current == null || current == memberOrClass) {
            return false;
        }
        return current.isAnnotationType();
    }

    private String getJavaDocCommentsBeforeNode(GroovySourceAST t) {
        Matcher m;
        String result = "";
        LineColumn thisLineCol = new LineColumn(t.getLine(), t.getColumn());
        String text = this.sourceBuffer.getSnippet(this.lastLineCol, thisLineCol);
        if (text != null && (m = PREV_JAVADOC_COMMENT_PATTERN.matcher(text)).find()) {
            result = m.group(1);
        }
        if (this.isMajorType(t)) {
            this.lastLineCol = thisLineCol;
        }
        return result;
    }

    private boolean isMajorType(GroovySourceAST t) {
        if (t == null) {
            return false;
        }
        int tt = t.getType();
        return tt == 13 || tt == 14 || tt == 8 || tt == 63 || tt == 60 || tt == 9 || tt == 67 || tt == 61 || tt == 45;
    }

    private String getText(GroovySourceAST node) {
        String returnValue = null;
        if (node != null) {
            returnValue = node.getText();
        }
        return returnValue;
    }

    private String extractName(GroovySourceAST typeNode) {
        String typeName = this.buildName(typeNode);
        if (typeName.indexOf(FS) == -1) {
            String slashName = FS + typeName;
            for (String name : this.importedClassesAndPackages) {
                if (!name.endsWith(slashName)) continue;
                typeName = name;
            }
        }
        return typeName;
    }

    private String buildName(GroovySourceAST t) {
        if (t != null) {
            if (t.getType() == 89) {
                GroovySourceAST firstChild = (GroovySourceAST)t.getFirstChild();
                GroovySourceAST secondChild = (GroovySourceAST)firstChild.getNextSibling();
                return this.buildName(firstChild) + FS + this.buildName(secondChild);
            }
            if (t.getType() == 86) {
                return t.getText();
            }
        }
        return "";
    }

    private String getTypeOrDefault(GroovySourceAST t) {
        GroovySourceAST typeNode = t.childOfType(12);
        return this.getTypeNodeAsText(typeNode, "def");
    }

    private String getTypeNodeAsText(GroovySourceAST typeNode, String defaultText) {
        if (typeNode != null && typeNode.getType() == 12 && typeNode.getNumberOfChildren() > 0) {
            return this.getAsText(typeNode, defaultText);
        }
        return defaultText;
    }

    private String getAsText(GroovySourceAST typeNode, String defaultText) {
        GroovySourceAST child = (GroovySourceAST)typeNode.getFirstChild();
        return this.getAsTextCurrent(child, defaultText);
    }

    private String getAsTextCurrent(GroovySourceAST node, String defaultText) {
        switch (node.getType()) {
            case 103: {
                return "boolean";
            }
            case 104: {
                return "byte";
            }
            case 105: {
                return "char";
            }
            case 110: {
                return "double";
            }
            case 108: {
                return "float";
            }
            case 107: {
                return "int";
            }
            case 109: {
                return "long";
            }
            case 106: {
                return "short";
            }
            case 102: {
                return "void";
            }
            case 16: {
                String componentType = this.getAsText(node, defaultText);
                if (!componentType.equals("def")) {
                    return componentType + "[]";
                }
                return "java/lang/Object[]";
            }
            case 86: {
                return node.getText();
            }
            case 89: {
                ArrayList<String> result = new ArrayList<String>();
                for (GroovySourceAST child = (GroovySourceAST)node.getFirstChild(); child != null; child = (GroovySourceAST)child.getNextSibling()) {
                    if (child.getType() == 86) {
                        result.add(child.getText());
                        continue;
                    }
                    if (child.getType() != 89) continue;
                    result.add(this.getAsTextCurrent(child, defaultText));
                }
                return DefaultGroovyMethods.join(result, (String)FS);
            }
        }
        return defaultText;
    }

    private void addParametersTo(GroovySourceAST t, SimpleGroovyExecutableMemberDoc executableMemberDoc) {
        GroovySourceAST parametersNode = t.childOfType(19);
        if (parametersNode != null && parametersNode.getNumberOfChildren() > 0) {
            for (GroovySourceAST currentNode = (GroovySourceAST)parametersNode.getFirstChild(); currentNode != null; currentNode = (GroovySourceAST)currentNode.getNextSibling()) {
                String parameterTypeName = this.getTypeOrDefault(currentNode);
                String parameterName = this.getText(currentNode.childOfType(86));
                SimpleGroovyParameter parameter = new SimpleGroovyParameter(parameterName);
                parameter.setVararg(currentNode.getType() == 46);
                parameter.setTypeName(parameterTypeName);
                GroovySourceAST modifiers = currentNode.childOfType(5);
                if (modifiers != null) {
                    List annotations = modifiers.childrenOfType(65);
                    for (GroovySourceAST a : annotations) {
                        this.addAnnotationRef(parameter, a);
                    }
                }
                executableMemberDoc.add(parameter);
                if (currentNode.getNumberOfChildren() != 4) continue;
                this.handleDefaultValue(currentNode, parameter);
            }
        }
    }

    private void handleDefaultValue(GroovySourceAST currentNode, SimpleGroovyParameter parameter) {
        GroovySourceAST paramPart = (GroovySourceAST)currentNode.getFirstChild();
        for (int i = 1; i < currentNode.getNumberOfChildren(); ++i) {
            paramPart = (GroovySourceAST)paramPart.getNextSibling();
        }
        GroovySourceAST nodeToProcess = paramPart;
        if (paramPart.getNumberOfChildren() > 0) {
            nodeToProcess = (GroovySourceAST)paramPart.getFirstChild();
        }
        parameter.setDefaultValue(this.getChildTextFromSource(nodeToProcess, ",)"));
    }

    public void push(GroovySourceAST t) {
        this.stack.push(t);
    }

    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        GroovySourceAST parentNode = null;
        GroovySourceAST currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            parentNode = this.stack.peek();
        }
        this.stack.push(currentNode);
        return parentNode;
    }

    private GroovySourceAST getGrandParentNode() {
        GroovySourceAST grandParentNode = null;
        GroovySourceAST currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            GroovySourceAST parentNode = this.stack.pop();
            if (!this.stack.empty()) {
                grandParentNode = this.stack.peek();
            }
            this.stack.push(parentNode);
        }
        this.stack.push(currentNode);
        return grandParentNode;
    }

    private SimpleGroovyClassDoc getCurrentOrTopLevelClassDoc(GroovySourceAST node) {
        SimpleGroovyClassDoc current = this.getCurrentClassDoc();
        if (current != null) {
            return current;
        }
        return this.foundClasses.get(this.getIdentFor(node));
    }

    private SimpleGroovyClassDoc getCurrentClassDoc() {
        if (this.stack.isEmpty()) {
            return null;
        }
        GroovySourceAST node = this.getParentNode();
        if (this.isTopLevelConstruct(node)) {
            return this.foundClasses.get(this.getIdentFor(node));
        }
        GroovySourceAST saved = this.stack.pop();
        SimpleGroovyClassDoc result = this.getCurrentClassDoc();
        this.stack.push(saved);
        return result;
    }

    private String getIdentFor(GroovySourceAST gpn) {
        return gpn.childOfType(86).getText();
    }
}

