/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.group;

import groovy.lang.Closure;
import groovyx.gpars.MessagingRunnable;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.BlockingActor;
import groovyx.gpars.actor.DefaultActor;
import groovyx.gpars.actor.DynamicDispatchActor;
import groovyx.gpars.actor.ReactiveActor;
import groovyx.gpars.actor.StaticDispatchActor;
import groovyx.gpars.actor.impl.RunnableBackedBlockingActor;
import groovyx.gpars.agent.Agent;
import groovyx.gpars.dataflow.Dataflow;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.Select;
import groovyx.gpars.dataflow.operator.DataflowOperator;
import groovyx.gpars.dataflow.operator.DataflowPrioritySelector;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.DataflowProcessorAtomicBoundAllClosure;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.scheduler.Pool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PGroup {
    protected static final String A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED = "A splitter needs an input channel and at least one output channel to be created.";
    private final Pool threadPool;

    public Pool getThreadPool() {
        return this.threadPool;
    }

    protected PGroup(Pool threadPool) {
        this.threadPool = threadPool;
    }

    public final DefaultActor actor(Runnable handler) {
        DefaultActor actor = new DefaultActor(handler);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final BlockingActor blockingActor(Runnable handler) {
        RunnableBackedBlockingActor actor = new RunnableBackedBlockingActor(handler);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final DefaultActor fairActor(Runnable handler) {
        DefaultActor actor = new DefaultActor(handler);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor reactor(Closure code) {
        ReactiveActor actor = new ReactiveActor(code);
        ((Actor)actor).setParallelGroup(this);
        ((Actor)actor).start();
        return actor;
    }

    public final Actor fairReactor(Closure code) {
        ReactiveActor actor = new ReactiveActor(code);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor messageHandler(Closure code) {
        DynamicDispatchActor actor = new DynamicDispatchActor().become(code);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final Actor fairMessageHandler(Closure code) {
        DynamicDispatchActor actor = new DynamicDispatchActor().become(code);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final Actor staticMessageHandler(final Closure code) {
        StaticDispatchActor<Object> actor = new StaticDispatchActor<Object>(){

            @Override
            public void onMessage(Object message) {
                code.call(message);
            }
        };
        code.setDelegate((Object)actor);
        code.setResolveStrategy(1);
        actor.setParallelGroup(this);
        actor.start();
        return actor;
    }

    public final Actor fairStaticMessageHandler(final Closure code) {
        StaticDispatchActor<Object> actor = new StaticDispatchActor<Object>(){

            @Override
            public void onMessage(Object message) {
                code.call(message);
            }
        };
        code.setDelegate((Object)actor);
        code.setResolveStrategy(1);
        actor.setParallelGroup(this);
        actor.makeFair();
        actor.start();
        return actor;
    }

    public final <T> Agent<T> agent(T state) {
        Agent<T> safe = new Agent<T>(state);
        safe.attachToThreadPool(this.threadPool);
        return safe;
    }

    public final <T> Agent<T> agent(T state, Closure copy) {
        Agent<T> safe = new Agent<T>(state, copy);
        safe.attachToThreadPool(this.threadPool);
        return safe;
    }

    public final <T> Agent<T> fairAgent(T state) {
        Agent<T> safe = this.agent(state);
        safe.makeFair();
        return safe;
    }

    public final <T> Agent<T> fairAgent(T state, Closure copy) {
        Agent<T> safe = this.agent(state, copy);
        safe.makeFair();
        return safe;
    }

    public DataflowVariable task(Closure code) {
        final Closure clonedCode = (Closure)code.clone();
        return this.task(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return clonedCode.call();
            }
        });
    }

    public DataflowVariable task(final Callable callable) {
        final DataflowVariable result = new DataflowVariable();
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Dataflow.activeParallelGroup.set(PGroup.this);
                try {
                    try {
                        result.bind(callable.call());
                    }
                    catch (Exception e) {
                        result.bind(e);
                    }
                }
                finally {
                    Dataflow.activeParallelGroup.remove();
                }
            }
        });
        return result;
    }

    public DataflowVariable task(final Runnable code) {
        if (code instanceof Closure) {
            return this.task((Closure)code);
        }
        final DataflowVariable result = new DataflowVariable();
        this.threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Dataflow.activeParallelGroup.set(PGroup.this);
                try {
                    code.run();
                    result.bind(null);
                }
                finally {
                    Dataflow.activeParallelGroup.remove();
                }
            }
        });
        return result;
    }

    public DataflowProcessor operator(Map channels, Closure code) {
        return new DataflowOperator(this, channels, code).start();
    }

    public DataflowProcessor operator(List inputChannels, List outputChannels, Closure code) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowOperator(this, params, code).start();
    }

    public DataflowProcessor operator(List inputChannels, List outputChannels, int maxForks, Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, code).start();
    }

    public DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, Closure code) {
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(5);
        params.put("inputs", Arrays.asList(input));
        params.put("outputs", Arrays.asList(output));
        return new DataflowOperator(this, params, code).start();
    }

    public DataflowProcessor operator(DataflowReadChannel input, DataflowWriteChannel output, int maxForks, Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", Arrays.asList(input));
        params.put("outputs", Arrays.asList(output));
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, code).start();
    }

    public DataflowProcessor selector(Map channels, Closure code) {
        return new DataflowSelector(this, channels, code).start();
    }

    public DataflowProcessor selector(List inputChannels, List outputChannels, Closure code) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowSelector(this, params, code).start();
    }

    public DataflowProcessor selector(Map channels) {
        return new DataflowSelector(this, channels, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public DataflowProcessor selector(List inputChannels, List outputChannels) {
        HashMap<String, List> params = new HashMap<String, List>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowSelector(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public DataflowProcessor prioritySelector(Map channels, Closure code) {
        return new DataflowPrioritySelector(this, (Map<String, Object>)channels, code).start();
    }

    public DataflowProcessor prioritySelector(List inputChannels, List outputChannels, Closure code) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowPrioritySelector(this, params, code).start();
    }

    public DataflowProcessor prioritySelector(Map channels) {
        return new DataflowPrioritySelector(this, (Map<String, Object>)channels, (Closure)new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public DataflowProcessor prioritySelector(List inputChannels, List outputChannels) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", inputChannels);
        params.put("outputs", outputChannels);
        return new DataflowPrioritySelector(this, params, (Closure)new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels) {
        if (inputChannel == null || outputChannels == null || outputChannels.isEmpty()) {
            throw new IllegalArgumentException(A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED);
        }
        HashMap<String, List<Object>> params = new HashMap<String, List<Object>>(5);
        params.put("inputs", Arrays.asList(inputChannel));
        params.put("outputs", outputChannels);
        return new DataflowOperator(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public DataflowProcessor splitter(DataflowReadChannel inputChannel, List<DataflowWriteChannel> outputChannels, int maxForks) {
        if (inputChannel == null || outputChannels == null || outputChannels.isEmpty()) {
            throw new IllegalArgumentException(A_SPLITTER_NEEDS_AN_INPUT_CHANNEL_AND_AT_LEAST_ONE_OUTPUT_CHANNEL_TO_BE_CREATED);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("inputs", Arrays.asList(inputChannel));
        params.put("outputs", outputChannels);
        params.put("maxForks", maxForks);
        return new DataflowOperator(this, params, new DataflowProcessorAtomicBoundAllClosure()).start();
    }

    public Select select(DataflowReadChannel ... channels) {
        return new Select(this, channels);
    }

    public Select select(List<DataflowReadChannel> channels) {
        return new Select(this, channels);
    }

    public <T> Promise<T> whenAllBound(List<Promise<?>> promises, Closure<T> code) {
        if (promises.size() != code.getMaximumNumberOfParameters() && !PGroup.isListAccepting(code)) {
            throw new IllegalArgumentException("Cannot run whenAllBound(), since the number of promises does not match the number of arguments to the supplied closure.");
        }
        DataflowVariable result = new DataflowVariable();
        PGroup.whenAllBound(promises, 0, new ArrayList<Object>(promises.size()), result, code);
        return result;
    }

    private static <T> void whenAllBound(final List<Promise<?>> promises, final int index, final List<Object> values, final DataflowVariable<T> result, final Closure<T> code) {
        if (index == promises.size()) {
            if (PGroup.isListAccepting(code)) {
                result.leftShift(code.call(values));
            } else {
                result.leftShift(code.call(values.toArray()));
            }
        } else {
            promises.get(index).whenBound(new MessagingRunnable<Object>(){

                @Override
                protected void doRun(Object argument) {
                    values.add(argument);
                    PGroup.whenAllBound(promises, index + 1, values, result, code);
                }
            });
        }
    }

    private static <T> boolean isListAccepting(Closure<T> code) {
        return code.getMaximumNumberOfParameters() == 1 && List.class.isAssignableFrom(code.getParameterTypes()[0]);
    }

    protected void finalize() throws Throwable {
        this.threadPool.shutdown();
        super.finalize();
    }

    public void resize(int poolSize) {
        this.threadPool.resize(poolSize);
    }

    public void resetDefaultSize() {
        this.threadPool.resetDefaultSize();
    }

    public int getPoolSize() {
        return this.threadPool.getPoolSize();
    }

    public void execute(Runnable task) {
        this.threadPool.execute(task);
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }
}

