/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.SelectResult;
import groovyx.gpars.dataflow.operator.DataflowProcessorActor;
import groovyx.gpars.dataflow.operator.DataflowSelector;
import groovyx.gpars.dataflow.operator.StopGently;
import groovyx.gpars.group.PGroup;
import java.util.List;

class DataflowSelectorActor
extends DataflowProcessorActor {
    protected final boolean passIndex;

    DataflowSelectorActor(DataflowSelector owningOperator, PGroup group, List outputs, List inputs, Closure code) {
        super(owningOperator, group, outputs, inputs, code);
        this.passIndex = code.getMaximumNumberOfParameters() == 2;
    }

    void afterStart() {
        ((DataflowSelector)this.owningProcessor).doSelect();
    }

    public final void onMessage(Object message) {
        if (message instanceof StopGently) {
            this.stoppingGently = true;
            return;
        }
        SelectResult msg = (SelectResult)message;
        int index = msg.getIndex();
        Object value = msg.getValue();
        if (this.checkPoison(value)) {
            return;
        }
        this.startTask(index, value);
        if (this.stoppingGently) {
            this.stop();
        }
        if (!this.hasBeenStopped()) {
            ((DataflowSelector)this.owningProcessor).doSelect();
        }
    }

    void startTask(int index, Object result) {
        try {
            if (this.passIndex) {
                this.code.call(new Object[]{result, index});
            } else {
                this.code.call(result);
            }
        }
        catch (Throwable e) {
            this.reportException(e);
        }
    }
}

