/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.actor.StaticDispatchActor;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.PoisonPill;
import groovyx.gpars.group.PGroup;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataflowProcessorActor
extends StaticDispatchActor<Object> {
    protected static final String CANNOT_OBTAIN_THE_SEMAPHORE_TO_FORK_OPERATOR_S_BODY = "Cannot obtain the semaphore to fork operator's body.";
    protected final List inputs;
    protected final List outputs;
    protected final Closure code;
    protected final DataflowProcessor owningProcessor;
    protected boolean stoppingGently = false;

    DataflowProcessorActor(DataflowProcessor owningProcessor, PGroup group, List outputs, List inputs, Closure code) {
        this.setParallelGroup(group);
        this.owningProcessor = owningProcessor;
        this.outputs = outputs;
        this.inputs = inputs;
        this.code = code;
    }

    @Override
    public MessageStream send(Object message) {
        block2: {
            try {
                super.send(message);
            }
            catch (IllegalStateException e) {
                if (this.hasBeenStopped()) break block2;
                throw e;
            }
        }
        return this;
    }

    @Override
    public void onMessage(Object message) {
        throw new IllegalStateException("The dataflow actor doesn't recognize the message $message");
    }

    boolean checkPoison(Object data) {
        if (data instanceof PoisonPill) {
            this.owningProcessor.bindAllOutputsAtomically(data);
            this.owningProcessor.terminate();
            ((PoisonPill)data).countDown();
            return true;
        }
        return false;
    }

    final void reportException(Throwable e) {
        this.owningProcessor.reportError(e);
    }
}

