/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.DataflowWriteChannel;
import groovyx.gpars.dataflow.operator.DataflowProcessorActor;
import groovyx.gpars.dataflow.operator.StopGently;
import groovyx.gpars.group.PGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataflowProcessor {
    public static final String INPUTS = "inputs";
    public static final String OUTPUTS = "outputs";
    public static final String MAX_FORKS = "maxForks";
    protected DataflowProcessorActor actor;
    private List<Closure> errorHandlers;

    protected DataflowProcessor(Map<String, Object> channels, Closure code) {
        code.setDelegate((Object)this);
        if (channels == null) {
            return;
        }
        Collection inputs = (Collection)channels.get(INPUTS);
        if (inputs == null || inputs.isEmpty()) {
            throw new IllegalArgumentException("The processor body must take some inputs. The provided list of input channels is empty.");
        }
    }

    static boolean shouldBeMultiThreaded(Map<String, Object> channels) {
        Integer maxForks = (Integer)channels.get(MAX_FORKS);
        return maxForks != null && maxForks != 1;
    }

    static List<DataflowReadChannel> extractInputs(Map<String, Object> channels) {
        List inputs = (List)channels.get(INPUTS);
        return Collections.unmodifiableList(inputs);
    }

    static List<DataflowWriteChannel> extractOutputs(Map<String, Object> channels) {
        List outputs = (List)channels.get(OUTPUTS);
        if (outputs != null) {
            return Collections.unmodifiableList(outputs);
        }
        return null;
    }

    protected static void checkMaxForks(Map channels) {
        if ((Integer)channels.get(MAX_FORKS) < 1) {
            throw new IllegalArgumentException("The maxForks argument must be a positive value. " + channels.get(MAX_FORKS) + " was provided.");
        }
    }

    public final DataflowProcessor start(PGroup group) {
        this.actor.setParallelGroup(group);
        this.actor.start();
        return this;
    }

    public final DataflowProcessor start() {
        this.actor.start();
        return this;
    }

    public final void terminate() {
        this.actor.terminate();
    }

    public final void terminateAfterNextRun() {
        this.actor.send(StopGently.getInstance());
    }

    public final void join() throws InterruptedException {
        this.actor.join();
    }

    public final void bindOutput(int idx, Object value) {
        ((DataflowWriteChannel)this.actor.outputs.get(idx)).bind(value);
    }

    public final void bindOutput(Object value) {
        this.bindOutput(0, value);
    }

    public final void bindAllOutputs(Object value) {
        for (Object output : this.actor.outputs) {
            ((DataflowWriteChannel)output).bind(value);
        }
    }

    public final void bindAllOutputValues(Object ... values) {
        List<DataflowWriteChannel> outputs = this.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            outputs.get(i).bind(values[i]);
        }
    }

    public final synchronized void bindAllOutputsAtomically(Object value) {
        for (DataflowWriteChannel writeChannel : this.getOutputs()) {
            writeChannel.bind(value);
        }
    }

    public final synchronized void bindAllOutputValuesAtomically(Object ... values) {
        List<DataflowWriteChannel> outputs = this.getOutputs();
        for (int i = 0; i < outputs.size(); ++i) {
            outputs.get(i).bind(values[i]);
        }
    }

    public final DataflowWriteChannel getOutputs(int idx) {
        if (this.actor.outputs.isEmpty()) {
            return null;
        }
        return (DataflowWriteChannel)this.actor.outputs.get(idx);
    }

    public final List<DataflowWriteChannel> getOutputs() {
        return this.actor.outputs;
    }

    public final DataflowWriteChannel getOutput() {
        if (this.actor.outputs.isEmpty()) {
            return null;
        }
        return (DataflowWriteChannel)this.actor.outputs.get(0);
    }

    final synchronized void reportError(Throwable e) {
        if (this.errorHandlers == null || this.errorHandlers.isEmpty()) {
            System.err.println("The dataflow processor experienced an exception and is about to terminate. " + e);
        } else {
            for (Closure errorHandler : this.errorHandlers) {
                errorHandler.call((Object)e);
            }
        }
        this.terminate();
    }

    public final synchronized void addErrorHandler(Closure handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Error handler must not be null.");
        }
        if (this.errorHandlers == null) {
            this.errorHandlers = new ArrayList<Closure>();
        }
        handler.setDelegate((Object)this);
        handler.setResolveStrategy(1);
        this.errorHandlers.add(handler);
    }
}

