/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovyx.gpars.dataflow.DataflowVariable;
import groovyx.gpars.dataflow.Promise;
import groovyx.gpars.dataflow.operator.PoisonPill;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CountingPoisonPill
extends PoisonPill {
    private final DataflowVariable<Boolean> termination = new DataflowVariable();
    private final AtomicInteger counter;

    public CountingPoisonPill(int count) {
        this.counter = new AtomicInteger(count);
    }

    public void join() throws InterruptedException {
        this.termination.join();
    }

    public void join(long timeout, TimeUnit unit) throws InterruptedException {
        this.termination.join(timeout, unit);
    }

    public Promise<Boolean> getTermination() {
        return this.termination;
    }

    @Override
    void countDown() {
        int currentValue = this.counter.decrementAndGet();
        if (currentValue == 0) {
            this.termination.bind(true);
        }
    }
}

