/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.serial;

import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.WithSerialId;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;

public abstract class RemoteHandle
implements Serializable {
    protected final UUID serialId;
    protected final UUID hostId;

    public RemoteHandle(UUID hostId, UUID id) {
        this.hostId = hostId;
        this.serialId = id;
    }

    protected final Object readResolve() throws ObjectStreamException {
        WithSerialId obj;
        SerialContext context = SerialContext.get();
        SerialHandle serialHandle = context.get(this.serialId);
        if (serialHandle == null || (obj = (WithSerialId)serialHandle.get()) == null) {
            try {
                obj = this.createObject(context);
                obj.serialHandle = SerialHandle.create(obj, this.serialId);
            }
            catch (Exception t) {
                throw new WriteAbortedException(t.getMessage(), t);
            }
        }
        return obj;
    }

    protected abstract WithSerialId createObject(SerialContext var1) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException;
}

