/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.FJPool;
import java.text.MessageFormat;

public final class ResizeableFJPool
extends FJPool {
    private static final int MAX_POOL_SIZE = 1000;
    private final Object lock = new Object();

    public ResizeableFJPool() {
    }

    public ResizeableFJPool(int poolSize) {
        super(poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final Runnable task) {
        Object object = this.lock;
        synchronized (object) {
            int currentPoolSize = this.pool.getPoolSize();
            int submissionCount = this.pool.getActiveSubmissionCount();
            int needForThreads = submissionCount + 1 - currentPoolSize;
            if (needForThreads > 0) {
                if (currentPoolSize + needForThreads > 1000) {
                    throw new IllegalStateException(MessageFormat.format("The thread pool executor cannot run the task. The upper limit of the thread pool size has probably been reached. Current pool size: {0} Maximum pool size: {1}", currentPoolSize, 1000));
                }
                this.pool.addWorkers(needForThreads);
            }
        }
        super.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                task.run();
                Object object = ResizeableFJPool.this.lock;
                synchronized (object) {
                    int currentPoolSize = ResizeableFJPool.this.pool.getPoolSize();
                    int submissionCount = ResizeableFJPool.this.pool.getActiveSubmissionCount();
                    int desiredPoolSize = Math.max(submissionCount, ResizeableFJPool.this.getConfiguredPoolSize());
                    int change = currentPoolSize - desiredPoolSize;
                    if (change >= 3) {
                        ResizeableFJPool.this.pool.removeWorkers(change);
                    }
                }
            }
        });
    }
}

