/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.scheduler;

import groovyx.gpars.scheduler.FJRunnableTask;
import groovyx.gpars.scheduler.Pool;
import groovyx.gpars.util.PoolUtils;
import java.util.concurrent.TimeUnit;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;

public class FJPool
implements Pool {
    protected ForkJoinPool pool;
    private final int configuredPoolSize;
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 30L;

    public FJPool() {
        this(PoolUtils.retrieveDefaultPoolSize());
    }

    public FJPool(int configuredPoolSize) {
        if (configuredPoolSize < 0) {
            throw new IllegalStateException("Pool size must be a non-negative number.");
        }
        this.configuredPoolSize = configuredPoolSize;
        this.pool = FJPool.createPool(configuredPoolSize);
    }

    private static ForkJoinPool createPool(int poolSize) {
        assert (poolSize > 0);
        ForkJoinPool pool = new ForkJoinPool(poolSize);
        pool.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                System.err.println("Uncaught exception occurred in actor pool " + t.getName());
                e.printStackTrace(System.err);
            }
        });
        return pool;
    }

    public final void resize(int poolSize) {
        if (poolSize < 0) {
            throw new IllegalStateException("Pool size must be a non-negative number.");
        }
        this.pool.setPoolSize(poolSize);
    }

    public final void resetDefaultSize() {
        this.resize(PoolUtils.retrieveDefaultPoolSize());
    }

    public void execute(Runnable task) {
        this.pool.submit((ForkJoinTask)new FJRunnableTask(task));
    }

    public final ForkJoinPool getForkJoinPool() {
        return this.pool;
    }

    public final void shutdown() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
    }

    protected final int getConfiguredPoolSize() {
        return this.configuredPoolSize;
    }
}

