/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow;

import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataFlowExpression;
import groovyx.gpars.dataflow.DataFlowVariable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataFlowStream<T> {
    private final Object queueLock = new Object();
    private final LinkedBlockingQueue<DataFlowVariable<T>> queue = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<DataFlowVariable<T>> requests = new LinkedBlockingQueue();

    public void leftShift(DataFlowExpression<T> ref) {
        final DataFlowVariable<T> originalRef = this.retrieveForBind();
        ref.getValAsync(new MessageStream(){
            private static final long serialVersionUID = -4966523895011173569L;

            public MessageStream send(Object message) {
                originalRef.bind(message);
                return this;
            }
        });
    }

    public void leftShift(T value) {
        this.retrieveForBind().bind(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataFlowVariable<T> retrieveForBind() {
        DataFlowVariable<T> ref;
        Object object = this.queueLock;
        synchronized (object) {
            ref = this.requests.poll();
            if (ref == null) {
                ref = new DataFlowVariable();
                this.queue.offer(ref);
            }
        }
        return ref;
    }

    public T getVal() throws InterruptedException {
        return this.retrieveOrCreateVariable().getVal();
    }

    public void getValAsync(MessageStream messageStream) {
        this.getValAsync(null, messageStream);
    }

    public void getValAsync(Object attachment, MessageStream messageStream) {
        this.retrieveOrCreateVariable().getValAsync(attachment, messageStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataFlowVariable<T> retrieveOrCreateVariable() {
        DataFlowVariable<T> dataFlowVariable;
        Object object = this.queueLock;
        synchronized (object) {
            dataFlowVariable = this.queue.poll();
            if (dataFlowVariable == null) {
                dataFlowVariable = new DataFlowVariable();
                this.requests.offer(dataFlowVariable);
            }
        }
        return dataFlowVariable;
    }

    public int length() {
        return this.queue.size();
    }

    public Iterator<T> iterator() {
        final Iterator<DataFlowVariable<T>> iterator = this.queue.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                try {
                    return ((DataFlowVariable)iterator.next()).getVal();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("The thread has been interrupted, which prevented the iterator from retrieving the next element.", e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not available");
            }
        };
    }

    public String toString() {
        return "DataFlowStream(queue=" + new ArrayList<DataFlowVariable<T>>(this.queue).toString() + ')';
    }
}

