/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernatePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(HibernatePersistenceContextInterceptor.class);
    private SessionFactory sessionFactory;
    private ThreadLocal<Boolean> participate = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private ThreadLocal<Integer> nestingCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public void destroy() {
        if (this.decNestingCount() > 0 || this.getParticipate()) {
            return;
        }
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        LOG.debug((Object)"Closing single Hibernate session in GrailsDispatcherServlet");
        try {
            Session session = holder.getSession();
            SessionFactoryUtils.closeSession((Session)session);
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Unexpected exception on closing Hibernate Session", (Throwable)ex);
        }
    }

    public void disconnect() {
        try {
            this.getSession(false).disconnect();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void reconnect() {
        this.getSession().reconnect();
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void setReadOnly() {
        this.getSession().setFlushMode(FlushMode.MANUAL);
    }

    public void setReadWrite() {
        this.getSession().setFlushMode(FlushMode.AUTO);
    }

    public boolean isOpen() {
        try {
            return this.getSession(false).isOpen();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void init() {
        if (this.incNestingCount() > 1) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            this.setParticipate(true);
        } else {
            this.setParticipate(false);
            LOG.debug((Object)"Opening single Hibernate session in HibernatePersistenceContextInterceptor");
            Session session = this.getSession();
            GrailsHibernateUtil.enableDynamicFilterEnablerIfPresent(this.sessionFactory, session);
            session.setFlushMode(FlushMode.AUTO);
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        }
    }

    private Session getSession() {
        return this.getSession(true);
    }

    private Session getSession(boolean allowCreate) {
        return SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)allowCreate);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private int incNestingCount() {
        int value = this.nestingCount.get() + 1;
        this.nestingCount.set(value);
        return value;
    }

    private int decNestingCount() {
        int value = this.nestingCount.get() - 1;
        if (value < 0) {
            value = 0;
        }
        this.nestingCount.set(value);
        return value;
    }

    private void setParticipate(boolean flag) {
        this.participate.set(flag);
    }

    private boolean getParticipate() {
        return this.participate.get();
    }
}

