/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import groovy.lang.GroovySystem;
import groovy.util.ConfigObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.events.SaveOrUpdateEventListener;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventListener;
import org.codehaus.groovy.grails.orm.hibernate.support.SoftKey;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsConfigurationAware;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.hibernate.HibernateException;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ClosureEventTriggeringInterceptor
extends SaveOrUpdateEventListener
implements ApplicationContextAware,
GrailsConfigurationAware,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;
    public static final Collection<String> IGNORED = new HashSet<String>(Arrays.asList("version", "id"));
    public static final String ONLOAD_EVENT = "onLoad";
    public static final String ONLOAD_SAVE = "onSave";
    public static final String BEFORE_LOAD_EVENT = "beforeLoad";
    public static final String BEFORE_INSERT_EVENT = "beforeInsert";
    public static final String AFTER_INSERT_EVENT = "afterInsert";
    public static final String BEFORE_UPDATE_EVENT = "beforeUpdate";
    public static final String AFTER_UPDATE_EVENT = "afterUpdate";
    public static final String BEFORE_DELETE_EVENT = "beforeDelete";
    public static final String AFTER_DELETE_EVENT = "afterDelete";
    public static final String AFTER_LOAD_EVENT = "afterLoad";
    private transient ConcurrentMap<SoftKey<Class<?>>, ClosureEventListener> eventListeners = new ConcurrentHashMap();
    private transient ConcurrentMap<SoftKey<Class<?>>, Boolean> cachedShouldTrigger = new ConcurrentHashMap();
    boolean failOnError = false;
    List failOnErrorPackages = Collections.EMPTY_LIST;
    private transient ApplicationContext applicationContext;

    public void setConfiguration(ConfigObject co) {
        Object failOnErrorConfig = co.flatten().get("grails.gorm.failOnError");
        if (failOnErrorConfig instanceof List) {
            this.failOnError = true;
            this.failOnErrorPackages = (List)failOnErrorConfig;
        } else {
            this.failOnError = DefaultTypeTransformation.castToBoolean(failOnErrorConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClosureEventListener findEventListener(Object entity) {
        Boolean shouldTrigger;
        if (entity == null) {
            return null;
        }
        Class<?> clazz = entity.getClass();
        SoftKey key = new SoftKey(clazz);
        ClosureEventListener eventListener = (ClosureEventListener)this.eventListeners.get(key);
        if (eventListener == null && ((shouldTrigger = (Boolean)this.cachedShouldTrigger.get(key)) == null || shouldTrigger.booleanValue())) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                eventListener = (ClosureEventListener)this.eventListeners.get(key);
                if (eventListener == null) {
                    ClosureEventListener previous;
                    shouldTrigger = entity != null && GroovySystem.getMetaClassRegistry().getMetaClass(entity.getClass()) != null && (DomainClassArtefactHandler.isDomainClass(clazz) || AnnotationDomainClassArtefactHandler.isJPADomainClass(clazz));
                    if (shouldTrigger.booleanValue() && (previous = this.eventListeners.putIfAbsent(key, eventListener = new ClosureEventListener(clazz, this.failOnError, this.failOnErrorPackages))) != null) {
                        eventListener = previous;
                    }
                    this.cachedShouldTrigger.put(key, shouldTrigger);
                }
            }
        }
        return eventListener;
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        Object entity = event.getObject();
        ClosureEventListener eventListener = this.findEventListener(entity);
        if (eventListener != null) {
            eventListener.onSaveOrUpdate(event);
        }
        super.onSaveOrUpdate(event);
    }

    public void onPreLoad(PreLoadEvent event) {
        Object entity = event.getEntity();
        GrailsHibernateUtil.ensureCorrectGroovyMetaClass(entity, entity.getClass());
        ClosureEventListener eventListener = this.findEventListener(entity);
        if (eventListener != null) {
            eventListener.onPreLoad(event);
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        Object entity = event.getEntity();
        ClosureEventListener eventListener = this.findEventListener(entity);
        if (eventListener != null) {
            if (this.applicationContext != null && this.applicationContext.getAutowireCapableBeanFactory() != null) {
                this.applicationContext.getAutowireCapableBeanFactory().autowireBeanProperties(entity, 1, false);
            }
            eventListener.onPostLoad(event);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostInsert(event);
        }
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        boolean evict = false;
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            evict = eventListener.onPreUpdate(event);
        }
        return evict;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostUpdate(event);
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            eventListener.onPostDelete(event);
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        ClosureEventListener eventListener = this.findEventListener(event.getEntity());
        if (eventListener != null) {
            return eventListener.onPreDelete(event);
        }
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.failOnError);
        out.writeObject(this.failOnErrorPackages);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.failOnError = in.readBoolean();
        this.failOnErrorPackages = (List)in.readObject();
        this.eventListeners = new ConcurrentHashMap();
        this.cachedShouldTrigger = new ConcurrentHashMap();
    }
}

