/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.validation.ValidationException;
import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Errors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureEventListener
implements SaveOrUpdateEventListener,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClosureEventListener.class);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    EventTriggerCaller saveOrUpdateCaller;
    EventTriggerCaller beforeInsertCaller;
    EventTriggerCaller preLoadEventCaller;
    EventTriggerCaller postLoadEventListener;
    EventTriggerCaller postInsertEventListener;
    EventTriggerCaller postUpdateEventListener;
    EventTriggerCaller postDeleteEventListener;
    EventTriggerCaller preDeleteEventListener;
    EventTriggerCaller preUpdateEventListener;
    boolean shouldTimestamp = false;
    MetaProperty dateCreatedProperty;
    MetaProperty lastUpdatedProperty;
    MetaClass domainMetaClass;
    boolean failOnErrorEnabled = false;
    MetaProperty errorsProperty;
    Map validateParams;
    MetaMethod validateMethod;

    public ClosureEventListener(Class<?> domainClazz, boolean failOnError, List failOnErrorPackages) {
        this.initialize(domainClazz, failOnError, failOnErrorPackages);
    }

    private void initialize(Class<?> domainClazz, boolean failOnError, List failOnErrorPackages) {
        this.domainMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(domainClazz);
        this.dateCreatedProperty = this.domainMetaClass.getMetaProperty("dateCreated");
        this.lastUpdatedProperty = this.domainMetaClass.getMetaProperty("lastUpdated");
        if (this.dateCreatedProperty != null || this.lastUpdatedProperty != null) {
            Mapping m = GrailsDomainBinder.getMapping(domainClazz);
            this.shouldTimestamp = m == null || m.isAutoTimestamp();
        }
        this.saveOrUpdateCaller = this.buildCaller(domainClazz, "onSave");
        this.beforeInsertCaller = this.buildCaller(domainClazz, "beforeInsert");
        this.preLoadEventCaller = this.buildCaller(domainClazz, "onLoad");
        if (this.preLoadEventCaller == null) {
            this.preLoadEventCaller = this.buildCaller(domainClazz, "beforeLoad");
        }
        this.postLoadEventListener = this.buildCaller(domainClazz, "afterLoad");
        this.postInsertEventListener = this.buildCaller(domainClazz, "afterInsert");
        this.postUpdateEventListener = this.buildCaller(domainClazz, "afterUpdate");
        this.postDeleteEventListener = this.buildCaller(domainClazz, "afterDelete");
        this.preDeleteEventListener = this.buildCaller(domainClazz, "beforeDelete");
        this.preUpdateEventListener = this.buildCaller(domainClazz, "beforeUpdate");
        this.failOnErrorEnabled = failOnErrorPackages.size() > 0 ? GrailsClassUtils.isClassBelowPackage(domainClazz, (List)failOnErrorPackages) : failOnError;
        this.validateParams = new HashMap();
        this.validateParams.put("deepValidate", Boolean.FALSE);
        this.errorsProperty = this.domainMetaClass.getMetaProperty("errors");
        this.validateMethod = this.domainMetaClass.getMetaMethod("validate", new Object[]{Map.class});
    }

    private EventTriggerCaller buildCaller(Class<?> domainClazz, String event) {
        Method method = ReflectionUtils.findMethod(domainClazz, (String)event);
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
            return new MethodCaller(method);
        }
        Field field = ReflectionUtils.findField(domainClazz, (String)event);
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            return new FieldClosureCaller(field);
        }
        MetaMethod metaMethod = this.domainMetaClass.getMetaMethod(event, EMPTY_OBJECT_ARRAY);
        if (metaMethod != null) {
            return new MetaMethodCaller(metaMethod);
        }
        MetaProperty metaProperty = this.domainMetaClass.getMetaProperty(event);
        if (metaProperty != null) {
            return new MetaPropertyClosureCaller(metaProperty);
        }
        return null;
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
        boolean newEntity;
        Object entity = event.getObject();
        boolean bl = newEntity = !event.getSession().contains(entity);
        if (newEntity) {
            if (this.beforeInsertCaller != null) {
                EntityEntry entry;
                this.beforeInsertCaller.call(entity);
                if (event.getSession().contains(entity) && (entry = event.getEntry()) != null) {
                    Object[] state = entry.getLoadedState();
                    this.synchronizePersisterState(entity, entry.getPersister(), state);
                }
            }
            if (this.shouldTimestamp) {
                Object now;
                long time = System.currentTimeMillis();
                if (this.dateCreatedProperty != null && newEntity) {
                    now = DefaultGroovyMethods.newInstance((Class)this.dateCreatedProperty.getType(), (Object[])new Object[]{time});
                    this.dateCreatedProperty.setProperty(entity, now);
                }
                if (this.lastUpdatedProperty != null) {
                    now = DefaultGroovyMethods.newInstance((Class)this.lastUpdatedProperty.getType(), (Object[])new Object[]{time});
                    this.lastUpdatedProperty.setProperty(entity, now);
                }
            }
        }
    }

    private void synchronizePersisterState(Object entity, EntityPersister persister, Object[] state) {
        String[] propertyNames = persister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object value;
            String p = propertyNames[i];
            MetaProperty metaProperty = this.domainMetaClass.getMetaProperty(p);
            if (ClosureEventTriggeringInterceptor.IGNORED.contains(p) || metaProperty == null) continue;
            state[i] = value = metaProperty.getProperty(entity);
            persister.setPropertyValue(entity, i, value, EntityMode.POJO);
        }
    }

    public void onPreLoad(PreLoadEvent event) {
        if (this.preLoadEventCaller != null) {
            this.preLoadEventCaller.call(event.getEntity());
        }
    }

    public void onPostLoad(PostLoadEvent event) {
        if (this.postLoadEventListener != null) {
            this.postLoadEventListener.call(event.getEntity());
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        if (this.postInsertEventListener != null) {
            this.postInsertEventListener.call(event.getEntity());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        if (this.postUpdateEventListener != null) {
            this.postUpdateEventListener.call(event.getEntity());
        }
    }

    public void onPostDelete(PostDeleteEvent event) {
        if (this.postDeleteEventListener != null) {
            this.postDeleteEventListener.call(event.getEntity());
        }
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        if (this.preDeleteEventListener != null) {
            return this.preDeleteEventListener.call(event.getEntity());
        }
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        Object entity = event.getEntity();
        boolean evict = false;
        if (this.preUpdateEventListener != null) {
            evict = this.preUpdateEventListener.call(entity);
            this.synchronizePersisterState(entity, event.getPersister(), event.getState());
        }
        if (this.lastUpdatedProperty != null && this.shouldTimestamp) {
            Object now;
            event.getState()[ArrayUtils.indexOf((Object[])event.getPersister().getPropertyNames(), (Object)"lastUpdated")] = now = DefaultGroovyMethods.newInstance((Class)this.lastUpdatedProperty.getType(), (Object[])new Object[]{System.currentTimeMillis()});
            this.lastUpdatedProperty.setProperty(entity, now);
        }
        if (!AbstractSavePersistentMethod.isAutoValidationDisabled(entity) && !DefaultTypeTransformation.castToBoolean((Object)this.validateMethod.invoke(entity, new Object[]{this.validateParams}))) {
            evict = true;
            if (this.failOnErrorEnabled) {
                Errors errors = (Errors)this.errorsProperty.getProperty(entity);
                throw new ValidationException("Validation error whilst flushing entity [" + entity.getClass().getName() + "]", errors);
            }
        }
        return evict;
    }

    private static class MetaPropertyClosureCaller
    extends ClosureCaller {
        MetaProperty metaProperty;

        MetaPropertyClosureCaller(MetaProperty metaProperty) {
            this.metaProperty = metaProperty;
            if (Modifier.isStatic(metaProperty.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        public boolean call(Object entity) {
            Object fieldval = this.metaProperty.getProperty(entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval));
            }
            log.error((Object)("Field " + this.metaProperty + " is not Closure."));
            return false;
        }
    }

    private static class FieldClosureCaller
    extends ClosureCaller {
        Field field;

        FieldClosureCaller(Field field) {
            this.field = field;
            if (Modifier.isStatic(field.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        public boolean call(Object entity) {
            Object fieldval = ReflectionUtils.getField((Field)this.field, (Object)entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval));
            }
            log.error((Object)("Field " + this.field + " is not Closure or method."));
            return false;
        }
    }

    private static abstract class ClosureCaller
    extends EventTriggerCaller {
        boolean cloneFirst = false;

        private ClosureCaller() {
        }

        Object callClosure(Object entity, Closure callable) {
            if (this.cloneFirst) {
                callable = (Closure)callable.clone();
            }
            callable.setResolveStrategy(1);
            callable.setDelegate(entity);
            Object retval = callable.call();
            return retval;
        }
    }

    private static class MetaMethodCaller
    extends EventTriggerCaller {
        MetaMethod method;

        MetaMethodCaller(MetaMethod method) {
            this.method = method;
        }

        public boolean call(Object entity) {
            Object retval = this.method.invoke(entity, EMPTY_OBJECT_ARRAY);
            return this.resolveReturnValue(retval);
        }
    }

    private static class MethodCaller
    extends EventTriggerCaller {
        Method method;

        MethodCaller(Method method) {
            this.method = method;
        }

        public boolean call(Object entity) {
            Object retval = ReflectionUtils.invokeMethod((Method)this.method, (Object)entity);
            return this.resolveReturnValue(retval);
        }
    }

    private static abstract class EventTriggerCaller {
        EventTriggerCaller() {
        }

        public abstract boolean call(Object var1);

        boolean resolveReturnValue(Object retval) {
            if (retval instanceof Boolean) {
                return (Boolean)retval == false;
            }
            return false;
        }
    }
}

