/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.List;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RecursiveAction
extends ForkJoinTask<Void> {
    protected abstract void compute();

    public static void forkJoin(RecursiveAction t1, RecursiveAction t2) {
        ((ForkJoinWorkerThread)Thread.currentThread()).doForkJoin(t1, t2);
    }

    public static void forkJoin(RecursiveAction[] tasks) {
        RecursiveAction t;
        int i;
        int last = tasks.length - 1;
        Throwable ex = null;
        for (i = last; i >= 0; --i) {
            t = tasks[i];
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (ex != null) {
                t.cancel();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            ex = t.exec();
        }
        for (i = 1; i <= last; ++i) {
            t = tasks[i];
            if (t == null) continue;
            boolean pop = ForkJoinWorkerThread.removeIfNextLocalTask(t);
            if (ex != null) {
                t.cancel();
                continue;
            }
            ex = !pop ? t.quietlyJoin() : t.exec();
        }
        if (ex != null) {
            RecursiveAction.rethrowException(ex);
        }
    }

    public static void forkJoin(List<? extends RecursiveAction> tasks) {
        RecursiveAction t;
        int i;
        int last = tasks.size() - 1;
        Throwable ex = null;
        for (i = last; i >= 0; --i) {
            t = tasks.get(i);
            if (t == null) {
                if (ex != null) continue;
                ex = new NullPointerException();
                continue;
            }
            if (i != 0) {
                t.fork();
                continue;
            }
            if (ex != null) {
                t.cancel();
                continue;
            }
            ex = t.exec();
        }
        for (i = 1; i <= last; ++i) {
            t = tasks.get(i);
            if (t == null) continue;
            boolean pop = ForkJoinWorkerThread.removeIfNextLocalTask(t);
            if (ex != null) {
                t.cancel();
                continue;
            }
            ex = !pop ? t.quietlyJoin() : t.exec();
        }
        if (ex != null) {
            RecursiveAction.rethrowException(ex);
        }
    }

    @Override
    public final Void rawResult() {
        return null;
    }

    @Override
    public final Void forkJoin() {
        try {
            if (this.exception == null) {
                this.compute();
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
        }
        Throwable ex = this.setDone();
        if (ex != null) {
            RecursiveAction.rethrowException(ex);
        }
        return null;
    }

    @Override
    public final Throwable exec() {
        try {
            if (this.exception == null) {
                this.compute();
            }
        }
        catch (Throwable rex) {
            return this.setDoneExceptionally(rex);
        }
        return this.setDone();
    }

    public final void finish() {
        this.setDone();
    }

    @Override
    public final void finish(Void result) {
        this.setDone();
    }

    @Override
    public final void finishExceptionally(Throwable ex) {
        this.setDoneExceptionally(ex);
    }
}

