/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import grails.util.GrailsNameUtils;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.Constraint;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public abstract class AbstractConstraint
implements Constraint {
    protected String constraintPropertyName;
    protected Class<?> constraintOwningClass;
    protected Object constraintParameter;
    protected String classShortName;
    protected MessageSource messageSource;

    public void setMessageSource(MessageSource source) {
        this.messageSource = source;
    }

    public String getPropertyName() {
        return this.constraintPropertyName;
    }

    public void setOwningClass(Class constraintOwningClass) {
        this.constraintOwningClass = constraintOwningClass;
        this.classShortName = GrailsNameUtils.getPropertyNameRepresentation((Class)constraintOwningClass);
    }

    public void setPropertyName(String constraintPropertyName) {
        this.constraintPropertyName = constraintPropertyName;
    }

    public void setParameter(Object constraintParameter) {
        this.constraintParameter = constraintParameter;
    }

    protected void checkState() {
        Assert.hasLength((String)this.constraintPropertyName, (String)"Property 'propertyName' must be set on the constraint");
        Assert.notNull(this.constraintOwningClass, (String)"Property 'owningClass' must be set on the constraint");
        Assert.notNull((Object)this.constraintParameter, (String)"Property 'constraintParameter' must be set on the constraint");
    }

    public void validate(Object target, Object propertyValue, Errors errors) {
        this.checkState();
        if (propertyValue == null && this.skipNullValues()) {
            return;
        }
        if (this.skipBlankValues() && propertyValue instanceof String && StringUtils.isBlank((String)((String)propertyValue))) {
            return;
        }
        this.processValidate(target, propertyValue, errors);
    }

    protected boolean skipNullValues() {
        return true;
    }

    protected boolean skipBlankValues() {
        return true;
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, Object[] args) {
        this.rejectValue(target, errors, defaultMessageCode, new String[0], args);
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, String code, Object[] args) {
        this.rejectValue(target, errors, defaultMessageCode, new String[]{code}, args);
    }

    public void rejectValue(Object target, Errors errors, String defaultMessageCode, String[] codes, Object[] args) {
        this.rejectValueWithDefaultMessage(target, errors, this.getDefaultMessage(defaultMessageCode), codes, args);
    }

    public void rejectValueWithDefaultMessage(Object target, Errors errors, String defaultMessage, String[] codes, Object[] args) {
        BindingResult result = (BindingResult)errors;
        LinkedHashSet<String> newCodes = new LinkedHashSet<String>();
        if (args.length > 1 && this.messageSource != null && args[0] instanceof String && args[1] instanceof Class) {
            Locale locale = LocaleContextHolder.getLocale();
            Class constrainedClass = (Class)args[1];
            String fullClassName = constrainedClass.getName();
            String classNameCode = fullClassName + ".label";
            String resolvedClassName = this.messageSource.getMessage(classNameCode, null, fullClassName, locale);
            String classAsPropertyName = GrailsNameUtils.getPropertyName((Class)constrainedClass);
            if (resolvedClassName.equals(fullClassName)) {
                classNameCode = classAsPropertyName + ".label";
                resolvedClassName = this.messageSource.getMessage(classNameCode, null, fullClassName, locale);
            }
            if (!resolvedClassName.equals(fullClassName)) {
                args[1] = resolvedClassName;
            }
            String propertyName = (String)args[0];
            String propertyNameCode = fullClassName + '.' + propertyName + ".label";
            String resolvedPropertyName = this.messageSource.getMessage(propertyNameCode, null, propertyName, locale);
            if (resolvedPropertyName.equals(propertyName)) {
                propertyNameCode = classAsPropertyName + '.' + propertyName + ".label";
                resolvedPropertyName = this.messageSource.getMessage(propertyNameCode, null, propertyName, locale);
            }
            if (!resolvedPropertyName.equals(propertyName)) {
                args[0] = resolvedPropertyName;
            }
        }
        newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.constraintOwningClass.getName() + '.' + this.constraintPropertyName + '.' + this.getName() + ".error", this.constraintPropertyName)));
        newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.classShortName + '.' + this.constraintPropertyName + '.' + this.getName() + ".error", this.constraintPropertyName)));
        for (String code : codes) {
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.constraintOwningClass.getName() + '.' + this.constraintPropertyName + '.' + code, this.constraintPropertyName)));
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(this.classShortName + '.' + this.constraintPropertyName + '.' + code, this.constraintPropertyName)));
            newCodes.addAll(Arrays.asList(result.resolveMessageCodes(code, this.constraintPropertyName)));
        }
        FieldError error = new FieldError(errors.getObjectName(), errors.getNestedPath() + this.constraintPropertyName, this.getPropertyValue(errors, target), false, newCodes.toArray(new String[newCodes.size()]), args, defaultMessage);
        ((BindingResult)errors).addError((ObjectError)error);
    }

    private Object getPropertyValue(Errors errors, Object target) {
        try {
            return errors.getFieldValue(this.constraintPropertyName);
        }
        catch (Exception nre) {
            int i = this.constraintPropertyName.lastIndexOf(".");
            String propertyName = i > -1 ? this.constraintPropertyName.substring(i, this.constraintPropertyName.length()) : this.constraintPropertyName;
            return new BeanWrapperImpl(target).getPropertyValue(propertyName);
        }
    }

    public void rejectValue(Object target, Errors errors, String code, String defaultMessage) {
        this.rejectValueWithDefaultMessage(target, errors, defaultMessage, new String[]{code}, null);
    }

    public void rejectValue(Object target, Errors errors, String code, Object[] args, String defaultMessage) {
        this.rejectValueWithDefaultMessage(target, errors, defaultMessage, new String[]{code}, args);
    }

    protected String getDefaultMessage(String code) {
        try {
            if (this.messageSource != null) {
                return this.messageSource.getMessage(code, null, LocaleContextHolder.getLocale());
            }
            return ConstrainedProperty.DEFAULT_MESSAGES.get(code);
        }
        catch (Exception e) {
            return ConstrainedProperty.DEFAULT_MESSAGES.get(code);
        }
    }

    protected abstract void processValidate(Object var1, Object var2, Errors var3);

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.constraintParameter).toString();
    }
}

