/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.util.PluginBuildSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.metadata.GrailsPlugin;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GlobalPluginAwareEntityASTTransformation
implements ASTTransformation {
    private boolean disableTransformation = Boolean.getBoolean("disable.grails.plugin.transform");

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        if (this.disableTransformation) {
            return;
        }
        ASTNode astNode = astNodes[0];
        if (!(astNode instanceof ModuleNode)) {
            return;
        }
        ModuleNode moduleNode = (ModuleNode)astNode;
        List classes = moduleNode.getClasses();
        if (classes.isEmpty()) {
            return;
        }
        ClassNode classNode = (ClassNode)classes.get(0);
        if (classNode.isAnnotationDefinition()) {
            return;
        }
        File sourcePath = new File(sourceUnit.getName());
        try {
            String absolutePath = sourcePath.getCanonicalPath();
            PluginBuildSettings pluginBuildSettings = GrailsPluginUtils.getPluginBuildSettings();
            if (pluginBuildSettings == null) {
                return;
            }
            GrailsPluginInfo info = pluginBuildSettings.getPluginInfoForSource(absolutePath);
            if (info == null) {
                return;
            }
            ClassNode annotation = new ClassNode(GrailsPlugin.class);
            List list = classNode.getAnnotations(annotation);
            if (!list.isEmpty()) {
                return;
            }
            AnnotationNode annotationNode = new AnnotationNode(annotation);
            annotationNode.addMember("name", (Expression)new ConstantExpression((Object)info.getName()));
            annotationNode.addMember("version", (Expression)new ConstantExpression((Object)info.getVersion()));
            annotationNode.setRuntimeRetention(true);
            annotationNode.setClassRetention(true);
            classNode.addAnnotation(annotationNode);
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

