/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class GrailsResourceUtils {
    public static final String WEB_INF = "/WEB-INF";
    public static final String GRAILS_APP_DIR = "grails-app";
    public static final String WEB_APP_DIR = "web-app";
    public static final String VIEWS_DIR_PATH = "grails-app/views/";
    public static Pattern DOMAIN_PATH_PATTERN = Pattern.compile(".+/grails-app/domain/(.+)\\.groovy");
    public static Pattern RESOURCE_PATH_PATTERN = Pattern.compile(".+?/grails-app/(.+?)/(.+?\\.groovy)");
    public static Pattern SPRING_SCRIPTS_PATH_PATTERN = Pattern.compile(".+?/grails-app/conf/spring/(.+?\\.groovy)");
    public static Pattern[] COMPILER_ROOT_PATTERNS = new Pattern[]{SPRING_SCRIPTS_PATH_PATTERN, RESOURCE_PATH_PATTERN};
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIRST_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SECOND_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_THIRD_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FOURTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_FIFTH_MATCH;
    public static final Pattern GRAILS_RESOURCE_PATTERN_SIXTH_MATCH;
    public static final Pattern[] patterns;
    private static final Log LOG;
    private static final Pattern PLUGIN_PATTERN;
    private static final Pattern PLUGIN_RESOURCE_PATTERN;

    private static String createGrailsResourcePattern(String separator, String base) {
        return ".+" + separator + base + separator + "(.+)\\.groovy";
    }

    public static boolean isDomainClass(URL url) {
        if (url == null) {
            return false;
        }
        return DOMAIN_PATH_PATTERN.matcher(url.getFile()).find();
    }

    public static String getClassName(Resource resource) {
        try {
            return GrailsResourceUtils.getClassName(resource.getFile().getAbsolutePath());
        }
        catch (IOException e) {
            throw new GrailsConfigurationException("I/O error reading class name from resource [" + resource + "]: " + e.getMessage(), e);
        }
    }

    public static String getClassName(String path) {
        for (int i = 0; i < patterns.length; ++i) {
            Matcher m = patterns[i].matcher(path);
            if (!m.find()) continue;
            return m.group(1).replaceAll("[/\\\\]", ".");
        }
        return null;
    }

    public static boolean isGrailsPath(String path) {
        for (int i = 0; i < patterns.length; ++i) {
            Matcher m = patterns[i].matcher(path);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean isGrailsResource(Resource r) {
        try {
            return GrailsResourceUtils.isGrailsPath(r.getURL().getFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Resource getViewsDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            Resource appDir = GrailsResourceUtils.getAppDir(resource);
            return new UrlResource(appDir.getURL().toString() + "/views");
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving views dir from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static Resource getAppDir(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String url = resource.getURL().toString();
            int i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                url = url.substring(0, i + 10);
                return new UrlResource(url);
            }
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving app dir from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public static String getRelativeInsideWebInf(Resource resource) {
        if (resource == null) {
            return null;
        }
        try {
            String url = resource.getURL().toString();
            int i = url.indexOf(WEB_INF);
            if (i > -1) {
                return url.substring(i);
            }
            Matcher m = PLUGIN_PATTERN.matcher(url);
            if (m.find()) {
                return WEB_INF + m.group(1);
            }
            i = url.lastIndexOf(GRAILS_APP_DIR);
            if (i > -1) {
                return "/WEB-INF/" + url.substring(i);
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving relative path within WEB-INF from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public static String getStaticResourcePathForResource(Resource resource, String contextPath) {
        String url;
        if (contextPath == null) {
            contextPath = "";
        }
        if (resource == null) {
            return contextPath;
        }
        try {
            url = resource.getURL().toString();
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Error reading URL whilst resolving static resource path from [" + resource + "]: " + e.getMessage()), (Throwable)e);
            }
            return contextPath;
        }
        Matcher m = PLUGIN_RESOURCE_PATTERN.matcher(url);
        if (m.find()) {
            return (contextPath.length() > 0 ? contextPath + "/" : "") + m.group(1);
        }
        return contextPath;
    }

    public static String getPathFromRoot(String path) {
        for (int i = 0; i < COMPILER_ROOT_PATTERNS.length; ++i) {
            Matcher m = COMPILER_ROOT_PATTERNS[i].matcher(path);
            if (!m.find()) continue;
            return m.group(m.groupCount());
        }
        return null;
    }

    static {
        String fs = File.separator;
        if (fs.equals("\\")) {
            fs = "\\\\";
        }
        GRAILS_RESOURCE_PATTERN_FIRST_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_THIRD_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "\\w+"));
        GRAILS_RESOURCE_PATTERN_FIFTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        fs = "/";
        GRAILS_RESOURCE_PATTERN_SECOND_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "conf" + fs + "spring"));
        GRAILS_RESOURCE_PATTERN_FOURTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, GRAILS_APP_DIR + fs + "\\w+"));
        GRAILS_RESOURCE_PATTERN_SIXTH_MATCH = Pattern.compile(GrailsResourceUtils.createGrailsResourcePattern(fs, "grails-tests"));
        patterns = new Pattern[]{GRAILS_RESOURCE_PATTERN_FIRST_MATCH, GRAILS_RESOURCE_PATTERN_SECOND_MATCH, GRAILS_RESOURCE_PATTERN_THIRD_MATCH, GRAILS_RESOURCE_PATTERN_FOURTH_MATCH, GRAILS_RESOURCE_PATTERN_FIFTH_MATCH, GRAILS_RESOURCE_PATTERN_SIXTH_MATCH};
        LOG = LogFactory.getLog(GrailsResourceUtils.class);
        PLUGIN_PATTERN = Pattern.compile(".+?(/plugins/.+?/grails-app/.+)");
        PLUGIN_RESOURCE_PATTERN = Pattern.compile(".+?/(plugins/.+?)/grails-app/.+");
    }
}

