/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.Script;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.exceptions.GrailsConfigurationException;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.PropertyConfig;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.PluginManagerHolder;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstrainedPropertyBuilder;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrailsDomainConfigurationUtil {
    public static final String PROPERTY_NAME = "constraints";
    private static final String CONSTRAINTS_GROOVY = "Constraints.groovy";
    private static Log LOG = LogFactory.getLog(GrailsDomainConfigurationUtil.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<String> BASIC_TYPES;

    public static Serializable getAssociationIdentifier(Object target, String propertyName, GrailsDomainClass referencedDomainClass) {
        String getterName = GrailsClassUtils.getGetterName(propertyName);
        try {
            Method m = target.getClass().getDeclaredMethod(getterName, EMPTY_CLASS_ARRAY);
            Object value = m.invoke(target, new Object[0]);
            if (value != null && referencedDomainClass != null) {
                String identifierGetter = GrailsClassUtils.getGetterName(referencedDomainClass.getIdentifier().getName());
                m = value.getClass().getDeclaredMethod(identifierGetter, EMPTY_CLASS_ARRAY);
                return (Serializable)m.invoke(value, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return null;
    }

    public static void configureDomainClassRelationships(GrailsClass[] domainClasses, Map<?, ?> domainMap) {
        GrailsDomainClassProperty[] props;
        GrailsDomainClass domainClass;
        for (GrailsClass grailsClass : domainClasses) {
            domainClass = (GrailsDomainClass)grailsClass;
            if (!domainClass.isRoot()) {
                GrailsDomainClass gdc;
                Class superClass = grailsClass.getClazz().getSuperclass();
                while (!superClass.equals(Object.class) && !superClass.equals(GroovyObject.class) && (gdc = (GrailsDomainClass)domainMap.get(superClass.getName())) != null && gdc.getSubClasses() != null) {
                    gdc.getSubClasses().add((GrailsDomainClass)grailsClass);
                    superClass = superClass.getSuperclass();
                }
            }
            for (GrailsDomainClassProperty prop : props = domainClass.getPersistentProperties()) {
                if (prop == null || !prop.isAssociation()) continue;
                GrailsDomainClass referencedGrailsDomainClass = (GrailsDomainClass)domainMap.get(prop.getReferencedPropertyType().getName());
                prop.setReferencedDomainClass(referencedGrailsDomainClass);
            }
        }
        for (GrailsClass domainClass1 : domainClasses) {
            domainClass = (GrailsDomainClass)domainClass1;
            block6: for (GrailsDomainClassProperty prop : props = domainClass.getPersistentProperties()) {
                GrailsDomainClassProperty[] referencedProperties;
                GrailsDomainClass referenced;
                if (prop == null || !prop.isAssociation() || (referenced = prop.getReferencedDomainClass()) == null) continue;
                boolean isOwnedBy = referenced.isOwningClass(domainClass.getClazz());
                prop.setOwningSide(isOwnedBy);
                String refPropertyName = null;
                try {
                    refPropertyName = prop.getReferencedPropertyName();
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (!StringUtils.isBlank((String)refPropertyName)) {
                    GrailsDomainClassProperty otherSide = referenced.getPropertyByName(refPropertyName);
                    prop.setOtherSide(otherSide);
                    otherSide.setOtherSide(prop);
                    continue;
                }
                for (GrailsDomainClassProperty referencedProp : referencedProperties = referenced.getPersistentProperties()) {
                    if (prop.equals(referencedProp) && prop.isBidirectional() || !GrailsDomainConfigurationUtil.isCandidateForOtherSide(domainClass, prop, referencedProp)) continue;
                    prop.setOtherSide(referencedProp);
                    continue block6;
                }
            }
        }
    }

    private static boolean isCandidateForOtherSide(GrailsDomainClass domainClass, GrailsDomainClassProperty prop, GrailsDomainClassProperty referencedProp) {
        if (prop.equals(referencedProp)) {
            return false;
        }
        if (prop.isOneToMany() && referencedProp.isOneToMany()) {
            return false;
        }
        Class referencedPropertyType = referencedProp.getReferencedPropertyType();
        if (referencedPropertyType == null || !referencedPropertyType.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        Map mappedBy = domainClass.getMappedBy();
        Object propertyMapping = mappedBy.get(prop.getName());
        boolean mappedToDifferentProperty = propertyMapping != null && !propertyMapping.equals(referencedProp.getName());
        mappedBy = referencedProp.getDomainClass().getMappedBy();
        propertyMapping = mappedBy.get(referencedProp.getName());
        boolean mappedFromDifferentProperty = propertyMapping != null && !propertyMapping.equals(prop.getName());
        return !mappedToDifferentProperty && !mappedFromDifferentProperty;
    }

    public static String getMappingFileName(String className) {
        return className.replaceAll("\\.", "/") + ".hbm.xml";
    }

    public static Map<?, ?> getAssociationMap(Class<?> domainClass) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(domainClass);
        Map associationMap = cpf.getPropertyValue("hasMany", Map.class);
        if (associationMap == null) {
            associationMap = Collections.EMPTY_MAP;
        }
        return associationMap;
    }

    public static Map<?, ?> getMappedByMap(Class<?> domainClass) {
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(domainClass);
        Map mappedByMap = cpf.getPropertyValue("mappedBy", Map.class);
        if (mappedByMap == null) {
            return Collections.EMPTY_MAP;
        }
        return mappedByMap;
    }

    public static boolean isBasicType(GrailsDomainClassProperty prop) {
        if (prop == null) {
            return false;
        }
        return GrailsDomainConfigurationUtil.isBasicType(prop.getType());
    }

    public static boolean isBasicType(Class<?> propType) {
        if (propType == null) {
            return false;
        }
        if (propType.isArray()) {
            return GrailsDomainConfigurationUtil.isBasicType(propType.getComponentType());
        }
        return BASIC_TYPES.contains(propType.getName());
    }

    public static boolean isNotConfigurational(PropertyDescriptor descriptor) {
        String name = descriptor.getName();
        return !name.equals("metaClass") && !name.equals("class") && !name.equals("transients") && !name.equals("relatesToMany") && !name.equals("hasMany") && !name.equals("evanescent") && !name.equals(PROPERTY_NAME) && !name.equals("mapWith") && !name.equals("mappedBy") && !name.equals("belongsTo");
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance, GrailsDomainClassProperty[] properties, Map<String, Object> defaultConstraints) {
        Class<?> theClass = instance.getClass();
        return GrailsDomainConfigurationUtil.evaluateConstraints(theClass, properties, defaultConstraints);
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties, Map<String, Object> defaultConstraints) {
        boolean javaEntity = theClass.isAnnotationPresent(Entity.class);
        LinkedList classChain = GrailsDomainConfigurationUtil.getSuperClassChain(theClass);
        ConstrainedPropertyBuilder delegate = new ConstrainedPropertyBuilder(theClass);
        for (Object aClassChain : classChain) {
            Class clazz = (Class)aClassChain;
            Closure c = (Closure)GrailsClassUtils.getStaticPropertyValue(clazz, PROPERTY_NAME);
            if (c == null) {
                c = GrailsDomainConfigurationUtil.getConstraintsFromScript(theClass);
            }
            if (c != null) {
                c.setDelegate((Object)delegate);
                c.call();
                continue;
            }
            LOG.debug((Object)("User-defined constraints not found on class [" + clazz + "], applying default constraints"));
        }
        Map<String, ConstrainedProperty> constrainedProperties = delegate.getConstrainedProperties();
        if (!(properties == null || constrainedProperties.isEmpty() && javaEntity)) {
            boolean hasHibernate = GrailsDomainConfigurationUtil.isHibernatePresent();
            for (GrailsDomainClassProperty p : properties) {
                PropertyConfig propertyConfig;
                PropertyConfig propertyConfig2 = propertyConfig = hasHibernate ? GrailsDomainBinder.getPropertyConfig((GrailsDomainClassProperty)p) : null;
                if (propertyConfig != null && propertyConfig.getFormula() != null) {
                    if (constrainedProperties.remove(p.getName()) == null) continue;
                    LOG.warn((Object)("Derived properties may not be constrained. Property [" + p.getName() + "] of domain class " + theClass.getName() + " will not be checked during validation."));
                    continue;
                }
                String propertyName = p.getName();
                ConstrainedProperty cp = constrainedProperties.get(propertyName);
                if (cp == null) {
                    cp = new ConstrainedProperty(p.getDomainClass().getClazz(), propertyName, p.getType());
                    cp.setOrder(constrainedProperties.size() + 1);
                    constrainedProperties.put(propertyName, cp);
                }
                GrailsDomainConfigurationUtil.applyDefaultConstraints(propertyName, p, cp, defaultConstraints, delegate.getSharedConstraint(propertyName), propertyConfig);
            }
        }
        return constrainedProperties;
    }

    private static boolean isHibernatePresent() {
        GrailsPluginManager pluginManager = PluginManagerHolder.getPluginManager();
        boolean hasHibernate = pluginManager != null && pluginManager.hasGrailsPlugin("hibernate") && ClassUtils.isPresent((String)"org.hibernate.mapping.Value", (ClassLoader)GrailsDomainConfigurationUtil.class.getClassLoader());
        return hasHibernate;
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance, GrailsDomainClassProperty[] properties) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(instance, properties, null);
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Object instance) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(instance, null, null);
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(theClass, null, null);
    }

    public static Map<String, ConstrainedProperty> evaluateConstraints(Class<?> theClass, GrailsDomainClassProperty[] properties) {
        return GrailsDomainConfigurationUtil.evaluateConstraints(theClass, properties, null);
    }

    private static void applyDefaultConstraints(String propertyName, GrailsDomainClassProperty p, ConstrainedProperty cp, Map<String, Object> defaultConstraints, String sharedConstraintReference, PropertyConfig propertyConfig) {
        if (defaultConstraints != null && !defaultConstraints.isEmpty()) {
            Object o;
            if (defaultConstraints.containsKey("*") && (o = defaultConstraints.get("*")) instanceof Map) {
                Map globalConstraints = (Map)o;
                GrailsDomainConfigurationUtil.applyMapOfConstraints(globalConstraints, propertyName, p, cp);
            }
            if (sharedConstraintReference != null) {
                o = defaultConstraints.get(sharedConstraintReference);
                if (o instanceof Map) {
                    GrailsDomainConfigurationUtil.applyMapOfConstraints((Map)o, propertyName, p, cp);
                } else {
                    throw new GrailsConfigurationException("Domain class property [" + p.getDomainClass().getFullName() + '.' + p.getName() + "] references shared constraint [" + sharedConstraintReference + ":" + o + "], which doesn't exist!");
                }
            }
        }
        if (GrailsDomainConfigurationUtil.canApplyNullableConstraint(propertyName, p, cp)) {
            if (propertyConfig != null && !propertyConfig.getInsertable()) {
                cp.applyConstraint("nullable", true);
            } else {
                cp.applyConstraint("nullable", Collection.class.isAssignableFrom(p.getType()) || Map.class.isAssignableFrom(p.getType()));
            }
        }
    }

    private static boolean canApplyNullableConstraint(String propertyName, GrailsDomainClassProperty property, ConstrainedProperty constrainedProperty) {
        if (property == null || property.getType() == null) {
            return false;
        }
        GrailsDomainClass domainClass = property.getDomainClass();
        if (!GroovyObject.class.isAssignableFrom(domainClass.getClazz())) {
            return false;
        }
        GrailsDomainClassProperty versionProperty = domainClass.getVersion();
        boolean isVersion = versionProperty != null && versionProperty.equals(property);
        return !constrainedProperty.hasAppliedConstraint("nullable") && GrailsDomainConfigurationUtil.isConstrainableProperty(property, propertyName) && !property.isIdentity() && !isVersion;
    }

    private static void applyMapOfConstraints(Map<String, Object> constraints, String propertyName, GrailsDomainClassProperty p, ConstrainedProperty cp) {
        for (Map.Entry<String, Object> entry : constraints.entrySet()) {
            String constraintName = entry.getKey();
            Object constrainingValue = entry.getValue();
            if (cp.hasAppliedConstraint(constraintName) || !cp.supportsContraint(constraintName)) continue;
            if ("nullable".equals(constraintName)) {
                if (!GrailsDomainConfigurationUtil.isConstrainableProperty(p, propertyName)) continue;
                cp.applyConstraint(constraintName, constrainingValue);
                continue;
            }
            cp.applyConstraint(constraintName, constrainingValue);
        }
    }

    private static boolean isConstrainableProperty(GrailsDomainClassProperty p, String propertyName) {
        return !propertyName.equals("dateCreated") && !propertyName.equals("lastUpdated") && (!p.isOneToOne() && !p.isManyToOne() || !p.isCircular());
    }

    public static LinkedList<?> getSuperClassChain(Class<?> theClass) {
        LinkedList classChain = new LinkedList();
        for (Class<?> clazz = theClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            classChain.addFirst(clazz);
        }
        return classChain;
    }

    private static Closure getConstraintsFromScript(Class<?> theClass) {
        String className = theClass.getName();
        String constraintsScript = className.replaceAll("\\.", "/") + CONSTRAINTS_GROOVY;
        InputStream stream = GrailsDomainConfigurationUtil.class.getClassLoader().getResourceAsStream(constraintsScript);
        if (stream != null) {
            GroovyClassLoader gcl = new GroovyClassLoader();
            try {
                Class scriptClass = gcl.parseClass(DefaultGroovyMethods.getText((InputStream)stream));
                Script script = (Script)scriptClass.newInstance();
                script.run();
                Binding binding = script.getBinding();
                if (binding.getVariables().containsKey(PROPERTY_NAME)) {
                    return (Closure)binding.getVariable(PROPERTY_NAME);
                }
                LOG.warn((Object)("Unable to evaluate constraints from [" + constraintsScript + "], constraints closure not found!"));
                return null;
            }
            catch (CompilationFailedException e) {
                LOG.error((Object)("Compilation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (InstantiationException e) {
                LOG.error((Object)("Instantiation error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)("Illegal access error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                LOG.error((Object)("IO error evaluating constraints for class [" + className + "]: " + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    static {
        HashSet<String> basics = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Long.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Byte.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Character.TYPE.getName(), Boolean.class.getName(), Long.class.getName(), Short.class.getName(), Integer.class.getName(), Byte.class.getName(), Float.class.getName(), Double.class.getName(), Character.class.getName(), String.class.getName(), java.util.Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Date.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Locale.class.getName(), Calendar.class.getName(), GregorianCalendar.class.getName(), Currency.class.getName(), TimeZone.class.getName(), Object.class.getName(), Class.class.getName(), byte[].class.getName(), Byte[].class.getName(), char[].class.getName(), Character[].class.getName(), Blob.class.getName(), Clob.class.getName(), Serializable.class.getName(), URI.class.getName(), URL.class.getName()));
        BASIC_TYPES = Collections.unmodifiableSet(basics);
    }
}

