/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsControllerClass;
import org.codehaus.groovy.grails.web.binding.GrailsDataBinder;
import org.codehaus.groovy.grails.web.servlet.DefaultGrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.FlashScope;
import org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsHttpSession;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterCreationListener;
import org.codehaus.groovy.grails.web.servlet.mvc.ParameterInitializationCallback;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;

public class GrailsWebRequest
extends DispatcherServletWebRequest
implements ParameterInitializationCallback {
    private GrailsApplicationAttributes attributes;
    private GrailsParameterMap params;
    private HttpServletResponse response;
    private GrailsHttpSession session;
    private boolean renderView = true;
    public static final String ID_PARAMETER = "id";
    private List<ParameterCreationListener> parameterCreationListeners = new ArrayList<ParameterCreationListener>();
    private UrlPathHelper urlHelper = new UrlPathHelper();

    public GrailsWebRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request);
        this.attributes = new DefaultGrailsApplicationAttributes(servletContext);
        this.response = response;
    }

    public Map getParameterMap() {
        if (this.params == null) {
            this.params = new GrailsParameterMap(this.getCurrentRequest());
        }
        return this.params;
    }

    public Writer getOut() {
        Writer out = this.attributes.getOut(this.getCurrentRequest());
        if (out == null) {
            try {
                return this.getCurrentResponse().getWriter();
            }
            catch (IOException e) {
                throw new ControllerExecutionException("Error retrieving response writer: " + e.getMessage(), e);
            }
        }
        return out;
    }

    public boolean isActive() {
        return super.isRequestActive();
    }

    public void setOut(Writer out) {
        this.attributes.setOut(this.getCurrentRequest(), out);
    }

    public ServletContext getServletContext() {
        return this.attributes.getServletContext();
    }

    public String getContextPath() {
        HttpServletRequest request = this.getCurrentRequest();
        String appUri = (String)request.getAttribute("org.codehaus.groovy.grails.APP_URI_ATTRIBUTE");
        if (appUri == null) {
            appUri = this.urlHelper.getContextPath(request);
        }
        return appUri;
    }

    public FlashScope getFlashScope() {
        return this.attributes.getFlashScope((ServletRequest)this.getRequest());
    }

    public HttpServletRequest getCurrentRequest() {
        return this.getRequest();
    }

    public HttpServletResponse getCurrentResponse() {
        return this.response;
    }

    public GrailsParameterMap getParams() {
        if (this.params == null) {
            this.params = new GrailsParameterMap(this.getCurrentRequest());
        }
        return this.params;
    }

    public void informParameterCreationListeners() {
        for (ParameterCreationListener parameterCreationListener : this.parameterCreationListeners) {
            parameterCreationListener.paramsCreated(this.getParams());
        }
    }

    public GrailsHttpSession getSession() {
        if (this.session == null) {
            this.session = new GrailsHttpSession(this.getCurrentRequest());
        }
        return this.session;
    }

    public GrailsApplicationAttributes getAttributes() {
        return this.attributes;
    }

    public void setActionName(String actionName) {
        this.getCurrentRequest().setAttribute("org.codehaus.groovy.grails.ACTION_NAME_ATTRIBUTE", (Object)actionName);
    }

    public void setControllerName(String controllerName) {
        this.getCurrentRequest().setAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE", (Object)controllerName);
    }

    public String getActionName() {
        return (String)this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.ACTION_NAME_ATTRIBUTE");
    }

    public String getControllerName() {
        return (String)this.getCurrentRequest().getAttribute("org.codehaus.groovy.grails.CONTROLLER_NAME_ATTRIBUTE");
    }

    public void setRenderView(boolean renderView) {
        this.renderView = renderView;
    }

    public boolean isRenderView() {
        return this.renderView;
    }

    public String getId() {
        Object id = this.getParams().get(ID_PARAMETER);
        return id != null ? id.toString() : null;
    }

    public boolean isFlowRequest() {
        GrailsApplication application = this.getAttributes().getGrailsApplication();
        GrailsControllerClass controllerClass = (GrailsControllerClass)application.getArtefactByLogicalPropertyName("Controller", this.getControllerName());
        if (controllerClass == null) {
            return false;
        }
        String actionName = this.getActionName();
        if (actionName == null) {
            actionName = controllerClass.getDefaultAction();
        }
        if (actionName == null) {
            return false;
        }
        return controllerClass != null && controllerClass.isFlowAction(actionName);
    }

    public void addParameterListener(ParameterCreationListener creationListener) {
        this.parameterCreationListeners.add(creationListener);
    }

    public ApplicationContext getApplicationContext() {
        return this.getAttributes().getApplicationContext();
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        HttpServletRequest servletRequest = this.getCurrentRequest();
        PropertyEditorRegistry registry = (PropertyEditorRegistry)servletRequest.getAttribute("org.codehaus.groovy.grails.PROPERTY_REGISTRY");
        if (registry == null) {
            registry = new PropertyEditorRegistrySupport();
            GrailsDataBinder.registerCustomEditors(registry, RequestContextUtils.getLocale((HttpServletRequest)servletRequest));
            servletRequest.setAttribute("org.codehaus.groovy.grails.PROPERTY_REGISTRY", (Object)registry);
        }
        return registry;
    }

    public static GrailsWebRequest lookup(HttpServletRequest request) {
        RequestAttributes requestAttributes;
        GrailsWebRequest webRequest = (GrailsWebRequest)request.getAttribute("org.codehaus.groovy.grails.WEB_REQUEST");
        if (webRequest == null && (requestAttributes = RequestContextHolder.getRequestAttributes()) instanceof GrailsWebRequest) {
            webRequest = (GrailsWebRequest)requestAttributes;
        }
        return webRequest;
    }

    public void setId(Object id) {
        this.getParams().put(ID_PARAMETER, id);
    }
}

