/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.servlet.mvc;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.plugins.support.BeanPostProcessorAdapter;
import org.codehaus.groovy.grails.web.plugins.support.WebMetaUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CommandObjectEnablingPostProcessor
extends BeanPostProcessorAdapter
implements ApplicationContextAware {
    private GrailsApplication grailsApplication;
    private Closure commandObjectBindingAction;
    private Collection processedControllerNames = new ConcurrentLinkedQueue();
    private ApplicationContext applicationContext;

    public CommandObjectEnablingPostProcessor(ApplicationContext applicationContext) {
        this.setApplicationContext(applicationContext);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (this.shouldPostProcessController(bean, beanName) && this.grailsApplication.getArtefact("Controller", bean.getClass().getName()) != null) {
            GroovyObject controller = (GroovyObject)bean;
            Map props = (Map)controller.getProperty("properties");
            for (String propName : props.keySet()) {
                Closure callable;
                Object value = props.get(propName);
                if (!(value instanceof Closure) || !WebMetaUtils.isCommandObjectAction(callable = (Closure)value)) continue;
                WebMetaUtils.prepareCommandObjectBindingAction(this.commandObjectBindingAction, callable, propName, controller, this.applicationContext);
            }
            this.processedControllerNames.add(beanName);
        }
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    private boolean shouldPostProcessController(Object bean, String beanName) {
        return beanName.endsWith("Controller") && !this.processedControllerNames.contains(beanName) && this.grailsApplication != null && bean != null && bean instanceof GroovyObject;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.grailsApplication = (GrailsApplication)applicationContext.getBean(GrailsApplication.class);
        this.commandObjectBindingAction = WebMetaUtils.createCommandObjectBindingAction(applicationContext);
        this.applicationContext = applicationContext;
    }
}

