/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.web.mapping;

import groovy.lang.Closure;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.ConfigurationHolder;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.web.mapping.AbstractUrlMapping;
import org.codehaus.groovy.grails.web.mapping.DefaultUrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.UrlMapping;
import org.codehaus.groovy.grails.web.mapping.UrlMappingData;
import org.codehaus.groovy.grails.web.mapping.UrlMappingInfo;
import org.codehaus.groovy.grails.web.mapping.exceptions.UrlMappingException;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.MapBindingResult;
import org.springframework.web.context.request.RequestContextHolder;

public class RegexUrlMapping
extends AbstractUrlMapping
implements UrlMapping {
    private Pattern[] patterns;
    private UrlMappingData urlData;
    private static final String WILDCARD = "*";
    private static final String CAPTURED_WILDCARD = "(*)";
    private static final String SLASH = "/";
    private static final char QUESTION_MARK = '?';
    private static final char AMPERSAND = '&';
    private static final String DOUBLE_WILDCARD = "**";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String CAPTURED_DOUBLE_WILDCARD = "(**)";
    private static final Log LOG = LogFactory.getLog(RegexUrlMapping.class);
    private static final Pattern DOUBLE_WILDCARD_PATTERN = Pattern.compile("\\(\\*\\*?\\)");

    public RegexUrlMapping(UrlMappingData data, Object controllerName, Object actionName, Object viewName, ConstrainedProperty[] constraints, ServletContext servletContext) {
        super(controllerName, actionName, viewName, constraints != null ? constraints : new ConstrainedProperty[]{}, servletContext);
        this.parse(data, constraints);
    }

    public RegexUrlMapping(UrlMappingData data, URI uri, ConstrainedProperty[] constraints, ServletContext servletContext) {
        super(uri, constraints, servletContext);
        this.parse(data, constraints);
    }

    private void parse(UrlMappingData data, ConstrainedProperty[] constraints) {
        Assert.notNull((Object)data, (String)"Argument [data] cannot be null");
        String[] urls = data.getLogicalUrls();
        this.urlData = data;
        this.patterns = new Pattern[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i];
            Pattern pattern = this.convertToRegex(url);
            if (pattern == null) {
                throw new IllegalStateException("Cannot use null pattern in regular expression mapping for url [" + data.getUrlPattern() + "]");
            }
            this.patterns[i] = pattern;
        }
        if (constraints != null) {
            String pattern = data.getUrlPattern();
            int pos = 0;
            for (ConstrainedProperty constraint : constraints) {
                if ((pos = pattern.indexOf(CAPTURED_WILDCARD, pos)) == -1) {
                    constraint.setNullable(true);
                } else if (pos + 3 < pattern.length() && pattern.charAt(pos + 3) == '?') {
                    constraint.setNullable(true);
                } else {
                    constraint.setNullable(false);
                }
                pos += 3;
            }
        }
    }

    protected Pattern convertToRegex(String url) {
        Pattern regex;
        String pattern = null;
        try {
            pattern = StringUtils.replace((String)url, (String)".", (String)"\\.");
            pattern = StringUtils.replace((String)pattern, (String)"+", (String)"\\+");
            pattern = "^" + pattern.replaceAll("([^\\*])\\*([^\\*])", "$1[^/]+$2").replaceAll("([^\\*])\\*$", "$1[^/]+").replaceAll("\\*\\*", ".*");
            pattern = pattern + "/??$";
            regex = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException pse) {
            throw new UrlMappingException("Error evaluating mapping for pattern [" + pattern + "] from Grails URL mappings: " + pse.getMessage(), pse);
        }
        return regex;
    }

    public UrlMappingInfo match(String uri) {
        for (Pattern pattern : this.patterns) {
            UrlMappingInfo urlInfo;
            Matcher m = pattern.matcher(uri);
            if (!m.matches() || (urlInfo = this.createUrlMappingInfo(uri, m)) == null) continue;
            return urlInfo;
        }
        return null;
    }

    public String createURL(Map paramValues, String encoding) {
        return this.createURLInternal(paramValues, encoding, true);
    }

    private String createURLInternal(Map paramValues, String encoding, boolean includeContextPath) {
        GrailsWebRequest webRequest;
        if (encoding == null) {
            encoding = "utf-8";
        }
        String contextPath = "";
        if (includeContextPath && (webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes()) != null) {
            contextPath = webRequest.getAttributes().getApplicationUri((ServletRequest)webRequest.getCurrentRequest());
        }
        if (paramValues == null) {
            paramValues = Collections.EMPTY_MAP;
        }
        StringBuilder uri = new StringBuilder(contextPath);
        HashSet<String> usedParams = new HashSet<String>();
        Pattern p = DOUBLE_WILDCARD_PATTERN;
        String[] tokens = this.urlData.getTokens();
        int paramIndex = 0;
        for (String token : tokens) {
            Matcher m = p.matcher(token);
            if (m.find()) {
                StringBuffer buf = new StringBuffer();
                do {
                    ConstrainedProperty prop = this.constraints[paramIndex++];
                    String propName = prop.getPropertyName();
                    Object value = paramValues.get(propName);
                    usedParams.add(propName);
                    if (value == null && !prop.isNullable()) {
                        throw new UrlMappingException("Unable to create URL for mapping [" + this + "] and parameters [" + paramValues + "]. Parameter [" + prop.getPropertyName() + "] is required, but was not specified!");
                    }
                    if (value == null) {
                        m.appendReplacement(buf, "");
                        continue;
                    }
                    m.appendReplacement(buf, Matcher.quoteReplacement(value.toString()));
                } while (m.find());
                m.appendTail(buf);
                try {
                    String v = buf.toString();
                    if (v.indexOf(SLASH) > -1 && CAPTURED_DOUBLE_WILDCARD.equals(token)) {
                        String[] segs;
                        if (v.startsWith(SLASH)) {
                            v = v.substring(SLASH.length());
                        }
                        for (String segment : segs = v.split(SLASH)) {
                            uri.append(SLASH).append(URLEncoder.encode(segment, encoding));
                        }
                        continue;
                    }
                    if (v.length() <= 0) break;
                    uri.append(SLASH).append(URLEncoder.encode(v, encoding));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ControllerExecutionException("Error creating URL for parameters [" + paramValues + "], problem encoding URL part [" + buf + "]: " + e.getMessage(), e);
                }
            }
            uri.append(SLASH).append(token);
        }
        this.populateParameterList(paramValues, encoding, uri, usedParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created reverse URL mapping [" + uri.toString() + "] for parameters [" + paramValues + "]"));
        }
        return uri.toString();
    }

    public String createURL(Map paramValues, String encoding, String fragment) {
        String url = this.createURL(paramValues, encoding);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    public String createURL(String controller, String action, Map paramValues, String encoding) {
        return this.createURLInternal(controller, action, paramValues, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createURLInternal(String controller, String action, Map paramValues, String encoding, boolean includeContextPath) {
        if (paramValues == null) {
            paramValues = new HashMap<String, String>();
        }
        boolean hasController = !StringUtils.isBlank((String)controller);
        boolean hasAction = !StringUtils.isBlank((String)action);
        try {
            if (hasController) {
                paramValues.put("controller", controller);
            }
            if (hasAction) {
                paramValues.put("action", action);
            }
            String string = this.createURLInternal(paramValues, encoding, includeContextPath);
            return string;
        }
        finally {
            if (hasController) {
                paramValues.remove("controller");
            }
            if (hasAction) {
                paramValues.remove("action");
            }
        }
    }

    public String createRelativeURL(String controller, String action, Map paramValues, String encoding) {
        return this.createURLInternal(controller, action, paramValues, encoding, false);
    }

    public String createRelativeURL(String controller, String action, Map paramValues, String encoding, String fragment) {
        String url = this.createURLInternal(controller, action, paramValues, encoding, false);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    public String createURL(String controller, String action, Map paramValues, String encoding, String fragment) {
        String url = this.createURL(controller, action, paramValues, encoding);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    private String createUrlWithFragment(String url, String fragment, String encoding) {
        if (fragment != null) {
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
            try {
                return url + '#' + URLEncoder.encode(fragment, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ControllerExecutionException("Error creating URL  [" + url + "], problem encoding URL fragment [" + fragment + "]: " + ex.getMessage(), ex);
            }
        }
        return url;
    }

    private void populateParameterList(Map paramValues, String encoding, StringBuilder uri, Set usedParams) {
        boolean addedParams = false;
        usedParams.add("controller");
        usedParams.add("action");
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        for (Object o1 : paramValues.keySet()) {
            Object o;
            Object[] multiValues;
            String name = o1.toString();
            if (usedParams.contains(name)) continue;
            if (!addedParams) {
                uri.append('?');
                addedParams = true;
            } else {
                uri.append('&');
            }
            Object value = paramValues.get(name);
            if (value != null && value instanceof Collection) {
                multiValues = (Object[])value;
                Iterator j = multiValues.iterator();
                while (j.hasNext()) {
                    o = j.next();
                    this.appendValueToURI(encoding, uri, name, o);
                    if (!j.hasNext()) continue;
                    uri.append('&');
                }
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                multiValues = (Object[])value;
                for (int j = 0; j < multiValues.length; ++j) {
                    o = multiValues[j];
                    this.appendValueToURI(encoding, uri, name, o);
                    if (j + 1 >= multiValues.length) continue;
                    uri.append('&');
                }
                continue;
            }
            this.appendValueToURI(encoding, uri, name, value);
        }
    }

    private void appendValueToURI(String encoding, StringBuilder uri, String name, Object value) {
        try {
            uri.append(URLEncoder.encode(name, encoding)).append('=').append(URLEncoder.encode(value != null ? value.toString() : "", encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new ControllerExecutionException("Error redirecting request for url [" + name + ":" + value + "]: " + e.getMessage(), e);
        }
    }

    public UrlMappingData getUrlData() {
        return this.urlData;
    }

    private UrlMappingInfo createUrlMappingInfo(String uri, Matcher m) {
        String remainingUri;
        HashMap<String, String> params = new HashMap<String, String>();
        MapBindingResult errors = new MapBindingResult(params, "urlMapping");
        String lastGroup = null;
        for (int i = 0; i < m.groupCount(); ++i) {
            lastGroup = m.group(i + 1);
            int j = lastGroup.indexOf(63);
            if (j > -1) {
                lastGroup = lastGroup.substring(0, j);
            }
            if (this.constraints.length <= i) continue;
            ConstrainedProperty cp = this.constraints[i];
            cp.validate((Object)this, (Object)lastGroup, (Errors)errors);
            if (errors.hasErrors()) {
                return null;
            }
            params.put(cp.getPropertyName(), lastGroup);
        }
        Map config = ConfigurationHolder.getFlatConfig();
        if (lastGroup != null && config != null && Boolean.TRUE.equals(config.get("grails.mapping.legacyMapping")) && (remainingUri = uri.substring(uri.lastIndexOf(lastGroup) + lastGroup.length())).length() > 0) {
            if (remainingUri.startsWith(SLASH)) {
                remainingUri = remainingUri.substring(1);
            }
            String[] tokens = remainingUri.split(SLASH);
            for (int i = 0; i < tokens.length; i += 2) {
                String token = tokens[i];
                if (i + 1 >= tokens.length) continue;
                params.put(token, tokens[i + 1]);
            }
        }
        for (Object key : this.parameterValues.keySet()) {
            params.put((String)key, (String)this.parameterValues.get(key));
        }
        if (this.controllerName == null) {
            this.controllerName = this.createRuntimeConstraintEvaluator("controller", this.constraints);
        }
        if (this.actionName == null) {
            this.actionName = this.createRuntimeConstraintEvaluator("action", this.constraints);
        }
        if (this.viewName == null) {
            this.viewName = this.createRuntimeConstraintEvaluator("view", this.constraints);
        }
        DefaultUrlMappingInfo info = this.forwardURI != null && this.controllerName == null ? new DefaultUrlMappingInfo(this.forwardURI, this.urlData, this.servletContext) : (this.viewName != null && this.controllerName == null ? new DefaultUrlMappingInfo(this.viewName, params, this.urlData, this.servletContext) : new DefaultUrlMappingInfo(this.controllerName, this.actionName, this.getViewName(), params, this.urlData, this.servletContext));
        if (this.parseRequest) {
            info.setParsingRequest(this.parseRequest);
        }
        return info;
    }

    private Object createRuntimeConstraintEvaluator(final String name, ConstrainedProperty[] constraints) {
        if (constraints == null) {
            return null;
        }
        for (ConstrainedProperty constraint : constraints) {
            if (!constraint.getPropertyName().equals(name)) continue;
            return new Closure(this){
                private static final long serialVersionUID = -2404119898659287216L;

                public Object call(Object[] objects) {
                    GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
                    return webRequest.getParams().get(name);
                }
            };
        }
        return null;
    }

    public String[] getLogicalMappings() {
        return this.urlData.getLogicalUrls();
    }

    public int compareTo(Object o) {
        int thisSingleWildcardCount;
        int thisDoubleWildcardCount;
        if (!(o instanceof UrlMapping)) {
            throw new IllegalArgumentException("Cannot compare with Object [" + o + "]. It is not an instance of UrlMapping!");
        }
        if (this.equals(o)) {
            return 0;
        }
        UrlMapping other = (UrlMapping)o;
        int otherDoubleWildcardCount = this.getDoubleWildcardCount(other);
        int doubleWildcardDiff = otherDoubleWildcardCount - (thisDoubleWildcardCount = this.getDoubleWildcardCount(this));
        if (doubleWildcardDiff != 0) {
            return doubleWildcardDiff;
        }
        int otherSingleWildcardCount = this.getSingleWildcardCount(other);
        int singleWildcardDiff = otherSingleWildcardCount - (thisSingleWildcardCount = this.getSingleWildcardCount(this));
        if (singleWildcardDiff != 0) {
            return singleWildcardDiff;
        }
        int thisStaticTokenCount = this.getStaticTokenCount(this);
        int otherStaticTokenCount = this.getStaticTokenCount(other);
        if (otherStaticTokenCount == 0 && thisStaticTokenCount > 0) {
            return 1;
        }
        if (thisStaticTokenCount == 0 && otherStaticTokenCount > 0) {
            return -1;
        }
        int staticDiff = thisStaticTokenCount - otherStaticTokenCount;
        if (staticDiff != 0) {
            return staticDiff;
        }
        String[] thisTokens = this.getUrlData().getTokens();
        String[] otherTokens = other.getUrlData().getTokens();
        for (int i = 0; i < thisTokens.length; ++i) {
            boolean thisTokenIsWildcard = this.isSingleWildcard(thisTokens[i]);
            boolean otherTokenIsWildcard = this.isSingleWildcard(otherTokens[i]);
            if (thisTokenIsWildcard && !otherTokenIsWildcard) {
                return -1;
            }
            if (thisTokenIsWildcard || !otherTokenIsWildcard) continue;
            return 1;
        }
        int constraintDiff = this.getAppliedConstraintsCount(this) - this.getAppliedConstraintsCount(other);
        if (constraintDiff != 0) {
            return constraintDiff;
        }
        return 0;
    }

    private int getAppliedConstraintsCount(UrlMapping mapping) {
        int count = 0;
        for (ConstrainedProperty prop : mapping.getConstraints()) {
            count += prop.getAppliedConstraints().size();
        }
        return count;
    }

    private int getSingleWildcardCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (!this.isSingleWildcard(token)) continue;
            ++count;
        }
        return count;
    }

    private int getDoubleWildcardCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (!this.isDoubleWildcard(token)) continue;
            ++count;
        }
        return count;
    }

    private int getStaticTokenCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (this.isSingleWildcard(token) || "".equals(token)) continue;
            ++count;
        }
        return count;
    }

    private boolean isSingleWildcard(String token) {
        return WILDCARD.equals(token) || CAPTURED_WILDCARD.equals(token);
    }

    private boolean isDoubleWildcard(String token) {
        return DOUBLE_WILDCARD.equals(token) || CAPTURED_DOUBLE_WILDCARD.equals(token);
    }

    public String toString() {
        return this.urlData.getUrlPattern();
    }
}

