/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;

public class LiveCacheStatisticsImpl
implements LiveCacheStatistics,
LiveCacheStatisticsData {
    private final AtomicBoolean statisticsEnabled = new AtomicBoolean(true);
    private final AtomicLong cacheHitInMemoryCount = new AtomicLong();
    private final AtomicLong cacheHitOnDiskCount = new AtomicLong();
    private final AtomicLong cacheMissNotFound = new AtomicLong();
    private final AtomicLong cacheMissExpired = new AtomicLong();
    private final AtomicLong cacheElementEvictedCount = new AtomicLong();
    private final AtomicLong totalGetTimeTakenMillis = new AtomicLong();
    private final AtomicLong cacheElementRemoved = new AtomicLong();
    private final AtomicLong cacheElementExpired = new AtomicLong();
    private final AtomicLong cacheElementPut = new AtomicLong();
    private final AtomicLong cacheElementUpdated = new AtomicLong();
    private final AtomicInteger statisticsAccuracy = new AtomicInteger();
    private final List<CacheUsageListener> listeners = new CopyOnWriteArrayList<CacheUsageListener>();
    private final Ehcache cache;

    public LiveCacheStatisticsImpl(Ehcache cache) {
        this.cache = cache;
    }

    public void clearStatistics() {
        this.cacheHitInMemoryCount.set(0L);
        this.cacheHitOnDiskCount.set(0L);
        this.cacheMissExpired.set(0L);
        this.cacheMissNotFound.set(0L);
        this.cacheElementEvictedCount.set(0L);
        this.totalGetTimeTakenMillis.set(0L);
        this.cacheElementRemoved.set(0L);
        this.cacheElementExpired.set(0L);
        this.cacheElementPut.set(0L);
        this.cacheElementUpdated.set(0L);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsCleared();
        }
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled.get();
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        if (enableStatistics) {
            this.clearStatistics();
        }
        this.statisticsEnabled.set(enableStatistics);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsEnabledChanged(enableStatistics);
        }
    }

    public void addGetTimeMillis(long millis) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.totalGetTimeTakenMillis.addAndGet(millis);
        for (CacheUsageListener l : this.listeners) {
            l.notifyTimeTakenForGet(millis);
        }
    }

    public void cacheHitInMemory() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitInMemoryCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheHitInMemory();
        }
    }

    public void cacheHitOnDisk() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheHitOnDiskCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheHitOnDisk();
        }
    }

    public void cacheMissExpired() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissExpired.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissedWithExpired();
        }
    }

    public void cacheMissNotFound() {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheMissNotFound.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheMissedWithNotFound();
        }
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        if (!Statistics.isValidStatisticsAccuracy(statisticsAccuracy)) {
            throw new IllegalArgumentException("Invalid statistics accuracy value: " + statisticsAccuracy);
        }
        this.statisticsAccuracy.set(statisticsAccuracy);
        for (CacheUsageListener l : this.listeners) {
            l.notifyStatisticsAccuracyChanged(statisticsAccuracy);
        }
    }

    public void dispose() {
        for (CacheUsageListener l : this.listeners) {
            l.dispose();
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementEvictedCount.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementEvicted();
        }
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementExpired.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementExpired();
        }
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementPut.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementPut();
        }
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementRemoved.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementRemoved();
        }
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        this.cacheElementUpdated.incrementAndGet();
        for (CacheUsageListener l : this.listeners) {
            l.notifyCacheElementUpdated();
        }
    }

    public void notifyRemoveAll(Ehcache cache) {
        if (!this.statisticsEnabled.get()) {
            return;
        }
        for (CacheUsageListener l : this.listeners) {
            l.notifyRemoveAll();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }

    public float getAverageGetTimeMillis() {
        long hitCount = this.getCacheHitCount();
        if (hitCount == 0L) {
            return 0.0f;
        }
        return (float)this.totalGetTimeTakenMillis.get() / (float)hitCount;
    }

    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.listeners.add(cacheUsageListener);
    }

    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.listeners.remove(cacheUsageListener);
    }

    public long getCacheHitCount() {
        return this.cacheHitInMemoryCount.get() + this.cacheHitOnDiskCount.get();
    }

    public long getCacheMissCount() {
        return this.cacheMissNotFound.get();
    }

    public long getCacheMissCountExpired() {
        return this.cacheMissExpired.get();
    }

    public long getEvictedCount() {
        return this.cacheElementEvictedCount.get();
    }

    public long getInMemoryHitCount() {
        return this.cacheHitInMemoryCount.get();
    }

    public long getOnDiskHitCount() {
        return this.cacheHitOnDiskCount.get();
    }

    public long getSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getSizeBasedOnAccuracy(this.statisticsAccuracy.get());
    }

    public long getInMemorySize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getMemoryStoreSize();
    }

    public long getOnDiskSize() {
        if (!this.statisticsEnabled.get()) {
            return 0L;
        }
        return this.cache.getDiskStoreSize();
    }

    public String getCacheName() {
        return this.cache.getName();
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy.get();
    }

    public long getExpiredCount() {
        return this.cacheElementExpired.get();
    }

    public long getPutCount() {
        return this.cacheElementPut.get();
    }

    public long getRemovedCount() {
        return this.cacheElementRemoved.get();
    }

    public long getUpdateCount() {
        return this.cacheElementUpdated.get();
    }

    public String getStatisticsAccuracyDescription() {
        int value = this.statisticsAccuracy.get();
        if (value == 0) {
            return "None";
        }
        if (value == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }
}

