/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.validation;

import groovy.lang.GroovyObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.plugins.support.aware.GrailsApplicationAware;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

public class GrailsDomainClassValidator
implements Validator,
CascadingValidator,
GrailsApplicationAware {
    private static final List<String> EMBEDDED_EXCLUDES = Arrays.asList("id", "version");
    protected Class<?> targetClass;
    protected GrailsDomainClass domainClass;
    protected MessageSource messageSource;
    protected GrailsApplication grailsApplication;
    private static final String ERRORS_PROPERTY = "errors";

    public boolean supports(Class clazz) {
        return this.targetClass.equals(clazz);
    }

    public void validate(Object obj, Errors errors, boolean cascade) {
        GrailsDomainClassProperty[] persistentProperties;
        if (!this.domainClass.getClazz().isInstance(obj)) {
            throw new IllegalArgumentException("Argument [" + obj + "] is not an instance of [" + this.domainClass.getClazz() + "] which this validator is configured for");
        }
        BeanWrapperImpl bean = new BeanWrapperImpl(obj);
        Map constrainedProperties = this.domainClass.getConstrainedProperties();
        HashSet constrainedPropertyNames = new HashSet(constrainedProperties.keySet());
        for (GrailsDomainClassProperty persistentProperty : persistentProperties = this.domainClass.getPersistentProperties()) {
            String propertyName = persistentProperty.getName();
            if (constrainedProperties.containsKey(propertyName)) {
                this.validatePropertyWithConstraint(propertyName, obj, errors, (BeanWrapper)bean, constrainedProperties);
            }
            if ((persistentProperty.isAssociation() || persistentProperty.isEmbedded()) && cascade) {
                this.cascadeToAssociativeProperty(errors, (BeanWrapper)bean, persistentProperty);
            }
            constrainedPropertyNames.remove(propertyName);
        }
        for (String name : constrainedPropertyNames) {
            this.validatePropertyWithConstraint(name, obj, errors, (BeanWrapper)bean, constrainedProperties);
        }
        if (obj instanceof GroovyObject) {
            ((GroovyObject)obj).setProperty(ERRORS_PROPERTY, (Object)errors);
        } else {
            InvokerHelper.setProperty((Object)obj, (String)ERRORS_PROPERTY, (Object)errors);
        }
        this.postValidate(obj, errors);
    }

    protected void postValidate(Object obj, Errors errors) {
    }

    public void validate(Object obj, Errors errors) {
        this.validate(obj, errors, false);
    }

    protected void cascadeToAssociativeProperty(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty) {
        String propertyName = persistentProperty.getName();
        if (errors.hasFieldErrors(propertyName)) {
            return;
        }
        if (persistentProperty.isManyToOne() || persistentProperty.isOneToOne() || persistentProperty.isEmbedded()) {
            Object associatedObject = bean.getPropertyValue(propertyName);
            this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
        } else if (persistentProperty.isOneToMany()) {
            this.cascadeValidationToMany(errors, bean, persistentProperty, propertyName);
        }
    }

    protected void cascadeValidationToMany(Errors errors, BeanWrapper bean, GrailsDomainClassProperty persistentProperty, String propertyName) {
        block3: {
            Object collection;
            block2: {
                collection = bean.getPropertyValue(propertyName);
                if (!(collection instanceof Collection)) break block2;
                for (Object associatedObject : (Collection)collection) {
                    this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
                }
                break block3;
            }
            if (!(collection instanceof Map)) break block3;
            for (Object associatedObject : ((Map)collection).values()) {
                this.cascadeValidationToOne(errors, bean, associatedObject, persistentProperty, propertyName);
            }
        }
    }

    private void validatePropertyWithConstraint(String propertyName, Object obj, Errors errors, BeanWrapper bean, Map constrainedProperties) {
        int i = propertyName.lastIndexOf(".");
        String constrainedPropertyName = i > -1 ? propertyName.substring(i + 1, propertyName.length()) : propertyName;
        FieldError fieldError = errors.getFieldError(constrainedPropertyName);
        if (fieldError == null) {
            ConstrainedProperty c = (ConstrainedProperty)constrainedProperties.get(constrainedPropertyName);
            c.setMessageSource(this.messageSource);
            c.validate(obj, bean.getPropertyValue(constrainedPropertyName), errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeValidationToOne(Errors errors, BeanWrapper bean, Object associatedObject, GrailsDomainClassProperty persistentProperty, String propertyName) {
        if (associatedObject == null) {
            return;
        }
        GrailsDomainClass associatedDomainClass = this.getAssociatedDomainClass(associatedObject, persistentProperty);
        if (associatedDomainClass == null || !this.isOwningInstance(bean, associatedDomainClass)) {
            return;
        }
        GrailsDomainClassProperty otherSide = null;
        if (persistentProperty.isBidirectional()) {
            otherSide = persistentProperty.getOtherSide();
        }
        Map associatedConstraintedProperties = associatedDomainClass.getConstrainedProperties();
        GrailsDomainClassProperty[] associatedPersistentProperties = associatedDomainClass.getPersistentProperties();
        String nestedPath = errors.getNestedPath();
        try {
            errors.setNestedPath(nestedPath + propertyName);
            for (GrailsDomainClassProperty associatedPersistentProperty : associatedPersistentProperties) {
                if (associatedPersistentProperty.equals(otherSide) || persistentProperty.isEmbedded() && EMBEDDED_EXCLUDES.contains(associatedPersistentProperty.getName())) continue;
                String associatedPropertyName = associatedPersistentProperty.getName();
                if (associatedConstraintedProperties.containsKey(associatedPropertyName)) {
                    this.validatePropertyWithConstraint(errors.getNestedPath() + associatedPropertyName, associatedObject, errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedConstraintedProperties);
                }
                if (!associatedPersistentProperty.isAssociation()) continue;
                this.cascadeToAssociativeProperty(errors, (BeanWrapper)new BeanWrapperImpl(associatedObject), associatedPersistentProperty);
            }
        }
        finally {
            errors.setNestedPath(nestedPath);
        }
    }

    private GrailsDomainClass getAssociatedDomainClass(Object associatedObject, GrailsDomainClassProperty persistentProperty) {
        if (persistentProperty.isEmbedded()) {
            return persistentProperty.getComponent();
        }
        if (this.grailsApplication != null) {
            return this.getAssociatedDomainClassFromApplication(associatedObject);
        }
        return persistentProperty.getReferencedDomainClass();
    }

    protected GrailsDomainClass getAssociatedDomainClassFromApplication(Object associatedObject) {
        String associatedObjectType = associatedObject.getClass().getName();
        return (GrailsDomainClass)this.grailsApplication.getArtefact("Domain", associatedObjectType);
    }

    private boolean isOwningInstance(BeanWrapper bean, GrailsDomainClass associatedDomainClass) {
        for (Class currentClass = bean.getWrappedClass(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            if (!associatedDomainClass.isOwningClass(currentClass)) continue;
            return true;
        }
        return false;
    }

    public void setDomainClass(GrailsDomainClass domainClass) {
        this.domainClass = domainClass;
        domainClass.setValidator(this);
        this.targetClass = domainClass.getClazz();
    }

    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setGrailsApplication(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }
}

