/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;
import jsr166y.forkjoin.AsyncAction;
import jsr166y.forkjoin.ForkJoinExecutor;
import jsr166y.forkjoin.ForkJoinPool;
import jsr166y.forkjoin.ForkJoinTask;
import jsr166y.forkjoin.ForkJoinWorkerThread;
import jsr166y.forkjoin.Ops;
import jsr166y.forkjoin.ParallelArray;
import jsr166y.forkjoin.ParallelDoubleArray;
import jsr166y.forkjoin.ParallelLongArray;
import jsr166y.forkjoin.RecursiveAction;

class PAS {
    private static ForkJoinPool defaultExecutor;
    private static final Object poolLock;
    static final int INSERTION_SORT_THRESHOLD = 8;

    private PAS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ForkJoinExecutor defaultExecutor() {
        Object object = poolLock;
        synchronized (object) {
            ForkJoinPool p = defaultExecutor;
            if (p == null) {
                int nprocs = Runtime.getRuntime().availableProcessors();
                int nthreads = nprocs - (nprocs >>> 3);
                defaultExecutor = p = new ForkJoinPool(nthreads);
            }
            return p;
        }
    }

    static void rquickSort(Object[] a, Comparator cmp, int lo, int hi) {
        while (true) {
            Object t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && cmp.compare(t, a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (cmp.compare(a[lo], a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (cmp.compare(a[mid], a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (cmp.compare(a[lo], a[mid]) > 0) {
                    Object u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            Object pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (cmp.compare(pivot, a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && cmp.compare(pivot, a[left]) >= 0) {
                    ++left;
                }
                if (left >= right) break;
                Object t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.rquickSort(a, cmp, lo, left);
            lo = left + 1;
        }
    }

    static void rcquickSort(Comparable[] a, int lo, int hi) {
        while (true) {
            Comparable t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && t.compareTo(a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (a[lo].compareTo(a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (a[mid].compareTo(a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (a[lo].compareTo(a[mid]) > 0) {
                    Comparable u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            Comparable pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (pivot.compareTo(a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && pivot.compareTo(a[left]) >= 0) {
                    ++left;
                }
                if (left >= right) break;
                Comparable t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.rcquickSort(a, lo, left);
            lo = left + 1;
        }
    }

    static void dquickSort(double[] a, Ops.DoubleComparator cmp, int lo, int hi) {
        while (true) {
            double t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && cmp.compare(t, a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (cmp.compare(a[lo], a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (cmp.compare(a[mid], a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (cmp.compare(a[lo], a[mid]) > 0) {
                    double u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            double pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (cmp.compare(pivot, a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && cmp.compare(pivot, a[left]) >= 0) {
                    ++left;
                }
                if (left >= right) break;
                double t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.dquickSort(a, cmp, lo, left);
            lo = left + 1;
        }
    }

    static void dcquickSort(double[] a, int lo, int hi) {
        while (true) {
            double t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && t < a[j]; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (a[lo] > a[mid]) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (a[mid] > a[hi]) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (a[lo] > a[mid]) {
                    double u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            double pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (pivot < a[right]) {
                    --right;
                    continue;
                }
                while (left < right && pivot >= a[left]) {
                    ++left;
                }
                if (left >= right) break;
                double t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.dcquickSort(a, lo, left);
            lo = left + 1;
        }
    }

    static void lquickSort(long[] a, Ops.LongComparator cmp, int lo, int hi) {
        while (true) {
            long t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && cmp.compare(t, a[j]) < 0; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (cmp.compare(a[lo], a[mid]) > 0) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (cmp.compare(a[mid], a[hi]) > 0) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (cmp.compare(a[lo], a[mid]) > 0) {
                    long u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            long pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (cmp.compare(pivot, a[right]) < 0) {
                    --right;
                    continue;
                }
                while (left < right && cmp.compare(pivot, a[left]) >= 0) {
                    ++left;
                }
                if (left >= right) break;
                long t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.lquickSort(a, cmp, lo, left);
            lo = left + 1;
        }
    }

    static void lcquickSort(long[] a, int lo, int hi) {
        while (true) {
            long t;
            if (hi - lo <= 8) {
                for (int i = lo + 1; i <= hi; ++i) {
                    t = a[i];
                    for (int j = i - 1; j >= lo && t < a[j]; --j) {
                        a[j + 1] = a[j];
                    }
                    a[j + 1] = t;
                }
                return;
            }
            int mid = lo + hi >>> 1;
            if (a[lo] > a[mid]) {
                t = a[lo];
                a[lo] = a[mid];
                a[mid] = t;
            }
            if (a[mid] > a[hi]) {
                t = a[mid];
                a[mid] = a[hi];
                a[hi] = t;
                if (a[lo] > a[mid]) {
                    long u = a[lo];
                    a[lo] = a[mid];
                    a[mid] = u;
                }
            }
            long pivot = a[mid];
            int left = lo + 1;
            int right = hi - 1;
            while (true) {
                if (pivot < a[right]) {
                    --right;
                    continue;
                }
                while (left < right && pivot >= a[left]) {
                    ++left;
                }
                if (left >= right) break;
                long t2 = a[left];
                a[left] = a[right];
                a[right] = t2;
                --right;
            }
            PAS.lcquickSort(a, lo, left);
            lo = left + 1;
        }
    }

    static {
        poolLock = new Object();
    }

    static final class FJLPrecumulatePlusOp
    extends FJLScanPlusOp {
        FJLPrecumulatePlusOp(LPrefix prefix) {
            super(prefix);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                sum += arr[i];
            }
            f.lsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum += x;
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum += x;
            }
            f.lsetOut(sum);
        }
    }

    static final class FJLCumulatePlusOp
    extends FJLScanPlusOp {
        FJLCumulatePlusOp(LPrefix prefix) {
            super(prefix);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            long sum = 0L;
            if (hi != this.upperBound) {
                long[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum += arr[i];
                }
            }
            f.lsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = 0L;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
            f.lsetOut(sum);
        }
    }

    static abstract class FJLScanPlusOp
    extends FJScanOp {
        final long[] array;

        FJLScanPlusOp(LPrefix prefix) {
            super(prefix);
            this.array = prefix.pa.array;
        }

        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            long pin = parent.lgetIn();
            left.lsetIn(pin);
            right.lsetIn(pin + left.lgetOut());
        }

        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.lsetOut(left.lgetOut() + right.lgetOut());
        }

        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJLScan f = new FJLScan(parent, this, lo, hi);
            f.in = 0L;
            f.out = 0L;
            return f;
        }
    }

    static final class FJDPrecumulatePlusOp
    extends FJDScanPlusOp {
        FJDPrecumulatePlusOp(DPrefix prefix) {
            super(prefix);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                sum += arr[i];
            }
            f.dsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum += x;
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum += x;
            }
            f.dsetOut(sum);
        }
    }

    static final class FJDCumulatePlusOp
    extends FJDScanPlusOp {
        FJDCumulatePlusOp(DPrefix prefix) {
            super(prefix);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            double sum = 0.0;
            if (hi != this.upperBound) {
                double[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum += arr[i];
                }
            }
            f.dsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = 0.0;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum += arr[i];
            }
            f.dsetOut(sum);
        }
    }

    static abstract class FJDScanPlusOp
    extends FJScanOp {
        final double[] array;

        FJDScanPlusOp(DPrefix prefix) {
            super(prefix);
            this.array = prefix.pa.array;
        }

        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            double pin = parent.dgetIn();
            left.dsetIn(pin);
            right.dsetIn(pin + left.dgetOut());
        }

        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.dsetOut(left.dgetOut() + right.dgetOut());
        }

        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJDScan f = new FJDScan(parent, this, lo, hi);
            f.in = 0.0;
            f.out = 0.0;
            return f;
        }
    }

    static final class FJLPrecumulateOp
    extends FJLScanOp {
        FJLPrecumulateOp(LPrefix prefix, Ops.LongReducer reducer, long base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.combine(sum, arr[i]);
            }
            f.lsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                long x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
            f.lsetOut(sum);
        }
    }

    static final class FJLCumulateOp
    extends FJLScanOp {
        FJLCumulateOp(LPrefix prefix, Ops.LongReducer reducer, long base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            long sum = this.base;
            if (hi != this.upperBound) {
                long[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.combine(sum, arr[i]);
                }
            }
            f.lsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = f.lgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            long[] arr = this.array;
            long sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
            f.lsetOut(sum);
        }
    }

    static abstract class FJLScanOp
    extends FJScanOp {
        final long[] array;
        final Ops.LongReducer reducer;
        final long base;

        FJLScanOp(LPrefix prefix, Ops.LongReducer reducer, long base) {
            super(prefix);
            this.array = prefix.pa.array;
            this.reducer = reducer;
            this.base = base;
        }

        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            long pin = parent.lgetIn();
            left.lsetIn(pin);
            right.lsetIn(this.reducer.combine(pin, left.lgetOut()));
        }

        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.lsetOut(this.reducer.combine(left.lgetOut(), right.lgetOut()));
        }

        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJLScan f = new FJLScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static final class FJDPrecumulateOp
    extends FJDScanOp {
        FJDPrecumulateOp(DPrefix prefix, Ops.DoubleReducer reducer, double base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.combine(sum, arr[i]);
            }
            f.dsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                double x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
            f.dsetOut(sum);
        }
    }

    static final class FJDCumulateOp
    extends FJDScanOp {
        FJDCumulateOp(DPrefix prefix, Ops.DoubleReducer reducer, double base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            double sum = this.base;
            if (hi != this.upperBound) {
                double[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.combine(sum, arr[i]);
                }
            }
            f.dsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = f.dgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            double[] arr = this.array;
            double sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
            f.dsetOut(sum);
        }
    }

    static abstract class FJDScanOp
    extends FJScanOp {
        final double[] array;
        final Ops.DoubleReducer reducer;
        final double base;

        FJDScanOp(DPrefix prefix, Ops.DoubleReducer reducer, double base) {
            super(prefix);
            this.array = prefix.pa.array;
            this.reducer = reducer;
            this.base = base;
        }

        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            double pin = parent.dgetIn();
            left.dsetIn(pin);
            right.dsetIn(this.reducer.combine(pin, left.dgetOut()));
        }

        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.dsetOut(this.reducer.combine(left.dgetOut(), right.dgetOut()));
        }

        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJDScan f = new FJDScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static final class FJRPrecumulateOp
    extends FJRScanOp {
        FJRPrecumulateOp(RPrefix prefix, Ops.Reducer reducer, Object base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                sum = this.reducer.combine(sum, arr[i]);
            }
            f.rsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = f.rgetIn();
            for (int i = lo; i < hi; ++i) {
                Object x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                Object x = arr[i];
                arr[i] = sum;
                sum = this.reducer.combine(sum, x);
            }
            f.rsetOut(sum);
        }
    }

    static final class FJRCumulateOp
    extends FJRScanOp {
        FJRCumulateOp(RPrefix prefix, Ops.Reducer reducer, Object base) {
            super(prefix, reducer, base);
        }

        void sumLeaf(int lo, int hi, FJScan f) {
            Object sum = this.base;
            if (hi != this.upperBound) {
                Object[] arr = this.array;
                for (int i = lo; i < hi; ++i) {
                    sum = this.reducer.combine(sum, arr[i]);
                }
            }
            f.rsetOut(sum);
        }

        void cumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = f.rgetIn();
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
        }

        void sumAndCumulateLeaf(int lo, int hi, FJScan f) {
            Object[] arr = this.array;
            Object sum = this.base;
            for (int i = lo; i < hi; ++i) {
                arr[i] = sum = this.reducer.combine(sum, arr[i]);
            }
            f.rsetOut(sum);
        }
    }

    static abstract class FJRScanOp
    extends FJScanOp {
        final Object[] array;
        final Ops.Reducer reducer;
        final Object base;

        FJRScanOp(RPrefix prefix, Ops.Reducer reducer, Object base) {
            super(prefix);
            this.array = prefix.pa.array;
            this.reducer = reducer;
            this.base = base;
        }

        final void pushDown(FJScan parent, FJScan left, FJScan right) {
            Object pin = parent.rgetIn();
            left.rsetIn(pin);
            right.rsetIn(this.reducer.combine(pin, left.rgetOut()));
        }

        final void pushUp(FJScan parent, FJScan left, FJScan right) {
            parent.rsetOut(this.reducer.combine(left.rgetOut(), right.rgetOut()));
        }

        final FJScan newSubtask(FJScan parent, int lo, int hi) {
            FJRScan f = new FJRScan(parent, this, lo, hi);
            f.in = this.base;
            f.out = this.base;
            return f;
        }
    }

    static abstract class FJScanOp {
        final int threshold;
        final int firstIndex;
        final int upperBound;

        FJScanOp(Prefix prefix) {
            this.firstIndex = prefix.firstIndex;
            this.upperBound = prefix.upperBound;
            this.threshold = prefix.threshold;
        }

        abstract void pushDown(FJScan var1, FJScan var2, FJScan var3);

        abstract void pushUp(FJScan var1, FJScan var2, FJScan var3);

        abstract void sumLeaf(int var1, int var2, FJScan var3);

        abstract void cumulateLeaf(int var1, int var2, FJScan var3);

        abstract void sumAndCumulateLeaf(int var1, int var2, FJScan var3);

        abstract FJScan newSubtask(FJScan var1, int var2, int var3);
    }

    static final class FJLScan
    extends FJScan {
        long in;
        long out;

        FJLScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        long lgetIn() {
            return this.in;
        }

        long lgetOut() {
            return this.out;
        }

        void lsetIn(long x) {
            this.in = x;
        }

        void lsetOut(long x) {
            this.out = x;
        }
    }

    static final class FJDScan
    extends FJScan {
        double in;
        double out;

        FJDScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        double dgetIn() {
            return this.in;
        }

        double dgetOut() {
            return this.out;
        }

        void dsetIn(double x) {
            this.in = x;
        }

        void dsetOut(double x) {
            this.out = x;
        }
    }

    static final class FJRScan
    extends FJScan {
        Object in;
        Object out;

        FJRScan(FJScan parent, FJScanOp op, int lo, int hi) {
            super(parent, op, lo, hi);
        }

        Object rgetIn() {
            return this.in;
        }

        Object rgetOut() {
            return this.out;
        }

        void rsetIn(Object x) {
            this.in = x;
        }

        void rsetOut(Object x) {
            this.out = x;
        }
    }

    static abstract class FJScan
    extends AsyncAction {
        static final int CUMULATE = 1;
        static final int SUMMED = 2;
        static final int FINISHED = 4;
        final FJScan parent;
        final FJScanOp op;
        FJScan left;
        FJScan right;
        volatile int phase;
        final int lo;
        final int hi;
        static final AtomicIntegerFieldUpdater<FJScan> phaseUpdater = AtomicIntegerFieldUpdater.newUpdater(FJScan.class, "phase");

        FJScan(FJScan parent, FJScanOp op, int lo, int hi) {
            this.parent = parent;
            this.op = op;
            this.lo = lo;
            this.hi = hi;
        }

        final boolean transitionToCumulate() {
            int c;
            while (((c = this.phase) & 1) == 0) {
                if (!phaseUpdater.compareAndSet(this, c, c | 1)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void compute() {
            if (this.hi - this.lo > this.op.threshold) {
                boolean cumulate;
                if (this.left == null) {
                    int mid = this.lo + this.hi >>> 1;
                    this.left = this.op.newSubtask(this, this.lo, mid);
                    this.right = this.op.newSubtask(this, mid, this.hi);
                }
                boolean bl = cumulate = (this.phase & 1) != 0;
                if (cumulate) {
                    this.op.pushDown(this, this.left, this.right);
                }
                if (!cumulate || this.right.transitionToCumulate()) {
                    this.right.fork();
                }
                if (cumulate && !this.left.transitionToCumulate()) return;
                this.left.compute();
                return;
            } else {
                int cb;
                int b;
                do {
                    if (((b = this.phase) & 4) == 0) continue;
                    return;
                } while (!phaseUpdater.compareAndSet(this, b, b | (cb = (b & 1) != 0 ? 4 : (this.lo == this.op.firstIndex ? 6 : 2))));
                if (cb == 2) {
                    this.op.sumLeaf(this.lo, this.hi, this);
                } else if (cb == 4) {
                    this.op.cumulateLeaf(this.lo, this.hi, this);
                } else if (cb == 6) {
                    this.op.sumAndCumulateLeaf(this.lo, this.hi, this);
                }
                FJScan ch = this;
                FJScan par = this.parent;
                while (true) {
                    if (par == null) {
                        if ((cb & 4) == 0) return;
                        ch.finish();
                        return;
                    }
                    int pb = par.phase;
                    if ((pb & cb & 4) != 0) {
                        ch = par;
                        par = par.parent;
                        continue;
                    }
                    if ((pb & cb & 2) != 0) {
                        this.op.pushUp(par, par.left, par.right);
                        int refork = (pb & 1) == 0 && par.lo == this.op.firstIndex ? 1 : 0;
                        int nextPhase = pb | cb | refork;
                        if (pb != nextPhase && !phaseUpdater.compareAndSet(par, pb, nextPhase)) continue;
                        if (refork != 0) {
                            par.fork();
                        }
                        cb = 2;
                        ch = par;
                        par = par.parent;
                        continue;
                    }
                    if (phaseUpdater.compareAndSet(par, pb, pb | cb)) return;
                }
            }
        }

        Object rgetIn() {
            return null;
        }

        Object rgetOut() {
            return null;
        }

        void rsetIn(Object x) {
        }

        void rsetOut(Object x) {
        }

        double dgetIn() {
            return 0.0;
        }

        double dgetOut() {
            return 0.0;
        }

        void dsetIn(double x) {
        }

        void dsetOut(double x) {
        }

        long lgetIn() {
            return 0L;
        }

        long lgetOut() {
            return 0L;
        }

        void lsetIn(long x) {
        }

        void lsetOut(long x) {
        }
    }

    static final class FJLCMerger
    extends RecursiveAction {
        final long[] a;
        final long[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJLCMerger next;

        FJLCMerger(long[] a, long[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJLCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJLCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                long split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split <= this.a[this.ro + mid]) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJLCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                long t;
                long al = this.a[l];
                long ar = this.a[r];
                if (al <= ar) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJLMerger
    extends RecursiveAction {
        final Ops.LongComparator cmp;
        final long[] a;
        final long[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJLMerger next;

        FJLMerger(Ops.LongComparator cmp, long[] a, long[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJLMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJLMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                long split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJLMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                long t;
                long al = this.a[l];
                long ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJDCMerger
    extends RecursiveAction {
        final double[] a;
        final double[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJDCMerger next;

        FJDCMerger(double[] a, double[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJDCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJDCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                double split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split <= this.a[this.ro + mid]) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJDCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                double t;
                double al = this.a[l];
                double ar = this.a[r];
                if (al <= ar) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJDMerger
    extends RecursiveAction {
        final Ops.DoubleComparator cmp;
        final double[] a;
        final double[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJDMerger next;

        FJDMerger(Ops.DoubleComparator cmp, double[] a, double[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJDMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJDMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                double split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJDMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                double t;
                double al = this.a[l];
                double ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJRCMerger
    extends RecursiveAction {
        final Comparable[] a;
        final Comparable[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJRCMerger next;

        FJRCMerger(Comparable[] a, Comparable[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJRCMerger next) {
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJRCMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                Comparable split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (split.compareTo(this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJRCMerger(this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                Comparable t;
                Comparable al = this.a[l];
                Comparable ar = this.a[r];
                if (al.compareTo(ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJRMerger
    extends RecursiveAction {
        final Comparator cmp;
        final Object[] a;
        final Object[] w;
        final int lo;
        final int ln;
        final int ro;
        final int rn;
        final int wo;
        final int gran;
        final FJRMerger next;

        FJRMerger(Comparator cmp, Object[] a, Object[] w, int lo, int ln, int ro, int rn, int wo, int gran, FJRMerger next) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.lo = lo;
            this.ln = ln;
            this.ro = ro;
            this.rn = rn;
            this.wo = wo;
            this.gran = gran;
            this.next = next;
        }

        public void compute() {
            FJRMerger rights = null;
            int nleft = this.ln;
            int nright = this.rn;
            while (nleft > this.gran) {
                int lh = nleft >>> 1;
                int splitIndex = this.lo + lh;
                Object split = this.a[splitIndex];
                int rl = 0;
                int rh = nright;
                while (rl < rh) {
                    int mid = rl + rh >>> 1;
                    if (this.cmp.compare(split, this.a[this.ro + mid]) <= 0) {
                        rh = mid;
                        continue;
                    }
                    rl = mid + 1;
                }
                rights = new FJRMerger(this.cmp, this.a, this.w, splitIndex, nleft - lh, this.ro + rh, nright - rh, this.wo + lh + rh, this.gran, rights);
                rights.fork();
                nleft = lh;
                nright = rh;
            }
            int l = this.lo;
            int lFence = this.lo + nleft;
            int r = this.ro;
            int rFence = this.ro + nright;
            int k = this.wo;
            while (l < lFence && r < rFence) {
                Object t;
                Object al = this.a[l];
                Object ar = this.a[r];
                if (this.cmp.compare(al, ar) <= 0) {
                    ++l;
                    t = al;
                } else {
                    ++r;
                    t = ar;
                }
                this.w[k++] = t;
            }
            while (l < lFence) {
                this.w[k++] = this.a[l++];
            }
            while (r < rFence) {
                this.w[k++] = this.a[r++];
            }
            while (rights != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(rights)) {
                    rights.compute();
                } else {
                    rights.join();
                }
                rights = rights.next;
            }
        }
    }

    static final class FJSubSorter
    extends RecursiveAction {
        final RecursiveAction left;
        final RecursiveAction right;
        final RecursiveAction merger;

        FJSubSorter(RecursiveAction left, RecursiveAction right, RecursiveAction merger) {
            this.left = left;
            this.right = right;
            this.merger = merger;
        }

        public void compute() {
            FJSubSorter.forkJoin(this.left, this.right);
            this.merger.compute();
        }
    }

    static final class FJLCSorter
    extends RecursiveAction {
        final long[] a;
        final long[] w;
        final int origin;
        final int n;
        final int gran;

        FJLCSorter(long[] a, long[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJLCSorter.forkJoin(new FJSubSorter(new FJLCSorter(this.a, this.w, l, q, g), new FJLCSorter(this.a, this.w, l + q, h - q, g), new FJLCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJLCSorter(this.a, this.w, l + h, q, g), new FJLCSorter(this.a, this.w, l + u, this.n - u, g), new FJLCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJLCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.lcquickSort(this.a, l, l + this.n - 1);
            }
        }
    }

    static final class FJLSorter
    extends RecursiveAction {
        final Ops.LongComparator cmp;
        final long[] a;
        final long[] w;
        final int origin;
        final int n;
        final int gran;

        FJLSorter(Ops.LongComparator cmp, long[] a, long[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJLSorter.forkJoin(new FJSubSorter(new FJLSorter(this.cmp, this.a, this.w, l, q, g), new FJLSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJLMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJLSorter(this.cmp, this.a, this.w, l + h, q, g), new FJLSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJLMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJLMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.lquickSort(this.a, this.cmp, l, l + this.n - 1);
            }
        }
    }

    static final class FJDCSorter
    extends RecursiveAction {
        final double[] a;
        final double[] w;
        final int origin;
        final int n;
        final int gran;

        FJDCSorter(double[] a, double[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJDCSorter.forkJoin(new FJSubSorter(new FJDCSorter(this.a, this.w, l, q, g), new FJDCSorter(this.a, this.w, l + q, h - q, g), new FJDCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJDCSorter(this.a, this.w, l + h, q, g), new FJDCSorter(this.a, this.w, l + u, this.n - u, g), new FJDCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJDCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.dcquickSort(this.a, l, l + this.n - 1);
            }
        }
    }

    static final class FJDSorter
    extends RecursiveAction {
        final Ops.DoubleComparator cmp;
        final double[] a;
        final double[] w;
        final int origin;
        final int n;
        final int gran;

        FJDSorter(Ops.DoubleComparator cmp, double[] a, double[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJDSorter.forkJoin(new FJSubSorter(new FJDSorter(this.cmp, this.a, this.w, l, q, g), new FJDSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJDMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJDSorter(this.cmp, this.a, this.w, l + h, q, g), new FJDSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJDMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJDMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.dquickSort(this.a, this.cmp, l, l + this.n - 1);
            }
        }
    }

    static final class FJRCSorter
    extends RecursiveAction {
        final Comparable[] a;
        final Comparable[] w;
        final int origin;
        final int n;
        final int gran;

        FJRCSorter(Comparable[] a, Comparable[] w, int origin, int n, int gran) {
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJRCSorter.forkJoin(new FJSubSorter(new FJRCSorter(this.a, this.w, l, q, g), new FJRCSorter(this.a, this.w, l + q, h - q, g), new FJRCMerger(this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJRCSorter(this.a, this.w, l + h, q, g), new FJRCSorter(this.a, this.w, l + u, this.n - u, g), new FJRCMerger(this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJRCMerger(this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.rcquickSort(this.a, l, l + this.n - 1);
            }
        }
    }

    static final class FJRSorter
    extends RecursiveAction {
        final Comparator cmp;
        final Object[] a;
        final Object[] w;
        final int origin;
        final int n;
        final int gran;

        FJRSorter(Comparator cmp, Object[] a, Object[] w, int origin, int n, int gran) {
            this.cmp = cmp;
            this.a = a;
            this.w = w;
            this.origin = origin;
            this.n = n;
            this.gran = gran;
        }

        public void compute() {
            int l = this.origin;
            int g = this.gran;
            if (this.n > g) {
                int h = this.n >>> 1;
                int q = this.n >>> 2;
                int u = h + q;
                FJRSorter.forkJoin(new FJSubSorter(new FJRSorter(this.cmp, this.a, this.w, l, q, g), new FJRSorter(this.cmp, this.a, this.w, l + q, h - q, g), new FJRMerger(this.cmp, this.a, this.w, l, q, l + q, h - q, l, g, null)), new FJSubSorter(new FJRSorter(this.cmp, this.a, this.w, l + h, q, g), new FJRSorter(this.cmp, this.a, this.w, l + u, this.n - u, g), new FJRMerger(this.cmp, this.a, this.w, l + h, q, l + u, this.n - u, l + h, g, null)));
                new FJRMerger(this.cmp, this.w, this.a, l, h, l + h, this.n - h, l, g, null).compute();
            } else {
                PAS.rquickSort(this.a, this.cmp, l, l + this.n - 1);
            }
        }
    }

    static final class LUniquifierTable
    extends UniquifierTable {
        final long[] source;
        final Ops.LongPredicate selector;

        LUniquifierTable(int size, long[] array, Ops.LongPredicate selector) {
            super(size);
            this.source = array;
            this.selector = selector;
        }

        int addElements(int lo, int hi) {
            Ops.LongPredicate selector = this.selector;
            long[] src = this.source;
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                long x = src[k];
                if (selector != null && !selector.evaluate(x)) continue;
                int hash = LUniquifierTable.hash((int)(x ^ x >>> 32));
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        if ((int)(d >>> 32) == hash && x == src[(int)(d - 1L & Integer.MAX_VALUE)]) continue block0;
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        long[] uniqueElements(int size) {
            long[] res = new long[size];
            long[] src = this.source;
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }
    }

    static final class DUniquifierTable
    extends UniquifierTable {
        final double[] source;
        final Ops.DoublePredicate selector;

        DUniquifierTable(int size, double[] array, Ops.DoublePredicate selector) {
            super(size);
            this.source = array;
            this.selector = selector;
        }

        int addElements(int lo, int hi) {
            Ops.DoublePredicate selector = this.selector;
            double[] src = this.source;
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                double x = src[k];
                if (selector != null && !selector.evaluate(x)) continue;
                long bits = Double.doubleToLongBits(x);
                int hash = DUniquifierTable.hash((int)(bits ^ bits >>> 32));
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        if ((int)(d >>> 32) == hash && x == src[(int)(d - 1L & Integer.MAX_VALUE)]) continue block0;
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        double[] uniqueElements(int size) {
            double[] res = new double[size];
            double[] src = this.source;
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }
    }

    static final class RUniquifierTable
    extends UniquifierTable {
        final Object[] source;
        final Ops.Predicate selector;
        final boolean byIdentity;

        RUniquifierTable(int size, Object[] array, Ops.Predicate selector, boolean byIdentity) {
            super(size);
            this.source = array;
            this.selector = selector;
            this.byIdentity = byIdentity;
        }

        int addElements(int lo, int hi) {
            Ops.Predicate selector = this.selector;
            Object[] src = this.source;
            int mask = this.length() - 1;
            int count = 0;
            block0: for (int k = lo; k < hi; ++k) {
                Object x = src[k];
                if (x == null || selector != null && !selector.evaluate(x)) continue;
                int hc = this.byIdentity ? System.identityHashCode(x) : x.hashCode();
                int hash = RUniquifierTable.hash(hc);
                long entry = ((long)hash << 32) + (long)(k + 1);
                int idx = hash & mask;
                while (true) {
                    long d;
                    if ((d = this.get(idx)) != 0L) {
                        if ((int)(d >>> 32) == hash) {
                            Object y = src[(int)(d - 1L & Integer.MAX_VALUE)];
                            if (this.byIdentity ? x == y : x.equals(y)) continue block0;
                        }
                        idx = idx + 1 & mask;
                        continue;
                    }
                    if (this.compareAndSet(idx, 0L, entry)) break;
                }
                ++count;
            }
            return count;
        }

        Object[] uniqueElements(int size) {
            Object[] src = this.source;
            Class<?> sclass = src.getClass().getComponentType();
            Object[] res = (Object[])Array.newInstance(sclass, size);
            int k = 0;
            int n = this.length();
            for (int i = 0; i < n && k < size; ++i) {
                long d = this.get(i);
                if (d == 0L) continue;
                res[k++] = src[(int)(d - 1L & Integer.MAX_VALUE)];
            }
            return res;
        }
    }

    static abstract class UniquifierTable
    extends AtomicLongArray {
        UniquifierTable(int size) {
            super(UniquifierTable.tableSizeFor(size));
        }

        static int tableSizeFor(int n) {
            int s;
            int padded = n + (n >>> 1) + 1;
            if (padded < n) {
                throw new OutOfMemoryError();
            }
            for (s = 8; s < padded; s <<= 1) {
            }
            return s;
        }

        static int hash(int h) {
            h ^= h >>> 20 ^ h >>> 12;
            return h ^ h >>> 7 ^ h >>> 4;
        }

        abstract int addElements(int var1, int var2);
    }

    static final class FJUniquifier
    extends FJBase {
        final UniquifierTable table;
        int count;

        FJUniquifier(Prefix prefix, int lo, int hi, FJBase next, UniquifierTable table) {
            super(prefix, lo, hi, next);
            this.table = table;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJUniquifier(this.prefix, l, h, r, this.table);
        }

        void atLeaf(int l, int h) {
            this.count = this.table.addElements(l, h);
        }

        void onReduce(FJBase right) {
            this.count += ((FJUniquifier)right).count;
        }
    }

    static final class FJRemoveAll
    extends RecursiveAction {
        final Prefix prefix;
        final int lo;
        final int hi;
        final FJRemoveAll next;
        final int[] indices;
        int count;
        FJRemoveAll right;

        FJRemoveAll(Prefix prefix, int lo, int hi, FJRemoveAll next, int[] indices) {
            this.prefix = prefix;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
            this.indices = indices;
        }

        public void compute() {
            FJRemoveAll r = null;
            int l = this.lo;
            int h = this.hi;
            while (this.prefix.shouldSplit(h - l)) {
                int rh = h;
                h = l + h >>> 1;
                r = new FJRemoveAll(this.prefix, h, rh, r, this.indices);
                r.fork();
            }
            this.right = r;
            this.count = this.prefix.leafIndexSelected(l, h, false, this.indices);
            while (r != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(r)) {
                    r.count = this.prefix.leafIndexSelected(r.lo, r.hi, false, this.indices);
                } else {
                    r.join();
                }
                r = r.next;
            }
        }
    }

    static final class FJRemoveAllDriver
    extends RecursiveAction {
        final Prefix prefix;
        final int lo;
        final int hi;
        final int[] indices;
        int offset;

        FJRemoveAllDriver(Prefix prefix, int lo, int hi) {
            this.prefix = prefix;
            this.lo = lo;
            this.hi = hi;
            this.indices = new int[hi - lo];
        }

        public void compute() {
            ForkJoinTask r = null;
            int l = this.lo;
            int h = this.hi;
            while (this.prefix.shouldSplit(h - l)) {
                int rh = h;
                h = l + h >>> 1;
                r = new FJRemoveAll(this.prefix, h, rh, (FJRemoveAll)r, this.indices);
                r.fork();
            }
            int k = this.prefix.leafMoveSelected(l, h, l, false);
            while (r != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(r)) {
                    k = this.prefix.leafMoveSelected(((FJRemoveAll)r).lo, ((FJRemoveAll)r).hi, k, false);
                } else {
                    r.join();
                    int n = ((FJRemoveAll)r).count;
                    if (n != 0) {
                        this.prefix.leafMoveByIndex(this.indices, ((FJRemoveAll)r).lo, ((FJRemoveAll)r).lo + n, k);
                    }
                    k += n;
                    FJRemoveAll rr = ((FJRemoveAll)r).right;
                    if (rr != null) {
                        k = FJRemoveAllDriver.inorderMove(rr, k);
                    }
                }
                r = ((FJRemoveAll)r).next;
            }
            this.offset = k;
        }

        static int inorderMove(FJRemoveAll t, int index) {
            while (t != null) {
                int n = t.count;
                if (n != 0) {
                    t.prefix.leafMoveByIndex(t.indices, t.lo, t.lo + n, index);
                }
                index += n;
                FJRemoveAll p = t.next;
                if (p != null) {
                    index = FJRemoveAllDriver.inorderMove(p, index);
                }
                t = t.right;
            }
            return index;
        }
    }

    static final class FJLSelectAllDriver
    extends FJSelectAllDriver {
        long[] results;

        FJLSelectAllDriver(Prefix prefix) {
            super(prefix);
        }

        void createResults(int size) {
            this.results = new long[size];
        }

        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.prefix.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJDSelectAllDriver
    extends FJSelectAllDriver {
        double[] results;

        FJDSelectAllDriver(Prefix prefix) {
            super(prefix);
        }

        void createResults(int size) {
            this.results = new double[size];
        }

        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.prefix.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static final class FJRSelectAllDriver
    extends FJSelectAllDriver {
        final Class elementType;
        Object[] results;

        FJRSelectAllDriver(Prefix prefix, Class elementType) {
            super(prefix);
            this.elementType = elementType;
        }

        void createResults(int size) {
            this.results = (Object[])Array.newInstance(this.elementType, size);
        }

        void leafPhase1(int loIdx, int hiIdx, int offset) {
            this.prefix.leafTransferByIndex(this.indices, loIdx, hiIdx, this.results, offset);
        }
    }

    static abstract class FJSelectAllDriver
    extends RecursiveAction {
        final int[] indices;
        final Prefix prefix;
        int phase;

        FJSelectAllDriver(Prefix prefix) {
            this.prefix = prefix;
            int n = prefix.upperBound - prefix.firstIndex;
            this.indices = new int[n];
        }

        public final void compute() {
            FJSelectAll r = new FJSelectAll(this, this.prefix.firstIndex, this.prefix.upperBound);
            r.compute();
            this.createResults(r.count);
            this.phase = 1;
            r.compute();
        }

        abstract void createResults(int var1);

        abstract void leafPhase1(int var1, int var2, int var3);
    }

    static final class FJSelectAll
    extends RecursiveAction {
        final FJSelectAllDriver driver;
        FJSelectAll left;
        FJSelectAll right;
        final int lo;
        final int hi;
        int count;
        int offset;
        boolean isInternal;

        FJSelectAll(FJSelectAllDriver driver, int lo, int hi) {
            this.driver = driver;
            this.lo = lo;
            this.hi = hi;
        }

        public void compute() {
            FJSelectAllDriver d = this.driver;
            if (d.phase == 0) {
                Prefix p = d.prefix;
                this.isInternal = p.shouldSplit(this.hi - this.lo);
                if (this.isInternal) {
                    this.internalPhase0();
                } else {
                    this.count = p.leafIndexSelected(this.lo, this.hi, true, d.indices);
                }
            } else if (this.count != 0) {
                if (this.isInternal) {
                    this.internalPhase1();
                } else {
                    d.leafPhase1(this.lo, this.lo + this.count, this.offset);
                }
            }
        }

        void internalPhase0() {
            int rn;
            int mid = this.lo + this.hi >>> 1;
            FJSelectAll l = new FJSelectAll(this.driver, this.lo, mid);
            FJSelectAll r = new FJSelectAll(this.driver, mid, this.hi);
            FJSelectAll.forkJoin(l, r);
            int ln = l.count;
            if (ln != 0) {
                this.left = l;
            }
            if ((rn = r.count) != 0) {
                this.right = r;
            }
            this.count = ln + rn;
        }

        void internalPhase1() {
            int k = this.offset;
            if (this.left != null) {
                int ln = this.left.count;
                this.left.offset = k;
                this.left.reinitialize();
                if (this.right != null) {
                    this.right.offset = k + ln;
                    this.right.reinitialize();
                    FJSelectAll.forkJoin(this.left, this.right);
                } else {
                    this.left.compute();
                }
            } else if (this.right != null) {
                this.right.offset = k;
                this.right.compute();
            }
        }
    }

    static final class FJLIndexOf
    extends FJSearchBase {
        final long target;

        FJLIndexOf(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, long target) {
            super(prefix, lo, hi, next, result);
            this.target = target;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJLIndexOf(this.prefix, l, h, r, this.result, this.target);
        }

        void atLeaf(int l, int h) {
            long[] array = this.prefix.lgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target == array[i]) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJDIndexOf
    extends FJSearchBase {
        final double target;

        FJDIndexOf(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, double target) {
            super(prefix, lo, hi, next, result);
            this.target = target;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJDIndexOf(this.prefix, l, h, r, this.result, this.target);
        }

        void atLeaf(int l, int h) {
            double[] array = this.prefix.dgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target == array[i]) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJRIndexOf
    extends FJSearchBase {
        final Object target;

        FJRIndexOf(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, Object target) {
            super(prefix, lo, hi, next, result);
            this.target = target;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJRIndexOf(this.prefix, l, h, r, this.result, this.target);
        }

        void atLeaf(int l, int h) {
            Object[] array = this.prefix.rgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.target.equals(array[i])) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJLSelectAny
    extends FJSearchBase {
        final Ops.LongPredicate selector;

        FJLSelectAny(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, Ops.LongPredicate selector) {
            super(prefix, lo, hi, next, result);
            this.selector = selector;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJLSelectAny(this.prefix, l, h, r, this.result, this.selector);
        }

        void atLeaf(int l, int h) {
            long[] array = this.prefix.lgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.selector.evaluate(array[i])) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJDSelectAny
    extends FJSearchBase {
        final Ops.DoublePredicate selector;

        FJDSelectAny(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, Ops.DoublePredicate selector) {
            super(prefix, lo, hi, next, result);
            this.selector = selector;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJDSelectAny(this.prefix, l, h, r, this.result, this.selector);
        }

        void atLeaf(int l, int h) {
            double[] array = this.prefix.dgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.selector.evaluate(array[i])) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static final class FJRSelectAny
    extends FJSearchBase {
        final Ops.Predicate selector;

        FJRSelectAny(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result, Ops.Predicate selector) {
            super(prefix, lo, hi, next, result);
            this.selector = selector;
        }

        FJSearchBase newSubtask(int l, int h, FJSearchBase r) {
            return new FJRSelectAny(this.prefix, l, h, r, this.result, this.selector);
        }

        void atLeaf(int l, int h) {
            Object[] array = this.prefix.rgetArray();
            if (array == null) {
                return;
            }
            for (int i = l; i < h; ++i) {
                if (this.selector.evaluate(array[i])) {
                    this.result.compareAndSet(-1, i);
                    break;
                }
                if (this.result.get() >= 0) break;
            }
        }
    }

    static abstract class FJSearchBase
    extends RecursiveAction {
        final Prefix prefix;
        final int lo;
        final int hi;
        final FJSearchBase next;
        final AtomicInteger result;

        FJSearchBase(Prefix prefix, int lo, int hi, FJSearchBase next, AtomicInteger result) {
            this.prefix = prefix;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
            this.result = result;
        }

        public void compute() {
            if (this.result.get() >= 0) {
                return;
            }
            FJSearchBase r = null;
            int l = this.lo;
            int h = this.hi;
            while (this.prefix.shouldSplit(h - l)) {
                int rh = h;
                h = l + h >>> 1;
                r = this.newSubtask(h, rh, r);
                r.fork();
            }
            this.atLeaf(l, h);
            boolean stopping = false;
            while (r != null) {
                stopping |= this.result.get() >= 0;
                if (ForkJoinWorkerThread.removeIfNextLocalTask(r)) {
                    if (!stopping) {
                        r.atLeaf(r.lo, r.hi);
                    }
                } else if (stopping) {
                    r.cancel();
                } else {
                    r.join();
                }
                r = r.next;
            }
        }

        abstract FJSearchBase newSubtask(int var1, int var2, FJSearchBase var3);

        abstract void atLeaf(int var1, int var2);
    }

    static final class FJLCountSelected
    extends FJBase {
        final Ops.LongPredicate selector;
        int count;

        FJLCountSelected(Prefix prefix, int lo, int hi, FJBase next, Ops.LongPredicate selector) {
            super(prefix, lo, hi, next);
            this.selector = selector;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLCountSelected(this.prefix, l, h, r, this.selector);
        }

        void onReduce(FJBase right) {
            this.count += ((FJLCountSelected)right).count;
        }

        void atLeaf(int l, int h) {
            long[] array = this.prefix.lgetArray();
            if (array == null) {
                return;
            }
            Ops.LongPredicate sel = this.selector;
            int n = 0;
            for (int i = l; i < h; ++i) {
                if (!sel.evaluate(array[i])) continue;
                ++n;
            }
            this.count = n;
        }
    }

    static final class FJDCountSelected
    extends FJBase {
        final Ops.DoublePredicate selector;
        int count;

        FJDCountSelected(Prefix prefix, int lo, int hi, FJBase next, Ops.DoublePredicate selector) {
            super(prefix, lo, hi, next);
            this.selector = selector;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDCountSelected(this.prefix, l, h, r, this.selector);
        }

        void onReduce(FJBase right) {
            this.count += ((FJDCountSelected)right).count;
        }

        void atLeaf(int l, int h) {
            double[] array = this.prefix.dgetArray();
            if (array == null) {
                return;
            }
            Ops.DoublePredicate sel = this.selector;
            int n = 0;
            for (int i = l; i < h; ++i) {
                if (!sel.evaluate(array[i])) continue;
                ++n;
            }
            this.count = n;
        }
    }

    static final class FJRCountSelected
    extends FJBase {
        final Ops.Predicate selector;
        int count;

        FJRCountSelected(Prefix prefix, int lo, int hi, FJBase next, Ops.Predicate selector) {
            super(prefix, lo, hi, next);
            this.selector = selector;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRCountSelected(this.prefix, l, h, r, this.selector);
        }

        void onReduce(FJBase right) {
            this.count += ((FJRCountSelected)right).count;
        }

        void atLeaf(int l, int h) {
            Object[] array = this.prefix.rgetArray();
            if (array == null) {
                return;
            }
            Ops.Predicate sel = this.selector;
            int n = 0;
            for (int i = l; i < h; ++i) {
                if (!sel.evaluate(array[i])) continue;
                ++n;
            }
            this.count = n;
        }
    }

    static final class FJLStats
    extends FJBase
    implements ParallelLongArray.SummaryStatistics {
        final Ops.LongComparator comparator;
        int size;
        long min;
        long max;
        long sum;
        int indexOfMin;
        int indexOfMax;

        public int size() {
            return this.size;
        }

        public long min() {
            return this.min;
        }

        public long max() {
            return this.max;
        }

        public long sum() {
            return this.sum;
        }

        public double average() {
            return (double)this.sum / (double)this.size;
        }

        public int indexOfMin() {
            return this.indexOfMin;
        }

        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJLStats(Prefix prefix, int lo, int hi, FJBase next, Ops.LongComparator comparator) {
            super(prefix, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLStats(this.prefix, l, h, r, this.comparator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafStats(l, h, this);
        }

        void onReduce(FJBase right) {
            FJLStats r = (FJLStats)right;
            this.size += r.size;
            this.sum += r.sum;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, long x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, long x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ") sum: " + this.sum;
        }
    }

    static final class FJDStats
    extends FJBase
    implements ParallelDoubleArray.SummaryStatistics {
        final Ops.DoubleComparator comparator;
        int size;
        double min;
        double max;
        double sum;
        int indexOfMin;
        int indexOfMax;

        public int size() {
            return this.size;
        }

        public double min() {
            return this.min;
        }

        public double max() {
            return this.max;
        }

        public double sum() {
            return this.sum;
        }

        public double average() {
            return this.sum / (double)this.size;
        }

        public int indexOfMin() {
            return this.indexOfMin;
        }

        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJDStats(Prefix prefix, int lo, int hi, FJBase next, Ops.DoubleComparator comparator) {
            super(prefix, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDStats(this.prefix, l, h, r, this.comparator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafStats(l, h, this);
        }

        void onReduce(FJBase right) {
            FJDStats r = (FJDStats)right;
            this.size += r.size;
            this.sum += r.sum;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, double x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, double x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ") sum: " + this.sum;
        }
    }

    static final class FJRStats
    extends FJBase
    implements ParallelArray.SummaryStatistics {
        final Comparator comparator;
        int size;
        Object min;
        Object max;
        int indexOfMin;
        int indexOfMax;

        public int size() {
            return this.size;
        }

        public Object min() {
            return this.min;
        }

        public Object max() {
            return this.max;
        }

        public int indexOfMin() {
            return this.indexOfMin;
        }

        public int indexOfMax() {
            return this.indexOfMax;
        }

        FJRStats(Prefix prefix, int lo, int hi, FJBase next, Comparator comparator) {
            super(prefix, lo, hi, next);
            this.comparator = comparator;
            this.indexOfMin = -1;
            this.indexOfMax = -1;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRStats(this.prefix, l, h, r, this.comparator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafStats(l, h, this);
        }

        void onReduce(FJBase right) {
            FJRStats r = (FJRStats)right;
            this.size += r.size;
            this.updateMin(r.indexOfMin, r.min);
            this.updateMax(r.indexOfMax, r.max);
        }

        void updateMin(int i, Object x) {
            if (i >= 0 && (this.indexOfMin < 0 || this.comparator.compare(this.min, x) > 0)) {
                this.min = x;
                this.indexOfMin = i;
            }
        }

        void updateMax(int i, Object x) {
            if (i >= 0 && (this.indexOfMax < 0 || this.comparator.compare(this.max, x) < 0)) {
                this.max = x;
                this.indexOfMax = i;
            }
        }

        public String toString() {
            return "size: " + this.size + " min: " + this.min + " (index " + this.indexOfMin + ") max: " + this.max + " (index " + this.indexOfMax + ")";
        }
    }

    static final class FJLCombine
    extends FJBase {
        final long[] other;
        final long[] dest;
        final int otherOffset;
        final Ops.LongReducer combiner;

        FJLCombine(Prefix prefix, int lo, int hi, FJBase next, long[] other, int otherOffset, long[] dest, Ops.LongReducer combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.dest = dest;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLCombine(this.prefix, l, h, r, this.other, this.otherOffset, this.dest, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombine(l, h, this.other, this.otherOffset, this.dest, this.combiner);
        }
    }

    static final class FJDCombine
    extends FJBase {
        final double[] other;
        final double[] dest;
        final int otherOffset;
        final Ops.DoubleReducer combiner;

        FJDCombine(Prefix prefix, int lo, int hi, FJBase next, double[] other, int otherOffset, double[] dest, Ops.DoubleReducer combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.dest = dest;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDCombine(this.prefix, l, h, r, this.other, this.otherOffset, this.dest, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombine(l, h, this.other, this.otherOffset, this.dest, this.combiner);
        }
    }

    static final class FJRCombine
    extends FJBase {
        final Object[] other;
        final Object[] dest;
        final int otherOffset;
        final Ops.Combiner combiner;

        FJRCombine(Prefix prefix, int lo, int hi, FJBase next, Object[] other, int otherOffset, Object[] dest, Ops.Combiner combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.dest = dest;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRCombine(this.prefix, l, h, r, this.other, this.otherOffset, this.dest, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombine(l, h, this.other, this.otherOffset, this.dest, this.combiner);
        }
    }

    static final class FJLCombineInPlace
    extends FJBase {
        final long[] other;
        final int otherOffset;
        final Ops.LongReducer combiner;

        FJLCombineInPlace(Prefix prefix, int lo, int hi, FJBase next, long[] other, int otherOffset, Ops.LongReducer combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLCombineInPlace(this.prefix, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJDCombineInPlace
    extends FJBase {
        final double[] other;
        final int otherOffset;
        final Ops.DoubleReducer combiner;

        FJDCombineInPlace(Prefix prefix, int lo, int hi, FJBase next, double[] other, int otherOffset, Ops.DoubleReducer combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDCombineInPlace(this.prefix, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJRCombineInPlace
    extends FJBase {
        final Object[] other;
        final int otherOffset;
        final Ops.Reducer combiner;

        FJRCombineInPlace(Prefix prefix, int lo, int hi, FJBase next, Object[] other, int otherOffset, Ops.Reducer combiner) {
            super(prefix, lo, hi, next);
            this.other = other;
            this.otherOffset = otherOffset;
            this.combiner = combiner;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRCombineInPlace(this.prefix, l, h, r, this.other, this.otherOffset, this.combiner);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafCombineInPlace(l, h, this.other, this.otherOffset, this.combiner);
        }
    }

    static final class FJLFill
    extends FJBase {
        final long value;

        FJLFill(Prefix prefix, int lo, int hi, FJBase next, long value) {
            super(prefix, lo, hi, next);
            this.value = value;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLFill(this.prefix, l, h, r, this.value);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafFillValue(l, h, this.value);
        }
    }

    static final class FJDFill
    extends FJBase {
        final double value;

        FJDFill(Prefix prefix, int lo, int hi, FJBase next, double value) {
            super(prefix, lo, hi, next);
            this.value = value;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDFill(this.prefix, l, h, r, this.value);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafFillValue(l, h, this.value);
        }
    }

    static final class FJRFill
    extends FJBase {
        final Object value;

        FJRFill(Prefix prefix, int lo, int hi, FJBase next, Object value) {
            super(prefix, lo, hi, next);
            this.value = value;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRFill(this.prefix, l, h, r, this.value);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafFillValue(l, h, this.value);
        }
    }

    static final class FJLGenerate
    extends FJBase {
        final Ops.LongGenerator generator;

        FJLGenerate(Prefix prefix, int lo, int hi, FJBase next, Ops.LongGenerator generator) {
            super(prefix, lo, hi, next);
            this.generator = generator;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLGenerate(this.prefix, l, h, r, this.generator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJDGenerate
    extends FJBase {
        final Ops.DoubleGenerator generator;

        FJDGenerate(Prefix prefix, int lo, int hi, FJBase next, Ops.DoubleGenerator generator) {
            super(prefix, lo, hi, next);
            this.generator = generator;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDGenerate(this.prefix, l, h, r, this.generator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJRGenerate
    extends FJBase {
        final Ops.Generator generator;

        FJRGenerate(Prefix prefix, int lo, int hi, FJBase next, Ops.Generator generator) {
            super(prefix, lo, hi, next);
            this.generator = generator;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRGenerate(this.prefix, l, h, r, this.generator);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafGenerate(l, h, this.generator);
        }
    }

    static final class FJLIndexMap
    extends FJBase {
        final Ops.MapperFromIntToLong mapper;

        FJLIndexMap(Prefix prefix, int lo, int hi, FJBase next, Ops.MapperFromIntToLong mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLIndexMap(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafIndexMap(l, h, this.mapper);
        }
    }

    static final class FJDIndexMap
    extends FJBase {
        final Ops.MapperFromIntToDouble mapper;

        FJDIndexMap(Prefix prefix, int lo, int hi, FJBase next, Ops.MapperFromIntToDouble mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDIndexMap(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafIndexMap(l, h, this.mapper);
        }
    }

    static final class FJRIndexMap
    extends FJBase {
        final Ops.MapperFromInt mapper;

        FJRIndexMap(Prefix prefix, int lo, int hi, FJBase next, Ops.MapperFromInt mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRIndexMap(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafIndexMap(l, h, this.mapper);
        }
    }

    static final class FJLTransform
    extends FJBase {
        final Ops.LongMapper mapper;

        FJLTransform(Prefix prefix, int lo, int hi, FJBase next, Ops.LongMapper mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLTransform(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransform(l, h, this.mapper);
        }
    }

    static final class FJDTransform
    extends FJBase {
        final Ops.DoubleMapper mapper;

        FJDTransform(Prefix prefix, int lo, int hi, FJBase next, Ops.DoubleMapper mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDTransform(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransform(l, h, this.mapper);
        }
    }

    static final class FJRTransform
    extends FJBase {
        final Ops.Mapper mapper;

        FJRTransform(Prefix prefix, int lo, int hi, FJBase next, Ops.Mapper mapper) {
            super(prefix, lo, hi, next);
            this.mapper = mapper;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRTransform(this.prefix, l, h, r, this.mapper);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransform(l, h, this.mapper);
        }
    }

    static final class FJLMap
    extends FJBase {
        final long[] dest;
        final int offset;

        FJLMap(Prefix prefix, int lo, int hi, FJBase next, long[] dest, int offset) {
            super(prefix, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLMap(this.prefix, l, h, r, this.dest, this.offset);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransfer(l, h, this.dest, l - this.offset);
        }
    }

    static final class FJDMap
    extends FJBase {
        final double[] dest;
        final int offset;

        FJDMap(Prefix prefix, int lo, int hi, FJBase next, double[] dest, int offset) {
            super(prefix, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDMap(this.prefix, l, h, r, this.dest, this.offset);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransfer(l, h, this.dest, l - this.offset);
        }
    }

    static final class FJRMap
    extends FJBase {
        final Object[] dest;
        final int offset;

        FJRMap(Prefix prefix, int lo, int hi, FJBase next, Object[] dest, int offset) {
            super(prefix, lo, hi, next);
            this.dest = dest;
            this.offset = offset;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRMap(this.prefix, l, h, r, this.dest, this.offset);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafTransfer(l, h, this.dest, l - this.offset);
        }
    }

    static final class FJLReduce
    extends FJBase {
        final Ops.LongReducer reducer;
        long result;

        FJLReduce(Prefix prefix, int lo, int hi, FJBase next, Ops.LongReducer reducer, long base) {
            super(prefix, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLReduce(this.prefix, l, h, r, this.reducer, this.result);
        }

        void atLeaf(int l, int h) {
            this.result = this.prefix.leafReduce(l, h, this.reducer, this.result);
        }

        void onReduce(FJBase right) {
            this.result = this.reducer.combine(this.result, ((FJLReduce)right).result);
        }
    }

    static final class FJDReduce
    extends FJBase {
        final Ops.DoubleReducer reducer;
        double result;

        FJDReduce(Prefix prefix, int lo, int hi, FJBase next, Ops.DoubleReducer reducer, double base) {
            super(prefix, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDReduce(this.prefix, l, h, r, this.reducer, this.result);
        }

        void atLeaf(int l, int h) {
            this.result = this.prefix.leafReduce(l, h, this.reducer, this.result);
        }

        void onReduce(FJBase right) {
            this.result = this.reducer.combine(this.result, ((FJDReduce)right).result);
        }
    }

    static final class FJRReduce
    extends FJBase {
        final Ops.Reducer reducer;
        Object result;

        FJRReduce(Prefix prefix, int lo, int hi, FJBase next, Ops.Reducer reducer, Object base) {
            super(prefix, lo, hi, next);
            this.reducer = reducer;
            this.result = base;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRReduce(this.prefix, l, h, r, this.reducer, this.result);
        }

        void atLeaf(int l, int h) {
            this.result = this.prefix.leafReduce(l, h, this.reducer, this.result);
        }

        void onReduce(FJBase right) {
            this.result = this.reducer.combine(this.result, ((FJRReduce)right).result);
        }
    }

    static final class FJLApply
    extends FJBase {
        final Ops.LongProcedure procedure;

        FJLApply(Prefix prefix, int lo, int hi, FJBase next, Ops.LongProcedure procedure) {
            super(prefix, lo, hi, next);
            this.procedure = procedure;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJLApply(this.prefix, l, h, r, this.procedure);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafApply(l, h, this.procedure);
        }
    }

    static final class FJDApply
    extends FJBase {
        final Ops.DoubleProcedure procedure;

        FJDApply(Prefix prefix, int lo, int hi, FJBase next, Ops.DoubleProcedure procedure) {
            super(prefix, lo, hi, next);
            this.procedure = procedure;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJDApply(this.prefix, l, h, r, this.procedure);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafApply(l, h, this.procedure);
        }
    }

    static final class FJRApply
    extends FJBase {
        final Ops.Procedure procedure;

        FJRApply(Prefix prefix, int lo, int hi, FJBase next, Ops.Procedure procedure) {
            super(prefix, lo, hi, next);
            this.procedure = procedure;
        }

        FJBase newSubtask(int l, int h, FJBase r) {
            return new FJRApply(this.prefix, l, h, r, this.procedure);
        }

        void atLeaf(int l, int h) {
            this.prefix.leafApply(l, h, this.procedure);
        }
    }

    static abstract class FJBase
    extends RecursiveAction {
        final Prefix prefix;
        final int lo;
        final int hi;
        final FJBase next;

        FJBase(Prefix prefix, int lo, int hi, FJBase next) {
            this.prefix = prefix;
            this.lo = lo;
            this.hi = hi;
            this.next = next;
        }

        public final void compute() {
            ForkJoinTask r = null;
            int l = this.lo;
            int h = this.hi;
            while (this.prefix.shouldSplit(h - l)) {
                int rh = h;
                h = l + h >>> 1;
                r = this.newSubtask(h, rh, (FJBase)r);
                r.fork();
            }
            this.atLeaf(l, h);
            while (r != null) {
                if (ForkJoinWorkerThread.removeIfNextLocalTask(r)) {
                    ((FJBase)r).atLeaf(((FJBase)r).lo, ((FJBase)r).hi);
                } else {
                    r.join();
                }
                this.onReduce((FJBase)r);
                r = ((FJBase)r).next;
            }
        }

        abstract void atLeaf(int var1, int var2);

        void onReduce(FJBase right) {
        }

        abstract FJBase newSubtask(int var1, int var2, FJBase var3);
    }

    static abstract class LPrefix
    extends Prefix {
        final ParallelLongArray pa;

        LPrefix(ParallelLongArray pa, int firstIndex, int upperBound) {
            super(pa.ex, firstIndex, upperBound);
            this.pa = pa;
        }

        final Object[] rgetArray() {
            return null;
        }

        final double[] dgetArray() {
            return null;
        }

        final long[] lgetArray() {
            return this.pa.array;
        }

        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            long[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }
    }

    static abstract class DPrefix
    extends Prefix {
        final ParallelDoubleArray pa;

        DPrefix(ParallelDoubleArray pa, int firstIndex, int upperBound) {
            super(pa.ex, firstIndex, upperBound);
            this.pa = pa;
        }

        final Object[] rgetArray() {
            return null;
        }

        final double[] dgetArray() {
            return this.pa.array;
        }

        final long[] lgetArray() {
            return null;
        }

        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            double[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }
    }

    static abstract class RPrefix
    extends Prefix {
        final ParallelArray pa;

        RPrefix(ParallelArray pa, int firstIndex, int upperBound) {
            super(pa.ex, firstIndex, upperBound);
            this.pa = pa;
        }

        final Object[] rgetArray() {
            return this.pa.array;
        }

        final double[] dgetArray() {
            return null;
        }

        final long[] lgetArray() {
            return null;
        }

        final void leafMoveByIndex(int[] indices, int loIdx, int hiIdx, int offset) {
            T[] array = this.pa.array;
            for (int i = loIdx; i < hiIdx; ++i) {
                array[offset++] = array[indices[i]];
            }
        }
    }

    static abstract class Prefix {
        final ForkJoinExecutor ex;
        final int firstIndex;
        final int upperBound;
        final int threshold;

        Prefix(ForkJoinExecutor ex, int firstIndex, int upperBound) {
            this.ex = ex;
            this.firstIndex = firstIndex;
            this.upperBound = upperBound;
            int n = upperBound - firstIndex;
            int p = ex.getParallelismLevel();
            this.threshold = Prefix.defaultSequentialThreshold(n, p);
        }

        static int defaultSequentialThreshold(int size, int procs) {
            return procs > 1 ? 1 + size / (procs << 3) : size;
        }

        final boolean shouldSplit(int n) {
            return n > this.threshold;
        }

        abstract Object[] rgetArray();

        abstract double[] dgetArray();

        abstract long[] lgetArray();

        void leafApply(int lo, int hi, Ops.Procedure procedure) {
        }

        void leafApply(int lo, int hi, Ops.DoubleProcedure procedure) {
        }

        void leafApply(int lo, int hi, Ops.LongProcedure procedure) {
        }

        Object leafReduce(int lo, int hi, Ops.Reducer reducer, Object base) {
            return null;
        }

        double leafReduce(int lo, int hi, Ops.DoubleReducer reducer, double base) {
            return 0.0;
        }

        long leafReduce(int lo, int hi, Ops.LongReducer reducer, long base) {
            return 0L;
        }

        void leafStats(int lo, int hi, FJRStats task) {
        }

        void leafStats(int lo, int hi, FJDStats task) {
        }

        void leafStats(int lo, int hi, FJLStats task) {
        }

        void leafTransfer(int lo, int hi, Object[] dest, int offset) {
        }

        void leafTransfer(int lo, int hi, double[] dest, int offset) {
        }

        void leafTransfer(int lo, int hi, long[] dest, int offset) {
        }

        void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, Object[] dest, int offset) {
        }

        void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, double[] dest, int offset) {
        }

        void leafTransferByIndex(int[] indices, int loIdx, int hiIdx, long[] dest, int offset) {
        }

        void leafCombineInPlace(int lo, int hi, Object[] other, int otherOffset, Ops.Reducer combiner) {
        }

        void leafCombineInPlace(int lo, int hi, double[] other, int otherOffset, Ops.DoubleReducer combiner) {
        }

        void leafCombineInPlace(int lo, int hi, long[] other, int otherOffset, Ops.LongReducer combiner) {
        }

        void leafCombine(int lo, int hi, Object[] other, int otherOffset, Object[] dest, Ops.Combiner combiner) {
        }

        void leafCombine(int lo, int hi, long[] other, int otherOffset, long[] dest, Ops.LongReducer combiner) {
        }

        void leafCombine(int lo, int hi, double[] other, int otherOffset, double[] dest, Ops.DoubleReducer combiner) {
        }

        void leafTransform(int lo, int hi, Ops.Mapper mapper) {
        }

        void leafTransform(int lo, int hi, Ops.DoubleMapper mapper) {
        }

        void leafTransform(int lo, int hi, Ops.LongMapper mapper) {
        }

        void leafIndexMap(int lo, int hi, Ops.MapperFromInt mapper) {
        }

        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToDouble mapper) {
        }

        void leafIndexMap(int lo, int hi, Ops.MapperFromIntToLong mapper) {
        }

        void leafGenerate(int lo, int hi, Ops.Generator generator) {
        }

        void leafGenerate(int lo, int hi, Ops.DoubleGenerator generator) {
        }

        void leafGenerate(int lo, int hi, Ops.LongGenerator generator) {
        }

        void leafFillValue(int lo, int hi, Object value) {
        }

        void leafFillValue(int lo, int hi, double value) {
        }

        void leafFillValue(int lo, int hi, long value) {
        }

        int leafIndexSelected(int lo, int hi, boolean positive, int[] indices) {
            return 0;
        }

        int leafMoveSelected(int lo, int hi, int offset, boolean positive) {
            return 0;
        }

        abstract void leafMoveByIndex(int[] var1, int var2, int var3, int var4);
    }
}

