/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.webflow.execution;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.definition.registry.NoSuchFlowDefinitionException;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.execution.repository.FlowExecutionRestorationFailureException;
import org.springframework.webflow.execution.repository.snapshot.SnapshotUnmarshalException;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class GrailsFlowExecutorImpl
extends FlowExecutorImpl {
    private static final Log LOG = LogFactory.getLog(GrailsFlowExecutorImpl.class);
    FlowExecutionRepository executionRepository;

    public GrailsFlowExecutorImpl(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        super(definitionLocator, executionFactory, executionRepository);
        this.executionRepository = executionRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowExecutionResult resumeExecution(String flowExecutionKey, ExternalContext context) throws FlowException {
        block6: {
            FlowExecutionResult flowExecutionResult;
            try {
                ExternalContextHolder.setExternalContext((ExternalContext)context);
                FlowExecutionKey key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
                FlowExecution flowExecution = this.executionRepository.getFlowExecution(key);
                GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
                if (!this.isNotValidFlowDefinitionId(flowExecution, webRequest)) break block6;
                flowExecutionResult = super.launchExecution(webRequest.getControllerName() + "/" + webRequest.getActionName(), context.getRequestMap(), context);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                ExternalContextHolder.setExternalContext(null);
                throw throwable;
            }
            ExternalContextHolder.setExternalContext(null);
            return flowExecutionResult;
        }
        Object var8_9 = null;
        ExternalContextHolder.setExternalContext(null);
        try {
            return super.resumeExecution(flowExecutionKey, context);
        }
        catch (FlowExecutionRestorationFailureException e) {
            if (e.getCause() instanceof SnapshotUnmarshalException) {
                LOG.info((Object)"Classes changed during reload, restarting flow...");
                GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
                return super.launchExecution(webRequest.getControllerName() + "/" + webRequest.getActionName(), context.getRequestMap(), context);
            }
            throw e;
        }
    }

    private boolean isNotValidFlowDefinitionId(FlowExecution flowExecution, GrailsWebRequest webRequest) {
        FlowDefinitionLocator locator = this.getDefinitionLocator();
        String requestPath = webRequest.getControllerName() + "/" + webRequest.getActionName();
        try {
            locator.getFlowDefinition(requestPath);
            return false;
        }
        catch (NoSuchFlowDefinitionException e) {
            return true;
        }
    }
}

