/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.remote;

import groovyx.gpars.actor.Actor;
import groovyx.gpars.remote.LocalHostRegistry;
import groovyx.gpars.remote.LocalNode;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.remote.RemoteNode;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class LocalHost
extends SerialHandles {
    protected final HashMap<UUID, RemoteNode> remoteNodes = new HashMap();
    protected final Map<UUID, RemoteHost> remoteHosts = new HashMap<UUID, RemoteHost>();
    protected final Map<UUID, LocalNode> localNodes = new HashMap<UUID, LocalNode>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(LocalNode node) {
        Map<UUID, Object> map = this.localNodes;
        synchronized (map) {
            this.localNodes.put(node.getId(), node);
        }
        map = this.remoteNodes;
        synchronized (map) {
            for (RemoteNode n : this.remoteNodes.values()) {
                if (n.getId().equals(node.getId())) continue;
                node.onConnect(n);
            }
        }
        map = this.remoteHosts;
        synchronized (map) {
            for (RemoteHost host : this.remoteHosts.values()) {
                host.connect(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(LocalNode node) {
        Map<UUID, Object> map = this.remoteHosts;
        synchronized (map) {
            for (RemoteHost host : this.remoteHosts.values()) {
                host.disconnect(node);
            }
        }
        map = this.remoteNodes;
        synchronized (map) {
            for (RemoteNode n : this.remoteNodes.values()) {
                if (n.getId().equals(node.getId())) continue;
                node.onDisconnect(n);
            }
        }
        map = this.localNodes;
        synchronized (map) {
            this.localNodes.remove(node.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ArrayList<Object> copy;
        Map<UUID, Object> map = this.localNodes;
        synchronized (map) {
            copy = new ArrayList<LocalNode>(this.localNodes.values());
            this.localNodes.clear();
            for (LocalNode localNode : copy) {
                this.disconnect(localNode);
            }
        }
        map = this.remoteHosts;
        synchronized (map) {
            copy = new ArrayList<RemoteHost>(this.remoteHosts.values());
            this.remoteHosts.clear();
            for (RemoteHost remoteHost : copy) {
                remoteHost.disconnect();
            }
        }
        LocalHostRegistry.removeLocalHost(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialContext getSerialHost(UUID hostId, Object conn) {
        RemoteConnection connection = (RemoteConnection)conn;
        Map<UUID, RemoteHost> map = this.remoteHosts;
        synchronized (map) {
            RemoteHost host = this.remoteHosts.get(hostId);
            if (host == null) {
                host = new RemoteHost(this, hostId);
                this.remoteHosts.put(hostId, host);
            }
            if (connection != null) {
                connection.setHost(host);
                host.addConnection(connection);
            }
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectRemoteNode(UUID nodeId, SerialContext host, Actor mainActor) {
        RemoteNode node;
        Map<UUID, Object> map = this.remoteNodes;
        synchronized (map) {
            node = this.remoteNodes.get(nodeId);
            if (node == null) {
                node = new RemoteNode(nodeId, host, mainActor);
                this.remoteNodes.put(nodeId, node);
            }
        }
        map = this.localNodes;
        synchronized (map) {
            for (LocalNode localNode : this.localNodes.values()) {
                localNode.onConnect(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectRemoteNode(UUID nodeId) {
        RemoteNode node;
        Map<UUID, Object> map = this.remoteNodes;
        synchronized (map) {
            node = this.remoteNodes.remove(nodeId);
        }
        if (node != null) {
            map = this.localNodes;
            synchronized (map) {
                for (LocalNode localNode : this.localNodes.values()) {
                    localNode.onDisconnect(node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisconnect(SerialContext host) {
        ArrayList<RemoteNode> toRemove = new ArrayList<RemoteNode>();
        Map<UUID, Object> map = this.remoteNodes;
        synchronized (map) {
            for (RemoteNode remoteNode : this.remoteNodes.values()) {
                if (remoteNode.getRemoteHost() != host) continue;
                toRemove.add(remoteNode);
            }
            for (RemoteNode<Object> remoteNode : toRemove) {
                this.remoteNodes.remove(remoteNode.getId());
            }
        }
        map = this.localNodes;
        synchronized (map) {
            for (RemoteNode<Object> remoteNode : toRemove) {
                for (LocalNode localNode : this.localNodes.values()) {
                    localNode.onDisconnect(remoteNode);
                }
            }
        }
    }
}

