/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor.impl;

import groovy.lang.Closure;
import groovy.time.BaseDuration;
import groovyx.gpars.actor.Actor;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.impl.ActorReplyException;
import groovyx.gpars.actor.impl.MessageStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReceivingMessageStream
extends MessageStream {
    private final List<MessageStream> senders = new ArrayList<MessageStream>();
    protected final WeakHashMap<Object, MessageStream> obj2Sender = new WeakHashMap();

    protected final List<MessageStream> getSenders() {
        return this.senders;
    }

    protected final void reply(Object message) {
        assert (this.senders != null);
        if (this.senders.isEmpty()) {
            throw new ActorReplyException("Cannot send replies. The list of recipients is empty.");
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (MessageStream sender : this.senders) {
            if (sender != null) {
                try {
                    sender.send(message);
                }
                catch (IllegalStateException e) {
                    exceptions.add(e);
                }
                continue;
            }
            exceptions.add(new IllegalArgumentException(String.format("Cannot send a reply message %s to a null recipient.", message)));
        }
        if (!exceptions.isEmpty()) {
            throw new ActorReplyException("Failed sending some replies. See the issues field for details", exceptions);
        }
    }

    protected final void replyIfExists(Object message) {
        assert (this.senders != null);
        for (MessageStream sender : this.senders) {
            try {
                if (sender == null) continue;
                sender.send(message);
            }
            catch (IllegalStateException ignore) {}
        }
    }

    protected abstract Object receiveImpl() throws InterruptedException;

    protected abstract Object receiveImpl(long var1, TimeUnit var3) throws InterruptedException;

    protected final Object receive() throws InterruptedException {
        Object msg = this.receiveImpl();
        if (msg instanceof ActorMessage) {
            ActorMessage messageAndReply = (ActorMessage)msg;
            return messageAndReply.getPayLoad();
        }
        return msg;
    }

    protected final Object receive(long timeout, TimeUnit units) throws InterruptedException {
        Object msg = this.receiveImpl(timeout, units);
        if (msg instanceof ActorMessage) {
            ActorMessage messageAndReply = (ActorMessage)msg;
            return messageAndReply.getPayLoad();
        }
        return msg;
    }

    protected final Object receive(BaseDuration duration) throws InterruptedException {
        return this.receive(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public static final class ReplyCategory {
        private ReplyCategory() {
        }

        public static MessageStream getSender(Object original) {
            Actor actor = Actor.threadBoundActor();
            if (actor == null) {
                throw new IllegalStateException("message originator detection in a non-actor");
            }
            return actor.obj2Sender.get(original);
        }

        public static void reply(Object original, Object reply) {
            if (original instanceof ReceivingMessageStream) {
                ((ReceivingMessageStream)original).reply(reply);
                return;
            }
            if (original instanceof Closure) {
                ((ReceivingMessageStream)((Closure)original).getDelegate()).reply(reply);
                return;
            }
            Actor actor = Actor.threadBoundActor();
            if (actor == null) {
                throw new IllegalStateException("reply from non-actor");
            }
            MessageStream sender = actor.obj2Sender.get(original);
            if (sender == null) {
                throw new IllegalStateException(MessageFormat.format("Cannot send a reply message {0} to a null recipient.", original.toString()));
            }
            sender.send(reply);
        }

        public static void replyIfExists(Object original, Object reply) {
            MessageStream sender;
            if (original instanceof ReceivingMessageStream) {
                ((ReceivingMessageStream)original).replyIfExists(reply);
                return;
            }
            if (original instanceof Closure) {
                ((ReceivingMessageStream)((Closure)original).getDelegate()).replyIfExists(reply);
                return;
            }
            Actor actor = Actor.threadBoundActor();
            if (actor != null && (sender = actor.obj2Sender.get(original)) != null) {
                try {
                    sender.send(reply);
                }
                catch (IllegalStateException ignored) {
                    // empty catch block
                }
            }
        }
    }
}

