/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.time.BaseDuration;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.actor.impl.ReceivingMessageStream;
import groovyx.gpars.dataflow.DataFlowExpression;
import groovyx.gpars.dataflow.DataFlowVariable;
import groovyx.gpars.remote.RemoteConnection;
import groovyx.gpars.remote.RemoteHost;
import groovyx.gpars.serial.DefaultRemoteHandle;
import groovyx.gpars.serial.RemoteHandle;
import groovyx.gpars.serial.RemoteSerialized;
import groovyx.gpars.serial.SerialContext;
import groovyx.gpars.serial.SerialHandle;
import groovyx.gpars.serial.SerialMsg;
import groovyx.gpars.serial.WithSerialId;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;

public abstract class Actor
extends ReceivingMessageStream {
    private static final ThreadLocal<Actor> currentActorPerThread = new ThreadLocal();
    private final DataFlowExpression joinLatch;

    protected Actor() {
        this(new DataFlowVariable());
    }

    protected Actor(DataFlowExpression joinLatch) {
        this.joinLatch = joinLatch;
    }

    public abstract Actor start();

    public abstract Actor stop();

    public abstract Actor terminate();

    public abstract boolean isActive();

    public abstract boolean isActorThread();

    public final void join() throws InterruptedException {
        this.joinLatch.getVal();
    }

    public final void join(MessageStream listener) throws InterruptedException {
        this.joinLatch.getValAsync(listener);
    }

    public final void join(long timeout, TimeUnit unit) throws InterruptedException {
        if (timeout > 0L) {
            this.joinLatch.getVal(timeout, unit);
        } else {
            this.joinLatch.getVal();
        }
    }

    public final void join(BaseDuration duration) throws InterruptedException {
        this.join(duration.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    public DataFlowExpression getJoinLatch() {
        return this.joinLatch;
    }

    protected static void registerCurrentActorWithThread(Actor currentActor) {
        currentActorPerThread.set(currentActor);
    }

    protected static void deregisterCurrentActorWithThread() {
        currentActorPerThread.set(null);
    }

    public static Actor threadBoundActor() {
        return currentActorPerThread.get();
    }

    protected RemoteHandle createRemoteHandle(SerialHandle handle, SerialContext host) {
        return new MyRemoteHandle(handle, host, this.joinLatch);
    }

    public static class RemoteActor
    extends Actor
    implements RemoteSerialized {
        private final RemoteHost remoteHost;
        private static final long serialVersionUID = -1375776678860848278L;

        public RemoteActor(SerialContext host, DataFlowExpression jointLatch) {
            super(jointLatch);
            this.remoteHost = (RemoteHost)host;
        }

        public Actor start() {
            throw new UnsupportedOperationException();
        }

        public Actor stop() {
            this.remoteHost.write(new StopActorMsg(this));
            return this;
        }

        public Actor terminate() {
            this.remoteHost.write(new TerminateActorMsg(this));
            return this;
        }

        public boolean isActive() {
            throw new UnsupportedOperationException();
        }

        public boolean isActorThread() {
            return false;
        }

        public MessageStream send(Object message) {
            if (!(message instanceof ActorMessage)) {
                message = new ActorMessage<Object>(message, RemoteActor.threadBoundActor());
            }
            this.remoteHost.write(new MessageStream.SendTo<Object>(this, message));
            return this;
        }

        protected Object receiveImpl() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        protected Object receiveImpl(long timeout, TimeUnit units) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        public static class TerminateActorMsg
        extends SerialMsg {
            private final Actor actor;
            private static final long serialVersionUID = -839334644951906974L;

            public TerminateActorMsg(RemoteActor remoteActor) {
                this.actor = remoteActor;
            }

            public void execute(RemoteConnection conn) {
                this.actor.terminate();
            }
        }

        public static class StopActorMsg
        extends SerialMsg {
            private final Actor actor;
            private static final long serialVersionUID = -927785591952534581L;

            public StopActorMsg(RemoteActor remoteActor) {
                this.actor = remoteActor;
            }

            public void execute(RemoteConnection conn) {
                this.actor.stop();
            }
        }
    }

    public static class MyRemoteHandle
    extends DefaultRemoteHandle {
        private final DataFlowExpression joinLatch;
        private static final long serialVersionUID = 3721849638877039035L;

        public MyRemoteHandle(SerialHandle handle, SerialContext host, DataFlowExpression joinLatch) {
            super(handle.getSerialId(), host.getHostId(), RemoteActor.class);
            this.joinLatch = joinLatch;
        }

        protected WithSerialId createObject(SerialContext context) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            return new RemoteActor(context, this.joinLatch);
        }
    }
}

