/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.actor;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.time.Duration;
import groovyx.gpars.actor.ActorMessage;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.actor.impl.SequentialProcessingActor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.runtime.InvokerHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPooledActor
extends SequentialProcessingActor {
    private volatile Closure onStop = null;
    private static final String THE_ACTOR_HAS_NOT_BEEN_STARTED = "The actor hasn't been started.";
    private static final String THE_ACTOR_HAS_BEEN_STOPPED = "The actor has been stopped.";
    private static final String RESPONDS_TO = "respondsTo";
    private static final String ON_DELIVERY_ERROR = "onDeliveryError";
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static final String AFTER_START = "afterStart";

    protected AbstractPooledActor() {
    }

    protected void act() {
        throw new UnsupportedOperationException("The act() method must be overridden");
    }

    private void enhanceReplies(Iterable<ActorMessage> messages) {
        List<MessageStream> senders = this.getSenders();
        senders.clear();
        for (ActorMessage message : messages) {
            senders.add(message == null ? null : message.getSender());
            if (message == null) continue;
            this.obj2Sender.put(message.getPayLoad(), message.getSender());
        }
    }

    @Override
    protected final Object receiveImpl() throws InterruptedException {
        if (this.stopFlag == 0) {
            throw new IllegalStateException(THE_ACTOR_HAS_NOT_BEEN_STARTED);
        }
        if (this.stopFlag == 12) {
            throw new IllegalStateException(THE_ACTOR_HAS_BEEN_STOPPED);
        }
        ActorMessage message = this.takeMessage();
        this.enhanceReplies(Arrays.asList(message));
        if (message == null) {
            return null;
        }
        return message.getPayLoad();
    }

    @Override
    protected final Object receiveImpl(long timeout, TimeUnit units) throws InterruptedException {
        if (this.stopFlag == 0) {
            throw new IllegalStateException(THE_ACTOR_HAS_NOT_BEEN_STARTED);
        }
        if (this.stopFlag == 12) {
            throw new IllegalStateException(THE_ACTOR_HAS_BEEN_STOPPED);
        }
        ActorMessage message = this.takeMessage(timeout, units);
        this.enhanceReplies(Arrays.asList(message));
        if (message == null) {
            return null;
        }
        return message.getPayLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receive(Closure handler) throws InterruptedException {
        handler.setResolveStrategy(1);
        handler.setDelegate((Object)this);
        ArrayList<ActorMessage> messages = new ArrayList<ActorMessage>();
        int maxNumberOfParameters = handler.getMaximumNumberOfParameters();
        int toReceive = maxNumberOfParameters == 0 ? 1 : maxNumberOfParameters;
        this.collectRequiredMessages(messages, toReceive);
        this.enhanceReplies(messages);
        try {
            if (maxNumberOfParameters == 0) {
                handler.call();
            } else {
                Object[] args = new Object[messages.size()];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = ((ActorMessage)messages.get(i)).getPayLoad();
                }
                handler.call(args);
            }
        }
        finally {
            this.getSenders().clear();
        }
    }

    private void collectRequiredMessages(Collection<ActorMessage> messages, int toReceive) throws InterruptedException {
        for (int i = 0; i != toReceive; ++i) {
            this.checkStopTerminate();
            messages.add(this.takeMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receive(long timeout, TimeUnit timeUnit, Closure handler) throws InterruptedException {
        handler.setResolveStrategy(1);
        handler.setDelegate((Object)this);
        int maxNumberOfParameters = handler.getMaximumNumberOfParameters();
        int toReceive = maxNumberOfParameters == 0 ? 1 : maxNumberOfParameters;
        long stopTime = timeUnit.toMillis(timeout) + System.currentTimeMillis();
        boolean nullAppeared = false;
        ArrayList<ActorMessage> messages = new ArrayList<ActorMessage>();
        for (int i = 0; i != toReceive; ++i) {
            if (nullAppeared) {
                messages.add(null);
                continue;
            }
            if (this.stopFlag != 1) {
                throw new IllegalStateException(THE_ACTOR_HAS_NOT_BEEN_STARTED);
            }
            ActorMessage message = this.takeMessage(Math.max(stopTime - System.currentTimeMillis(), 0L), TimeUnit.MILLISECONDS);
            nullAppeared = message == null;
            messages.add(message);
        }
        try {
            this.enhanceReplies(messages);
            if (maxNumberOfParameters == 0) {
                handler.call();
            } else {
                Object[] args = AbstractPooledActor.retrievePayloadOfMessages(messages);
                handler.call(args);
            }
        }
        finally {
            this.getSenders().clear();
        }
    }

    private static Object[] retrievePayloadOfMessages(List<ActorMessage> messages) {
        Object[] args = new Object[messages.size()];
        for (int i = 0; i < args.length; ++i) {
            ActorMessage am = messages.get(i);
            args[i] = am == null ? am : am.getPayLoad();
        }
        return args;
    }

    protected final void receive(Duration duration, Closure handler) throws InterruptedException {
        this.receive(duration.toMilliseconds(), TimeUnit.MILLISECONDS, handler);
    }

    final List sweepQueue() {
        ArrayList<ActorMessage> messages = new ArrayList<ActorMessage>();
        ActorMessage message = this.pollMessage();
        while (message != null) {
            Object payloadList = InvokerHelper.invokeMethod(message.getPayLoad(), (String)RESPONDS_TO, (Object)new Object[]{ON_DELIVERY_ERROR});
            if (payloadList != null && !((Collection)payloadList).isEmpty()) {
                InvokerHelper.invokeMethod(message.getPayLoad(), (String)ON_DELIVERY_ERROR, (Object)EMPTY_ARGUMENTS);
            } else {
                Object senderList = InvokerHelper.invokeMethod((Object)message.getSender(), (String)RESPONDS_TO, (Object)new Object[]{ON_DELIVERY_ERROR});
                if (senderList != null && !((Collection)senderList).isEmpty()) {
                    InvokerHelper.invokeMethod((Object)message.getSender(), (String)ON_DELIVERY_ERROR, (Object)EMPTY_ARGUMENTS);
                }
            }
            messages.add(message);
            message = this.pollMessage();
        }
        return messages;
    }

    public final void onStop(Closure onStop) {
        if (onStop != null) {
            this.onStop = (Closure)onStop.clone();
            this.onStop.setDelegate((Object)this);
            this.onStop.setResolveStrategy(1);
        }
    }

    @Override
    protected void doOnStart() {
        Object list = InvokerHelper.invokeMethod((Object)this, (String)RESPONDS_TO, (Object)new Object[]{AFTER_START});
        if (list != null && !((Collection)list).isEmpty()) {
            InvokerHelper.invokeMethod((Object)this, (String)AFTER_START, (Object)EMPTY_ARGUMENTS);
        }
        this.act();
    }

    @Override
    protected void doOnTimeout() {
        this.callDynamic("onTimeout", EMPTY_ARGUMENTS);
    }

    @Override
    protected void doOnTermination() {
        List queue = this.sweepQueue();
        if (this.onStop != null) {
            this.onStop.call((Object)queue);
        }
        this.callDynamic("afterStop", new Object[]{queue});
    }

    @Override
    protected void doOnException(Throwable exception) {
        if (!this.callDynamic("onException", new Object[]{exception})) {
            System.err.println("An exception occurred in the Actor thread " + Thread.currentThread().getName());
            exception.printStackTrace(System.err);
        }
    }

    @Override
    protected void doOnInterrupt(InterruptedException exception) {
        if (!this.callDynamic("onInterrupt", new Object[]{exception}) && this.stopFlag == 1) {
            System.err.println("The actor processing thread has been interrupted " + Thread.currentThread().getName());
            exception.printStackTrace(System.err);
        }
    }

    private boolean callDynamic(String method, Object[] args) {
        MetaClass metaClass = InvokerHelper.getMetaClass((Object)this);
        List list = metaClass.respondsTo((Object)this, method);
        if (list != null && !list.isEmpty()) {
            InvokerHelper.invokeMethod((Object)this, (String)method, (Object)args);
            return true;
        }
        return false;
    }
}

