/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.CouldNotDetermineHibernateDialectException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDialectDetectorFactoryBean
implements FactoryBean<String>,
InitializingBean {
    private DataSource dataSource;
    private Properties vendorNameDialectMappings;
    private String hibernateDialectClassName;
    private Dialect hibernateDialect;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setVendorNameDialectMappings(Properties mappings) {
        this.vendorNameDialectMappings = mappings;
    }

    public String getObject() {
        return this.hibernateDialectClassName;
    }

    public Class<String> getObjectType() {
        return String.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws MetaDataAccessException {
        Assert.notNull((Object)this.dataSource, (String)"Data source is not set!");
        Assert.notNull((Object)this.vendorNameDialectMappings, (String)"Vendor name/dialect mappings are not set!");
        String dbName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseProductName");
        Integer majorVersion = (Integer)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, (String)"getDatabaseMajorVersion");
        try {
            this.hibernateDialect = DialectFactory.determineDialect((String)dbName, (int)majorVersion);
            this.hibernateDialectClassName = this.hibernateDialect.getClass().getName();
        }
        catch (HibernateException e) {
            this.hibernateDialectClassName = this.vendorNameDialectMappings.getProperty(dbName);
        }
        if (StringUtils.isBlank((String)this.hibernateDialectClassName)) {
            throw new CouldNotDetermineHibernateDialectException("Could not determine Hibernate dialect for database name [" + dbName + "]!");
        }
    }
}

