/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.orm.HibernateCriteriaBuilder;
import groovy.lang.Closure;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.metaclass.AbstractStaticMethodInvocation;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStaticPersistentMethod
extends AbstractStaticMethodInvocation {
    private ClassLoader classLoader;
    private HibernateTemplate hibernateTemplate;

    protected AbstractStaticPersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, Pattern pattern) {
        Assert.notNull((Object)sessionFactory, (String)"Session factory is required!");
        this.setPattern(pattern);
        this.classLoader = classLoader;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
        this.hibernateTemplate.setCacheQueries(GrailsHibernateUtil.isCacheQueriesByDefault());
    }

    protected HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public Object invoke(Class clazz, String methodName, Object[] arguments) {
        return this.invoke(clazz, methodName, null, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Class clazz, String methodName, Closure additionalCriteria, Object[] arguments) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            Object object = this.doInvokeInternal(clazz, methodName, additionalCriteria, arguments);
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    protected Criteria getCriteria(Session session, Closure additionalCriteria, Class<?> clazz) {
        if (additionalCriteria != null) {
            HibernateCriteriaBuilder builder = new HibernateCriteriaBuilder(clazz, session.getSessionFactory());
            return builder.buildCriteria(additionalCriteria);
        }
        return session.createCriteria(clazz);
    }

    protected abstract Object doInvokeInternal(Class var1, String var2, Closure var3, Object[] var4);
}

